/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.failures.PendingStepFound;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.StepResult;

public abstract class AbstractStepResult
implements StepResult {
    protected final String step;
    protected final StepResult.Type type;
    protected final UUIDExceptionWrapper throwable;
    private String parametrisedStep;
    private long durationInMillis;

    public AbstractStepResult(StepResult.Type type, String step) {
        this(step, type, null);
    }

    public AbstractStepResult(String step, StepResult.Type type, UUIDExceptionWrapper throwable) {
        this.step = step;
        this.type = type;
        this.throwable = throwable;
    }

    public String parametrisedStep() {
        return this.parametrisedStep != null ? this.parametrisedStep : this.step;
    }

    public StepResult withParameterValues(String parametrisedStep) {
        this.parametrisedStep = parametrisedStep;
        return this;
    }

    public long durationInMillis() {
        return this.durationInMillis;
    }

    public StepResult withDurationInMillis(long millis) {
        this.durationInMillis = millis;
        return this;
    }

    public UUIDExceptionWrapper getFailure() {
        return this.throwable;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.parametrisedStep()).append(this.durationInMillis()).toString();
    }

    public static StepResult successful(String step) {
        return new Successful(step);
    }

    public static StepResult successful(Method method) {
        return new Successful(method);
    }

    public static StepResult ignorable(String step) {
        return new Ignorable(step);
    }

    public static StepResult pending(String step) {
        return new Pending(step);
    }

    public static StepResult pending(String step, PendingStepFound e) {
        return new Pending(step, e);
    }

    public static StepResult notPerformed(String step) {
        return new NotPerformed(step);
    }

    public static StepResult failed(String step, UUIDExceptionWrapper e) {
        return new Failed(step, e);
    }

    public static StepResult failed(Method method, UUIDExceptionWrapper e) {
        return new Failed(method, e);
    }

    public static StepResult silent(Method method) {
        return new Silent(method);
    }

    public static StepResult skipped() {
        return new Skipped();
    }

    private static String asString(Method method) {
        if (method == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            sb.append(type.getName());
            if (i + 1 >= types.length) continue;
            sb.append(",");
        }
        return sb.append(")").toString();
    }

    public static class Skipped
    extends AbstractStepResult {
        public Skipped() {
            super(StepResult.Type.SKIPPED, "");
        }

        public void describeTo(StoryReporter reporter) {
        }
    }

    public static class Ignorable
    extends AbstractStepResult {
        public Ignorable(String step) {
            super(StepResult.Type.IGNORABLE, step);
        }

        public void describeTo(StoryReporter reporter) {
            reporter.ignorable(this.step);
        }
    }

    public static class Silent
    extends Successful {
        public Silent(Method method) {
            super(method);
        }

        public void describeTo(StoryReporter reporter) {
        }
    }

    public static class Successful
    extends AbstractStepResult {
        public Successful(String step) {
            super(StepResult.Type.SUCCESSFUL, step);
        }

        public Successful(Method method) {
            super(StepResult.Type.SUCCESSFUL, AbstractStepResult.asString(method));
        }

        public void describeTo(StoryReporter reporter) {
            reporter.successful(this.parametrisedStep());
        }
    }

    public static class Pending
    extends AbstractStepResult {
        public Pending(String step) {
            this(step, new PendingStepFound(step));
        }

        public Pending(String step, PendingStepFound e) {
            super(step, StepResult.Type.PENDING, e);
        }

        public void describeTo(StoryReporter reporter) {
            reporter.pending(this.parametrisedStep());
        }
    }

    public static class NotPerformed
    extends AbstractStepResult {
        public NotPerformed(String step) {
            super(StepResult.Type.NOT_PERFORMED, step);
        }

        public void describeTo(StoryReporter reporter) {
            reporter.notPerformed(this.parametrisedStep());
        }
    }

    public static class Failed
    extends AbstractStepResult {
        public Failed(String step, UUIDExceptionWrapper throwable) {
            super(step, StepResult.Type.FAILED, throwable);
        }

        public Failed(Method method, UUIDExceptionWrapper throwable) {
            super(AbstractStepResult.asString(method), StepResult.Type.FAILED, throwable);
        }

        public void describeTo(StoryReporter reporter) {
            if (this.throwable.getCause() instanceof OutcomesTable.OutcomesFailed) {
                reporter.failedOutcomes(this.parametrisedStep(), ((OutcomesTable.OutcomesFailed)this.throwable.getCause()).outcomesTable());
            } else {
                reporter.failed(this.parametrisedStep(), this.throwable);
            }
        }
    }
}

