/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStories;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStories;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.AbstractStepsFactory;
import org.junit.After;
import org.junit.Before;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanningStepsFactory
extends AbstractStepsFactory {
    private final Set<Class<?>> types = new HashSet();
    private String matchingRegex = ".*";
    private String notMatchingRegex = "";

    public ScanningStepsFactory(Configuration configuration, Class<?> root) {
        this(configuration, root.getPackage().getName());
    }

    public ScanningStepsFactory(Configuration configuration, String ... packageNames) {
        super(configuration);
        for (String packageName : packageNames) {
            this.types.addAll(this.scanTypes(packageName));
        }
    }

    public ScanningStepsFactory matchingNames(String matchingRegex) {
        this.matchingRegex = matchingRegex;
        return this;
    }

    public ScanningStepsFactory notMatchingNames(String notMatchingRegex) {
        this.notMatchingRegex = notMatchingRegex;
        return this;
    }

    private Set<Class<?>> scanTypes(String packageName) {
        Reflections reflections = new Reflections(packageName, new Scanner[]{new MethodAnnotationsScanner()});
        HashSet types = new HashSet();
        types.addAll(this.typesAnnotatedWith(reflections, Given.class));
        types.addAll(this.typesAnnotatedWith(reflections, When.class));
        types.addAll(this.typesAnnotatedWith(reflections, Then.class));
        types.addAll(this.typesAnnotatedWith(reflections, Before.class));
        types.addAll(this.typesAnnotatedWith(reflections, After.class));
        types.addAll(this.typesAnnotatedWith(reflections, BeforeScenario.class));
        types.addAll(this.typesAnnotatedWith(reflections, AfterScenario.class));
        types.addAll(this.typesAnnotatedWith(reflections, BeforeStory.class));
        types.addAll(this.typesAnnotatedWith(reflections, AfterStory.class));
        types.addAll(this.typesAnnotatedWith(reflections, BeforeStories.class));
        types.addAll(this.typesAnnotatedWith(reflections, AfterStories.class));
        return types;
    }

    private Set<Class<?>> typesAnnotatedWith(Reflections reflections, Class<? extends Annotation> annotation) {
        HashSet types = new HashSet();
        Set methodsAnnotatedWith = reflections.getMethodsAnnotatedWith(annotation);
        for (Method method : methodsAnnotatedWith) {
            types.add(method.getDeclaringClass());
        }
        return types;
    }

    @Override
    protected List<Class<?>> stepsTypes() {
        ArrayList matchingTypes = new ArrayList();
        for (Class<?> type : this.types) {
            String name = type.getName();
            if (!name.matches(this.matchingRegex) || name.matches(this.notMatchingRegex)) continue;
            matchingTypes.add(type);
        }
        return matchingTypes;
    }

    @Override
    public Object createInstanceOfType(Class<?> type) {
        Object instance;
        try {
            instance = type.newInstance();
        }
        catch (Exception e) {
            throw new AbstractStepsFactory.StepsInstanceNotFound(type, this);
        }
        return instance;
    }
}

