/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.model.Meta;

public class Lifecycle {
    public static final Lifecycle EMPTY = new Lifecycle();
    private List<Steps> before;
    private List<Steps> after;

    public Lifecycle() {
        this(Arrays.asList(new Steps[0]), Arrays.asList(new Steps[0]));
    }

    public Lifecycle(List<Steps> before, List<Steps> after) {
        this.before = before;
        this.after = after;
    }

    public Set<Scope> getScopes() {
        LinkedHashSet<Scope> scopes = new LinkedHashSet<Scope>();
        scopes.add(Scope.SCENARIO);
        scopes.add(Scope.STORY);
        return scopes;
    }

    public boolean hasBeforeSteps() {
        return !this.getBeforeSteps(Scope.SCENARIO).isEmpty() || !this.getBeforeSteps(Scope.STORY).isEmpty();
    }

    @Deprecated
    public List<String> getBeforeSteps() {
        return this.getBeforeSteps(Scope.SCENARIO);
    }

    public List<String> getBeforeSteps(Scope scope) {
        ArrayList<String> beforeSteps = new ArrayList<String>();
        for (Steps steps : this.before) {
            beforeSteps.addAll(this.stepsByScope(steps, scope));
        }
        return beforeSteps;
    }

    public boolean hasAfterSteps() {
        return !this.getAfterSteps(Scope.SCENARIO).isEmpty() || !this.getAfterSteps(Scope.STORY).isEmpty();
    }

    @Deprecated
    public List<String> getAfterSteps() {
        return this.getAfterSteps(Scope.SCENARIO);
    }

    public List<String> getAfterSteps(Scope scope) {
        ArrayList<String> afterSteps = new ArrayList<String>();
        for (Steps steps : this.after) {
            afterSteps.addAll(this.stepsByScope(steps, scope));
        }
        return afterSteps;
    }

    public Set<AfterScenario.Outcome> getOutcomes() {
        LinkedHashSet<AfterScenario.Outcome> outcomes = new LinkedHashSet<AfterScenario.Outcome>();
        for (Steps steps : this.after) {
            outcomes.add(steps.outcome);
        }
        return outcomes;
    }

    public MetaFilter getMetaFilter(AfterScenario.Outcome outcome) {
        for (Steps steps : this.after) {
            if (!outcome.equals((Object)steps.outcome) || !StringUtils.isNotBlank((String)steps.metaFilter)) continue;
            return new MetaFilter(steps.metaFilter);
        }
        return MetaFilter.EMPTY;
    }

    public List<String> getAfterSteps(AfterScenario.Outcome outcome) {
        return this.getAfterSteps(outcome, Meta.EMPTY);
    }

    public List<String> getAfterSteps(AfterScenario.Outcome outcome, Meta meta) {
        return this.getAfterSteps(Scope.SCENARIO, outcome, meta);
    }

    public List<String> getAfterSteps(Scope scope, AfterScenario.Outcome outcome) {
        return this.getAfterSteps(scope, outcome, Meta.EMPTY);
    }

    public List<String> getAfterSteps(Scope scope, AfterScenario.Outcome outcome, Meta meta) {
        MetaFilter filter = this.getMetaFilter(outcome);
        ArrayList<String> afterSteps = new ArrayList<String>();
        for (Steps steps : this.after) {
            if (!outcome.equals((Object)steps.outcome)) continue;
            if (meta.equals(Meta.EMPTY)) {
                afterSteps.addAll(this.stepsByScope(steps, scope));
                continue;
            }
            if (!filter.allow(meta)) continue;
            afterSteps.addAll(this.stepsByScope(steps, scope));
        }
        return afterSteps;
    }

    private List<String> stepsByScope(Steps steps, Scope scope) {
        if (steps.scope == scope) {
            return steps.steps;
        }
        return Steps.EMPTY.steps;
    }

    public boolean isEmpty() {
        return EMPTY == this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class Steps {
        public static Steps EMPTY = new Steps(Arrays.asList(new String[0]));
        private Scope scope;
        private AfterScenario.Outcome outcome;
        private String metaFilter;
        private List<String> steps;

        public Steps(List<String> steps) {
            this(Scope.SCENARIO, steps);
        }

        public Steps(Scope scope, List<String> steps) {
            this(scope, AfterScenario.Outcome.ANY, null, steps);
        }

        public Steps(AfterScenario.Outcome outcome, List<String> steps) {
            this(outcome, null, steps);
        }

        public Steps(AfterScenario.Outcome outcome, String metaFilter, List<String> steps) {
            this(Scope.SCENARIO, outcome, metaFilter, steps);
        }

        public Steps(Scope scope, AfterScenario.Outcome outcome, List<String> steps) {
            this(scope, outcome, null, steps);
        }

        public Steps(Scope scope, AfterScenario.Outcome outcome, String metaFilter, List<String> steps) {
            this.scope = scope;
            this.outcome = outcome;
            this.metaFilter = metaFilter;
            this.steps = steps;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

