/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import com.google.gson.Gson;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.annotations.AsJson;
import org.jbehave.core.annotations.AsParameters;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.ExamplesTableFactory;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.InstanceStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.StepMonitor;

public class ParameterConverters {
    public static final StepMonitor DEFAULT_STEP_MONITOR = new SilentStepMonitor();
    public static final Locale DEFAULT_NUMBER_FORMAT_LOCAL = Locale.ENGLISH;
    public static final String DEFAULT_COLLECTION_SEPARATOR = ",";
    @Deprecated
    public static final String DEFAULT_LIST_SEPARATOR = ",";
    public static final boolean DEFAULT_THREAD_SAFETY = true;
    private static final String DEFAULT_TRUE_VALUE = "true";
    private static final String DEFAULT_FALSE_VALUE = "false";
    private final StepMonitor monitor;
    private final List<ParameterConverter> converters;
    private final boolean threadSafe;
    private String escapedCollectionSeparator;

    public ParameterConverters() {
        this(new LoadFromClasspath(), new TableTransformers());
    }

    public ParameterConverters(TableTransformers tableTransformers) {
        this(new LoadFromClasspath(), tableTransformers);
    }

    public ParameterConverters(ResourceLoader resourceLoader) {
        this(resourceLoader, new TableTransformers());
    }

    public ParameterConverters(ResourceLoader resourceLoader, TableTransformers tableTransformers) {
        this(DEFAULT_STEP_MONITOR, resourceLoader, new ParameterControls(), tableTransformers);
    }

    public ParameterConverters(StepMonitor monitor, ResourceLoader resourceLoader, ParameterControls parameterControls, TableTransformers tableTransformers) {
        this(monitor, resourceLoader, parameterControls, tableTransformers, DEFAULT_NUMBER_FORMAT_LOCAL, ",", true);
    }

    public ParameterConverters(ResourceLoader resourceLoader, ParameterControls parameterControls, TableTransformers tableTransformers, boolean threadSafe) {
        this(DEFAULT_STEP_MONITOR, resourceLoader, parameterControls, tableTransformers, DEFAULT_NUMBER_FORMAT_LOCAL, ",", threadSafe);
    }

    public ParameterConverters(StepMonitor monitor, ResourceLoader resourceLoader, ParameterControls parameterControls, TableTransformers tableTransformers, Locale locale, String collectionSeparator, boolean threadSafe) {
        this(monitor, new ArrayList<ParameterConverter>(), threadSafe);
        this.addConverters(this.defaultConverters(resourceLoader, parameterControls, tableTransformers, locale, collectionSeparator));
    }

    private ParameterConverters(StepMonitor monitor, List<ParameterConverter> converters, boolean threadSafe) {
        this.monitor = monitor;
        this.threadSafe = threadSafe;
        this.converters = threadSafe ? new CopyOnWriteArrayList<ParameterConverter>(converters) : new ArrayList<ParameterConverter>(converters);
    }

    protected ParameterConverter[] defaultConverters(ResourceLoader resourceLoader, ParameterControls parameterControls, TableTransformers tableTransformers, Locale locale, String collectionSeparator) {
        this.escapedCollectionSeparator = this.escapeRegexPunctuation(collectionSeparator);
        ExamplesTableFactory tableFactory = new ExamplesTableFactory(resourceLoader, this, parameterControls, tableTransformers);
        JsonFactory jsonFactory = new JsonFactory();
        return new ParameterConverter[]{new BooleanConverter(), new NumberConverter(NumberFormat.getInstance(locale)), new StringConverter(), new StringListConverter(this.escapedCollectionSeparator), new DateConverter(), new CurrencyConverter(), new PatternConverter(), new FileConverter(), new EnumConverter(), new ExamplesTableConverter(tableFactory), new ExamplesTableParametersConverter(tableFactory), new JsonConverter(jsonFactory)};
    }

    private String escapeRegexPunctuation(String matchThis) {
        return matchThis.replaceAll("([\\[\\]\\{\\}\\?\\^\\.\\*\\(\\)\\+\\\\])", "\\\\$1");
    }

    public ParameterConverters addConverters(ParameterConverter ... converters) {
        return this.addConverters(Arrays.asList(converters));
    }

    public ParameterConverters addConverters(List<ParameterConverter> converters) {
        this.converters.addAll(0, converters);
        return this;
    }

    public Object convert(String value, Type type) {
        ParameterConverter<?> converter = this.findConverter(type);
        if (converter != null) {
            Object converted = converter.convertValue(value, type);
            this.monitor.convertedValueOfType(value, type, converted, converter.getClass());
            return converted;
        }
        if (ParameterConverters.isAssignableFromRawType(Collection.class, type)) {
            Type elementType = ParameterConverters.argumentType(type);
            ParameterConverter<?> elementConverter = this.findConverter(elementType);
            Collection collection = ParameterConverters.createCollection(ParameterConverters.rawClass(type));
            if (elementConverter != null && collection != null) {
                ParameterConverters.fillCollection(value, this.escapedCollectionSeparator, elementConverter, elementType, collection);
                return collection;
            }
        }
        throw new ParameterConvertionFailed("No parameter converter for " + type);
    }

    private ParameterConverter<?> findConverter(Type type) {
        for (ParameterConverter converter : this.converters) {
            if (!converter.accept(type)) continue;
            return converter;
        }
        return null;
    }

    private static boolean isAssignableFrom(Class<?> clazz, Type type) {
        return type instanceof Class && clazz.isAssignableFrom((Class)type);
    }

    private static boolean isAssignableFromRawType(Class<?> clazz, Type type) {
        return type instanceof ParameterizedType && ParameterConverters.isAssignableFrom(clazz, ((ParameterizedType)type).getRawType());
    }

    private static Class<?> rawClass(Type type) {
        return (Class)((ParameterizedType)type).getRawType();
    }

    private static Type argumentType(Type type) {
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    private static <T> void fillCollection(String value, String valueSeparator, ParameterConverter<T> elementConverter, Type elementType, Collection<T> convertedValues) {
        if (!value.trim().isEmpty()) {
            for (String elementValue : value.split(valueSeparator)) {
                T convertedValue = elementConverter.convertValue(elementValue.trim(), elementType);
                convertedValues.add(convertedValue);
            }
        }
    }

    private static <E> Collection<E> createCollection(Class<?> collectionType) {
        if (collectionType.isInterface()) {
            if (Set.class == collectionType) {
                return new HashSet();
            }
            if (List.class == collectionType) {
                return new ArrayList();
            }
            if (SortedSet.class == collectionType || NavigableSet.class == collectionType) {
                return new TreeSet();
            }
        }
        try {
            return (Collection)collectionType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public ParameterConverters newInstanceAdding(ParameterConverter converter) {
        ArrayList<ParameterConverter> convertersForNewInstance = new ArrayList<ParameterConverter>(this.converters);
        convertersForNewInstance.add(converter);
        return new ParameterConverters(this.monitor, convertersForNewInstance, this.threadSafe);
    }

    @Deprecated
    public static List<String> trim(List<String> values) {
        ArrayList<String> trimmed = new ArrayList<String>();
        for (String value : values) {
            trimmed.add(value.trim());
        }
        return trimmed;
    }

    public static class MethodReturningConverter
    implements ParameterConverter<Object> {
        private Method method;
        private Class<?> stepsType;
        private InjectableStepsFactory stepsFactory;

        public MethodReturningConverter(Method method, Object instance) {
            this(method, instance.getClass(), new InstanceStepsFactory((Configuration)new MostUsefulConfiguration(), instance));
        }

        public MethodReturningConverter(Method method, Class<?> stepsType, InjectableStepsFactory stepsFactory) {
            this.method = method;
            this.stepsType = stepsType;
            this.stepsFactory = stepsFactory;
        }

        @Override
        public boolean accept(Type type) {
            return ParameterConverters.isAssignableFrom(this.method.getReturnType(), type);
        }

        @Override
        public Object convertValue(String value, Type type) {
            try {
                Object instance = this.instance();
                return this.method.invoke(instance, value);
            }
            catch (Exception e) {
                throw new ParameterConvertionFailed("Failed to invoke method " + this.method + " with value " + value + " in " + type, e);
            }
        }

        private Object instance() {
            return this.stepsFactory.createInstanceOfType(this.stepsType);
        }
    }

    public static class JsonFactory {
        private Keywords keywords;
        private final ResourceLoader resourceLoader;

        public JsonFactory() {
            this(new LocalizedKeywords());
        }

        public JsonFactory(Keywords keywords) {
            this(keywords, new LoadFromClasspath());
        }

        public JsonFactory(ResourceLoader resourceLoader) {
            this(new LocalizedKeywords(), resourceLoader);
        }

        public JsonFactory(Keywords keywords, ResourceLoader resourceLoader) {
            this.keywords = keywords;
            this.resourceLoader = resourceLoader;
        }

        public JsonFactory(Configuration configuration) {
            this.keywords = configuration.keywords();
            this.resourceLoader = configuration.storyLoader();
        }

        public Object createJson(String input, Type type) {
            String jsonAsString = StringUtils.isBlank((CharSequence)input) || this.isJson(input) ? input : this.resourceLoader.loadResourceAsText(input);
            return new Gson().fromJson(jsonAsString, type);
        }

        protected boolean isJson(String input) {
            return input.startsWith("[") && input.endsWith("]") || input.startsWith("{") && input.endsWith("}");
        }

        public void useKeywords(Keywords keywords) {
            this.keywords = keywords;
        }

        public Keywords keywords() {
            return this.keywords;
        }
    }

    public static class JsonConverter
    implements ParameterConverter<Object> {
        private final JsonFactory factory;

        public JsonConverter() {
            this(new JsonFactory());
        }

        public JsonConverter(JsonFactory factory) {
            this.factory = factory;
        }

        @Override
        public boolean accept(Type type) {
            if (type instanceof ParameterizedType) {
                return ParameterConverters.rawClass(type).isAnnotationPresent(AsJson.class) || this.argumentClass(type).isAnnotationPresent(AsJson.class);
            }
            return type instanceof Class && ((Class)type).isAnnotationPresent(AsJson.class);
        }

        @Override
        public Object convertValue(String value, Type type) {
            return this.factory.createJson(value, type);
        }

        private Class<?> argumentClass(Type type) {
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return (Class)type;
        }
    }

    public static class ExamplesTableParametersConverter
    implements ParameterConverter<Object> {
        private final ExamplesTableFactory factory;

        public ExamplesTableParametersConverter(ExamplesTableFactory factory) {
            this.factory = factory;
        }

        @Override
        public boolean accept(Type type) {
            if (type instanceof ParameterizedType) {
                return ParameterConverters.rawClass(type).isAnnotationPresent(AsParameters.class) || this.argumentClass(type).isAnnotationPresent(AsParameters.class);
            }
            return type instanceof Class && ((Class)type).isAnnotationPresent(AsParameters.class);
        }

        private Class<?> argumentClass(Type type) {
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return (Class)type;
        }

        @Override
        public Object convertValue(String value, Type type) {
            List<?> rows = this.factory.createExamplesTable(value).getRowsAs(this.argumentClass(type));
            if (type instanceof ParameterizedType) {
                return rows;
            }
            return rows.iterator().next();
        }
    }

    public static class ExamplesTableConverter
    extends AbstractParameterConverter<ExamplesTable> {
        private final ExamplesTableFactory factory;

        public ExamplesTableConverter(ExamplesTableFactory factory) {
            this.factory = factory;
        }

        @Override
        public ExamplesTable convertValue(String value, Type type) {
            return this.factory.createExamplesTable(value);
        }
    }

    public static class EnumListConverter
    extends AbstractListParameterConverter<Enum<?>> {
        public EnumListConverter() {
            this(",");
        }

        public EnumListConverter(String valueSeparator) {
            super(valueSeparator, new EnumConverter());
        }
    }

    public static class FluentEnumConverter
    extends EnumConverter {
        @Override
        public Enum<?> convertValue(String value, Type type) {
            return super.convertValue(value.replaceAll("\\W", "_").toUpperCase(), type);
        }
    }

    public static class EnumConverter
    implements ParameterConverter<Enum<?>> {
        @Override
        public boolean accept(Type type) {
            return type instanceof Class && ((Class)type).isEnum();
        }

        @Override
        public Enum<?> convertValue(String value, Type type) {
            String typeClass = ((Class)type).getName();
            Class enumClass = (Class)type;
            Method valueOfMethod = null;
            try {
                valueOfMethod = enumClass.getMethod("valueOf", String.class);
                valueOfMethod.setAccessible(true);
                return (Enum)valueOfMethod.invoke((Object)enumClass, value);
            }
            catch (Exception e) {
                throw new ParameterConvertionFailed("Failed to convert " + value + " for Enum " + typeClass, e);
            }
        }
    }

    public static class BooleanListConverter
    extends AbstractListParameterConverter<Boolean> {
        public BooleanListConverter() {
            this(",", ParameterConverters.DEFAULT_TRUE_VALUE, ParameterConverters.DEFAULT_FALSE_VALUE);
        }

        public BooleanListConverter(String valueSeparator) {
            this(valueSeparator, ParameterConverters.DEFAULT_TRUE_VALUE, ParameterConverters.DEFAULT_FALSE_VALUE);
        }

        public BooleanListConverter(String valueSeparator, String trueValue, String falseValue) {
            super(valueSeparator, new BooleanConverter(trueValue, falseValue));
        }
    }

    public static class BooleanConverter
    extends AbstractParameterConverter<Boolean> {
        private final String trueValue;
        private final String falseValue;

        public BooleanConverter() {
            this(ParameterConverters.DEFAULT_TRUE_VALUE, ParameterConverters.DEFAULT_FALSE_VALUE);
        }

        public BooleanConverter(String trueValue, String falseValue) {
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public boolean accept(Type type) {
            return super.accept(type) || ParameterConverters.isAssignableFrom(Boolean.TYPE, type);
        }

        @Override
        public Boolean convertValue(String value, Type type) {
            try {
                return BooleanUtils.toBoolean((String)value, (String)this.trueValue, (String)this.falseValue);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }

    public static class FileConverter
    extends AbstractParameterConverter<File> {
        @Override
        public File convertValue(String value, Type type) {
            return new File(value);
        }
    }

    public static class PatternConverter
    extends AbstractParameterConverter<Pattern> {
        @Override
        public Pattern convertValue(String value, Type type) {
            return Pattern.compile(value);
        }
    }

    public static class CurrencyConverter
    extends AbstractParameterConverter<Currency> {
        @Override
        public Currency convertValue(String value, Type type) {
            return Currency.getInstance(value);
        }
    }

    public static class DateConverter
    extends AbstractParameterConverter<Date> {
        public static final DateFormat DEFAULT_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
        private final DateFormat dateFormat;

        public DateConverter() {
            this(DEFAULT_FORMAT);
        }

        public DateConverter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public Date convertValue(String value, Type type) {
            try {
                return this.dateFormat.parse(value);
            }
            catch (ParseException e) {
                throw new ParameterConvertionFailed("Failed to convert value " + value + " with date format " + (this.dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)this.dateFormat).toPattern() : this.dateFormat), e);
            }
        }
    }

    public static class StringListConverter
    extends AbstractListParameterConverter<String> {
        public StringListConverter() {
            this(",");
        }

        public StringListConverter(String valueSeparator) {
            super(valueSeparator, new StringConverter());
        }

        @Override
        public List<String> convertValue(String value, Type type) {
            if (value.trim().isEmpty()) {
                return Collections.emptyList();
            }
            return super.convertValue(value, type);
        }
    }

    public static class StringConverter
    extends AbstractParameterConverter<String> {
        private static final String NEWLINES_PATTERN = "(\n)|(\r\n)";
        private static final String SYSTEM_NEWLINE = System.getProperty("line.separator");

        @Override
        public String convertValue(String value, Type type) {
            return value.replaceAll(NEWLINES_PATTERN, SYSTEM_NEWLINE);
        }
    }

    public static class NumberListConverter
    extends AbstractListParameterConverter<Number> {
        public NumberListConverter() {
            this(NumberFormat.getInstance(DEFAULT_NUMBER_FORMAT_LOCAL), ",");
        }

        public NumberListConverter(NumberFormat numberFormat, String valueSeparator) {
            super(valueSeparator, new NumberConverter(numberFormat));
        }
    }

    public static class NumberConverter
    extends AbstractParameterConverter<Number> {
        private static List<Class<?>> primitiveTypes = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE);
        private final NumberFormat numberFormat;
        private ThreadLocal<NumberFormat> threadLocalNumberFormat = new ThreadLocal();

        public NumberConverter() {
            this(NumberFormat.getInstance(DEFAULT_NUMBER_FORMAT_LOCAL));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NumberConverter(NumberFormat numberFormat) {
            NumberConverter numberConverter = this;
            synchronized (numberConverter) {
                this.numberFormat = numberFormat;
                this.threadLocalNumberFormat.set((NumberFormat)this.numberFormat.clone());
            }
        }

        @Override
        public boolean accept(Type type) {
            return super.accept(type) || primitiveTypes.contains(type);
        }

        @Override
        public Number convertValue(String value, Type type) {
            try {
                Number n = this.numberFormat().parse(value);
                if (type == Byte.class || type == Byte.TYPE) {
                    return n.byteValue();
                }
                if (type == Short.class || type == Short.TYPE) {
                    return n.shortValue();
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    return n.intValue();
                }
                if (type == Float.class || type == Float.TYPE) {
                    return Float.valueOf(n.floatValue());
                }
                if (type == Long.class || type == Long.TYPE) {
                    return n.longValue();
                }
                if (type == Double.class || type == Double.TYPE) {
                    return n.doubleValue();
                }
                if (type == BigInteger.class) {
                    return BigInteger.valueOf(n.longValue());
                }
                if (type == BigDecimal.class) {
                    return new BigDecimal(this.canonicalize(value));
                }
                if (type == AtomicInteger.class) {
                    return new AtomicInteger(Integer.parseInt(value));
                }
                if (type == AtomicLong.class) {
                    return new AtomicLong(Long.parseLong(value));
                }
                return n;
            }
            catch (NumberFormatException | ParseException e) {
                throw new ParameterConvertionFailed(value, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NumberFormat numberFormat() {
            if (this.threadLocalNumberFormat.get() == null) {
                NumberConverter numberConverter = this;
                synchronized (numberConverter) {
                    this.threadLocalNumberFormat.set((NumberFormat)this.numberFormat.clone());
                }
            }
            return this.threadLocalNumberFormat.get();
        }

        private String canonicalize(String value) {
            boolean isNegative;
            int decimalPointSeparator = 46;
            char minusSign = '-';
            String rxNotDigits = "[\\.,]";
            StringBuilder builder = new StringBuilder(value.length());
            if (this.numberFormat() instanceof DecimalFormat) {
                DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)this.numberFormat()).getDecimalFormatSymbols();
                minusSign = decimalFormatSymbols.getMinusSign();
                decimalPointSeparator = decimalFormatSymbols.getDecimalSeparator();
            }
            value = value.trim();
            int decimalPointPosition = value.lastIndexOf(decimalPointSeparator);
            int firstDecimalPointPosition = value.indexOf(decimalPointSeparator);
            if (firstDecimalPointPosition != decimalPointPosition) {
                throw new NumberFormatException("Invalid format, more than one decimal point has been found.");
            }
            if (decimalPointPosition != -1) {
                String sf = value.substring(0, decimalPointPosition).replaceAll(rxNotDigits, "");
                String dp = value.substring(decimalPointPosition + 1).replaceAll(rxNotDigits, "");
                builder.append(sf);
                builder.append('.');
                builder.append(dp);
            } else {
                builder.append(value.replaceAll(rxNotDigits, ""));
            }
            boolean bl = isNegative = value.charAt(0) == minusSign;
            if (isNegative) {
                builder.setCharAt(0, '-');
            }
            return builder.toString();
        }
    }

    public static abstract class AbstractListParameterConverter<T>
    implements ParameterConverter<List<T>> {
        private final String valueSeparator;
        private final ParameterConverter<T> elementConverter;

        public AbstractListParameterConverter(String valueSeparator, ParameterConverter<T> elementConverter) {
            this.valueSeparator = valueSeparator;
            this.elementConverter = elementConverter;
        }

        @Override
        public boolean accept(Type type) {
            return ParameterConverters.isAssignableFromRawType(List.class, type) && this.elementConverter.accept(ParameterConverters.argumentType(type));
        }

        @Override
        public List<T> convertValue(String value, Type type) {
            Type elementType = ParameterConverters.argumentType(type);
            ArrayList convertedValues = new ArrayList();
            ParameterConverters.fillCollection(value, this.valueSeparator, this.elementConverter, elementType, convertedValues);
            return convertedValues;
        }
    }

    public static abstract class AbstractParameterConverter<T>
    implements ParameterConverter<T> {
        private final Type acceptedType = this.getParameterizedType(this.getClass()).getActualTypeArguments()[0];

        private ParameterizedType getParameterizedType(Class<?> clazz) {
            Type genericSuperclass = clazz.getGenericSuperclass();
            return genericSuperclass instanceof ParameterizedType ? (ParameterizedType)genericSuperclass : this.getParameterizedType(clazz.getSuperclass());
        }

        @Override
        public boolean accept(Type type) {
            if (this.acceptedType instanceof Class) {
                return ParameterConverters.isAssignableFrom((Class)this.acceptedType, type);
            }
            return this.acceptedType.equals(type);
        }
    }

    public static class ParameterConvertionFailed
    extends RuntimeException {
        public ParameterConvertionFailed(String message) {
            super(message);
        }

        public ParameterConvertionFailed(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface ParameterConverter<T> {
        public boolean accept(Type var1);

        public T convertValue(String var1, Type var2);
    }
}

