/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Pending;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepType;
import org.jbehave.core.steps.context.StepsContext;

public class StepCandidate {
    private final String patternAsString;
    private final Integer priority;
    private final StepType stepType;
    private final Method method;
    private final Class<?> stepsType;
    private final InjectableStepsFactory stepsFactory;
    private final Keywords keywords;
    private final StepMatcher stepMatcher;
    private final StepCreator stepCreator;
    private String[] composedSteps;
    private StepMonitor stepMonitor = new SilentStepMonitor();

    public StepCandidate(String patternAsString, int priority, StepType stepType, Method method, Class<?> stepsType, InjectableStepsFactory stepsFactory, StepsContext stepsContext, Keywords keywords, StepPatternParser stepPatternParser, ParameterConverters parameterConverters, ParameterControls parameterControls) {
        this.patternAsString = patternAsString;
        this.priority = priority;
        this.stepType = stepType;
        this.method = method;
        this.stepsType = stepsType;
        this.stepsFactory = stepsFactory;
        this.keywords = keywords;
        this.stepMatcher = stepPatternParser.parseStep(stepType, patternAsString);
        this.stepCreator = new StepCreator(stepsType, stepsFactory, stepsContext, parameterConverters, parameterControls, this.stepMatcher, this.stepMonitor);
    }

    public Method getMethod() {
        return this.method;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getPatternAsString() {
        return this.patternAsString;
    }

    public Object getStepsInstance() {
        return this.stepsFactory != null ? this.stepsFactory.createInstanceOfType(this.stepsType) : null;
    }

    public Class<?> getStepsType() {
        return this.stepsType;
    }

    public StepType getStepType() {
        return this.stepType;
    }

    public String getStartingWord() {
        return this.keywords.startingWordFor(this.stepType);
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        this.stepCreator.useStepMonitor(stepMonitor);
    }

    public void doDryRun(boolean dryRun) {
        this.stepCreator.doDryRun(dryRun);
    }

    public void useParanamer(Paranamer paranamer) {
        this.stepCreator.useParanamer(paranamer);
    }

    public void composedOf(String[] steps) {
        this.composedSteps = steps;
    }

    public boolean isComposite() {
        return this.composedSteps != null && this.composedSteps.length > 0;
    }

    public String[] composedSteps() {
        return this.composedSteps;
    }

    public boolean ignore(String stepAsString) {
        try {
            String ignoreWord = this.keywords.startingWordFor(StepType.IGNORABLE);
            return this.isIgnoredStep(stepAsString, ignoreWord);
        }
        catch (Keywords.StartingWordNotFound e) {
            return false;
        }
    }

    public boolean comment(String stepAsString) {
        try {
            String ignoreWord = this.keywords.startingWordFor(StepType.IGNORABLE);
            return this.keywords.stepStartsWithWord(stepAsString, ignoreWord) && !this.isIgnoredStep(stepAsString, ignoreWord);
        }
        catch (Keywords.StartingWordNotFound e) {
            return false;
        }
    }

    private boolean isIgnoredStep(String stepAsString, String ignoreWord) {
        for (Map.Entry<StepType, String> stepStartingWord : this.keywords.startingWordsByType().entrySet()) {
            if (stepStartingWord.getKey() == StepType.IGNORABLE || !this.keywords.stepStartsWithWords(stepAsString, ignoreWord, stepStartingWord.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isPending() {
        return this.method != null && this.method.isAnnotationPresent(Pending.class);
    }

    public boolean matches(String stepAsString) {
        return this.matches(stepAsString, null);
    }

    public boolean matches(String step, String previousNonAndStep) {
        try {
            boolean matchesType = true;
            if (this.keywords.isAndStep(step)) {
                matchesType = previousNonAndStep == null ? false : this.stepType == this.keywords.stepTypeFor(previousNonAndStep);
            }
            this.stepMonitor.stepMatchesType(step, previousNonAndStep, matchesType, this.stepType, this.method, this.stepsType);
            boolean matchesPattern = this.stepMatcher.matches(this.stripStartingWord(step));
            this.stepMonitor.stepMatchesPattern(step, matchesPattern, this.stepMatcher.pattern(), this.method, this.stepsType);
            return matchesType && matchesPattern;
        }
        catch (Keywords.StartingWordNotFound e) {
            return false;
        }
    }

    public Step createMatchedStep(String stepAsString, Map<String, String> namedParameters) {
        return this.stepCreator.createParametrisedStep(this.method, stepAsString, this.stripStartingWord(stepAsString), namedParameters);
    }

    public Step createMatchedStepUponOutcome(String stepAsString, Map<String, String> namedParameters, AfterScenario.Outcome outcome) {
        return this.stepCreator.createParametrisedStepUponOutcome(this.method, stepAsString, this.stripStartingWord(stepAsString), namedParameters, outcome);
    }

    public void addComposedSteps(List<Step> steps, String stepAsString, Map<String, String> namedParameters, List<StepCandidate> allCandidates) {
        Map<String, String> matchedParameters = this.stepCreator.matchedParameters(this.method, this.keywords.stepWithoutStartingWord(stepAsString), namedParameters);
        matchedParameters.putAll(namedParameters);
        String previousNonAndStep = null;
        for (String composedStep : this.composedSteps) {
            this.addComposedStep(steps, composedStep, previousNonAndStep, matchedParameters, allCandidates);
            if (this.keywords.isAndStep(stepAsString) || this.keywords.isIgnorableStep(stepAsString)) continue;
            previousNonAndStep = stepAsString;
        }
    }

    private void addComposedStep(List<Step> steps, String composedStep, String previousNonAndStep, Map<String, String> matchedParameters, List<StepCandidate> allCandidates) {
        StepCandidate candidate = this.findComposedCandidate(composedStep, previousNonAndStep, allCandidates);
        if (candidate != null) {
            steps.add(candidate.createMatchedStep(composedStep, matchedParameters));
            if (candidate.isComposite()) {
                candidate.addComposedSteps(steps, composedStep, matchedParameters, allCandidates);
            }
        } else {
            steps.add(StepCreator.createPendingStep(composedStep, previousNonAndStep));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StepCandidate findComposedCandidate(String composedStep, String previousNonAndStep, List<StepCandidate> allCandidates) {
        StepType stepType;
        if (this.keywords.isAndStep(composedStep)) {
            if (previousNonAndStep == null) return null;
            stepType = this.keywords.stepTypeFor(previousNonAndStep);
        } else {
            stepType = this.keywords.stepTypeFor(composedStep);
        }
        for (StepCandidate candidate : allCandidates) {
            if (stepType != candidate.getStepType() || !StringUtils.endsWith((CharSequence)composedStep, (CharSequence)candidate.getPatternAsString()) && !candidate.matches(composedStep, previousNonAndStep)) continue;
            return candidate;
        }
        return null;
    }

    private String stripStartingWord(String stepAsString) {
        return this.keywords.stepWithoutStartingWord(stepAsString, this.stepType);
    }

    public String toString() {
        return (Object)((Object)this.stepType) + " " + this.patternAsString;
    }
}

