/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import com.thoughtworks.paranamer.NullParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AsParameters;
import org.jbehave.core.annotations.FromContext;
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.ToContext;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.BeforeOrAfterFailed;
import org.jbehave.core.failures.IgnoringStepsFailure;
import org.jbehave.core.failures.RestartingScenarioFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Meta;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepResult;
import org.jbehave.core.steps.Timer;
import org.jbehave.core.steps.context.StepsContext;

public class StepCreator {
    public static final String PARAMETER_TABLE_START = "\uff3b";
    public static final String PARAMETER_TABLE_END = "\uff3d";
    public static final String PARAMETER_VALUE_START = "\uff5f";
    public static final String PARAMETER_VALUE_END = "\uff60";
    public static final String PARAMETER_VALUE_NEWLINE = "\u2424";
    public static final UUIDExceptionWrapper NO_FAILURE = new UUIDExceptionWrapper("no failure");
    private static final String NEWLINE = "\n";
    private static final String SPACE = " ";
    private static final String NONE = "";
    private final Class<?> stepsType;
    private final InjectableStepsFactory stepsFactory;
    private final ParameterConverters parameterConverters;
    private final ParameterControls parameterControls;
    private final Pattern delimitedNamePattern;
    private final StepMatcher stepMatcher;
    private final StepsContext stepsContext;
    private StepMonitor stepMonitor;
    private Paranamer paranamer = new NullParanamer();
    private boolean dryRun = false;

    public StepCreator(Class<?> stepsType, InjectableStepsFactory stepsFactory, StepsContext stepsContext, ParameterConverters parameterConverters, ParameterControls parameterControls, StepMatcher stepMatcher, StepMonitor stepMonitor) {
        this.stepsType = stepsType;
        this.stepsFactory = stepsFactory;
        this.stepsContext = stepsContext;
        this.parameterConverters = parameterConverters;
        this.parameterControls = parameterControls;
        this.stepMatcher = stepMatcher;
        this.stepMonitor = stepMonitor;
        this.delimitedNamePattern = Pattern.compile(parameterControls.nameDelimiterLeft() + "(\\w+?)" + parameterControls.nameDelimiterRight(), 32);
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
    }

    public void useParanamer(Paranamer paranamer) {
        this.paranamer = paranamer;
    }

    public void doDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public Object stepsInstance() {
        return this.stepsFactory.createInstanceOfType(this.stepsType);
    }

    public Step createBeforeOrAfterStep(Method method, Meta meta) {
        return new BeforeOrAfterStep(method, meta);
    }

    public Step createAfterStepUponOutcome(Method method, AfterScenario.Outcome outcome, Meta storyAndScenarioMeta) {
        Step beforeOrAfterStep = this.createBeforeOrAfterStep(method, storyAndScenarioMeta);
        return this.wrapStepUponOutcome(outcome, beforeOrAfterStep);
    }

    public Map<String, String> matchedParameters(Method method, String stepWithoutStartingWord, Map<String, String> namedParameters) {
        HashMap<String, String> matchedParameters = new HashMap<String, String>();
        if (this.stepMatcher.find(stepWithoutStartingWord)) {
            ParameterName[] parameterNames = this.parameterNames(method);
            Type[] types = this.parameterTypes(method, parameterNames);
            String[] values = this.parameterValuesForStep(namedParameters, types, parameterNames);
            for (int i = 0; i < parameterNames.length; ++i) {
                String name = parameterNames[i].name;
                if (name == null) {
                    name = this.stepMatcher.parameterNames()[i];
                }
                matchedParameters.put(name, values[i]);
            }
        }
        return matchedParameters;
    }

    private ParameterName[] parameterNames(Method method) {
        ParameterName[] parameterNames;
        if (method != null) {
            String[] annotatedNames = this.annotatedParameterNames(method);
            String[] paranamerNames = this.paranamerParameterNames(method);
            String[] contextNames = this.contextParameterNames(method);
            parameterNames = new ParameterName[annotatedNames.length];
            for (int i = 0; i < annotatedNames.length; ++i) {
                parameterNames[i] = this.parameterName(annotatedNames, paranamerNames, contextNames, i);
            }
        } else {
            String[] stepMatcherParameterNames = this.stepMatcher.parameterNames();
            parameterNames = new ParameterName[stepMatcherParameterNames.length];
            for (int i = 0; i < stepMatcherParameterNames.length; ++i) {
                parameterNames[i] = new ParameterName(stepMatcherParameterNames[i], false, false);
            }
        }
        return parameterNames;
    }

    private ParameterName parameterName(String[] annotatedNames, String[] paranamerNames, String[] contextNames, int i) {
        boolean annotated = true;
        boolean fromContext = false;
        String name = contextNames[i];
        if (name != null) {
            fromContext = true;
        } else {
            name = annotatedNames[i];
            if (name == null) {
                name = paranamerNames.length > i ? paranamerNames[i] : null;
                annotated = false;
            }
        }
        return new ParameterName(name, annotated, fromContext);
    }

    private String[] annotatedParameterNames(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = new String[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                names[i] = this.annotationName(annotation);
            }
        }
        return names;
    }

    private String[] contextParameterNames(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = new String[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                names[i] = this.contextName(annotation);
            }
        }
        return names;
    }

    private String annotationName(Annotation annotation) {
        if (annotation.annotationType().isAssignableFrom(Named.class)) {
            return ((Named)annotation).value();
        }
        if ("javax.inject.Named".equals(annotation.annotationType().getName())) {
            return Jsr330Helper.getNamedValue(annotation);
        }
        return null;
    }

    private String contextName(Annotation annotation) {
        if (annotation.annotationType().isAssignableFrom(FromContext.class)) {
            return ((FromContext)annotation).value();
        }
        return null;
    }

    private String[] paranamerParameterNames(Method method) {
        return this.paranamer.lookupParameterNames((AccessibleObject)method, false);
    }

    private Type[] parameterTypes(Method method, ParameterName[] parameterNames) {
        if (method != null) {
            return method.getGenericParameterTypes();
        }
        Type[] types = new Type[parameterNames.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = String.class;
        }
        return types;
    }

    public Step createParametrisedStep(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters) {
        return new ParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
    }

    public Step createParametrisedStepUponOutcome(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters, AfterScenario.Outcome outcome) {
        Step parametrisedStep = this.createParametrisedStep(method, stepAsString, stepWithoutStartingWord, namedParameters);
        return this.wrapStepUponOutcome(outcome, parametrisedStep);
    }

    private Step wrapStepUponOutcome(AfterScenario.Outcome outcome, Step step) {
        switch (outcome) {
            case ANY: {
                return new UponAnyStep(step);
            }
            case SUCCESS: {
                return new UponSuccessStep(step);
            }
            case FAILURE: {
                return new UponFailureStep(step);
            }
        }
        return step;
    }

    private String parametrisedStep(String stepAsString, Map<String, String> namedParameters, Type[] types, String[] parameterValues) {
        String parametrisedStep = stepAsString;
        boolean hasTable = this.hasTable(types);
        for (int position = 0; position < types.length; ++position) {
            parametrisedStep = this.markParsedParameterValue(parametrisedStep, types[position], parameterValues[position], hasTable);
        }
        for (String name : namedParameters.keySet()) {
            parametrisedStep = this.markNamedParameterValue(parametrisedStep, namedParameters, name);
        }
        return parametrisedStep;
    }

    private boolean hasTable(Type[] types) {
        for (Type type : types) {
            if (!this.isTable(type)) continue;
            return true;
        }
        return false;
    }

    private String markNamedParameterValue(String stepText, Map<String, String> namedParameters, String name) {
        String value = this.namedParameter(namedParameters, name);
        if (value != null) {
            return this.parameterControls.replaceAllDelimitedNames(stepText, name, this.markedValue(value));
        }
        return stepText;
    }

    private String markParsedParameterValue(String stepText, Type type, String value, boolean hasTable) {
        if (value != null) {
            if (value.trim().length() != 0) {
                if (this.isTable(type)) {
                    return stepText.replace(value, this.markedTable(value));
                }
                String markedValue = this.markedValue(value);
                String leftPad = SPACE;
                String rightPad = stepText.endsWith(value) ? NONE : SPACE;
                return stepText.replace(this.pad(value, leftPad, rightPad), this.pad(markedValue, leftPad, rightPad));
            }
            if (!hasTable) {
                return stepText.replace(NEWLINE, PARAMETER_VALUE_NEWLINE);
            }
        }
        return stepText;
    }

    private String markedTable(String value) {
        return this.pad(value, PARAMETER_TABLE_START, PARAMETER_TABLE_END);
    }

    private String markedValue(String value) {
        return this.pad(value, PARAMETER_VALUE_START, PARAMETER_VALUE_END);
    }

    private String pad(String value, String left, String right) {
        return left + value + right;
    }

    private boolean isTable(Type type) {
        return this.isExamplesTable(type) || this.isExamplesTableParameters(type);
    }

    private boolean isExamplesTable(Type type) {
        return type instanceof Class && ExamplesTable.class.isAssignableFrom((Class)type);
    }

    private boolean isExamplesTableParameters(Type type) {
        boolean result = false;
        if (type instanceof Class) {
            ((Class)type).isAnnotationPresent(AsParameters.class);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            result = this.isExamplesTableParameters(this.rawClass(parameterizedType)) || this.isExamplesTableParameters(this.argumentClass(parameterizedType));
        }
        return result;
    }

    private boolean isExamplesTableParameters(Class type) {
        return type != null && type.isAnnotationPresent(AsParameters.class);
    }

    private Class<?> rawClass(ParameterizedType type) {
        Class result = null;
        Type rawType = type.getRawType();
        if (rawType instanceof Class) {
            result = (Class)rawType;
        }
        return result;
    }

    private Class<?> argumentClass(ParameterizedType type) {
        Type argument;
        Class result = null;
        Type[] typeArguments = type.getActualTypeArguments();
        if (typeArguments.length > 0 && (argument = typeArguments[0]) instanceof Class) {
            result = (Class)argument;
        }
        return result;
    }

    private String[] parameterValuesForStep(Map<String, String> namedParameters, Type[] types, ParameterName[] names) {
        String[] parameters = new String[types.length];
        for (int position = 0; position < types.length; ++position) {
            parameters[position] = this.parameterForPosition(position, names, namedParameters);
        }
        return parameters;
    }

    private Object[] convertParameterValues(String[] valuesAsString, Type[] types, ParameterName[] names) {
        Object[] parameters = new Object[valuesAsString.length];
        for (int position = 0; position < valuesAsString.length; ++position) {
            parameters[position] = names[position].fromContext ? this.stepsContext.get(valuesAsString[position]) : this.parameterConverters.convert(valuesAsString[position], types[position]);
        }
        return parameters;
    }

    private String parameterForPosition(int position, ParameterName[] names, Map<String, String> namedParameters) {
        int namePosition = this.parameterPosition(names, position);
        String parameter = null;
        if (namePosition != -1) {
            String name = names[position].name;
            boolean annotated = names[position].annotated;
            boolean fromContext = names[position].fromContext;
            List<Object> delimitedNames = Collections.emptyList();
            if (this.isGroupName(name) && (delimitedNames = this.delimitedNameFor(parameter = this.matchedParameter(name))).isEmpty()) {
                this.monitorUsingNameForParameter(name, position, annotated);
            }
            if (!delimitedNames.isEmpty()) {
                for (String string : delimitedNames) {
                    this.monitorUsingTableNameForParameter(string, position, annotated);
                    parameter = this.parameterControls.replaceAllDelimitedNames(parameter, string, this.namedParameter(namedParameters, string));
                }
            } else if (this.isTableName(namedParameters, name) && (parameter = this.namedParameter(namedParameters, name)) != null) {
                this.monitorUsingTableNameForParameter(name, position, annotated);
            }
            if (fromContext && parameter == null) {
                parameter = name;
                this.stepMonitor.usingStepsContextParameter(parameter);
            }
        }
        if (parameter == null) {
            position -= this.numberOfPreviousFromContext(names, position);
            this.stepMonitor.usingNaturalOrderForParameter(position);
            parameter = this.matchedParameter(position);
            List<String> delimitedNames = this.delimitedNameFor(parameter);
            for (String delimitedName : delimitedNames) {
                if (!this.isTableName(namedParameters, delimitedName)) continue;
                parameter = this.parameterControls.replaceAllDelimitedNames(parameter, delimitedName, this.namedParameter(namedParameters, delimitedName));
            }
        }
        this.stepMonitor.foundParameter(parameter, position);
        return parameter;
    }

    private int numberOfPreviousFromContext(ParameterName[] names, int currentPosition) {
        int number = 0;
        for (int i = currentPosition - 1; i >= 0; --i) {
            if (!names[i].fromContext) continue;
            ++number;
        }
        return number;
    }

    private void monitorUsingTableNameForParameter(String name, int position, boolean usingAnnotationNames) {
        if (usingAnnotationNames) {
            this.stepMonitor.usingTableAnnotatedNameForParameter(name, position);
        } else {
            this.stepMonitor.usingTableParameterNameForParameter(name, position);
        }
    }

    private void monitorUsingNameForParameter(String name, int position, boolean usingAnnotationNames) {
        if (usingAnnotationNames) {
            this.stepMonitor.usingAnnotatedNameForParameter(name, position);
        } else {
            this.stepMonitor.usingParameterNameForParameter(name, position);
        }
    }

    private List<String> delimitedNameFor(String parameter) {
        ArrayList<String> delimitedNames = new ArrayList<String>();
        if (this.parameterControls.delimiterNamedParameters()) {
            Matcher matcher = this.delimitedNamePattern.matcher(parameter);
            while (matcher.find()) {
                delimitedNames.add(matcher.group(1));
            }
        }
        return delimitedNames;
    }

    String matchedParameter(String name) {
        String[] parameterNames = this.stepMatcher.parameterNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            if (!name.equals(parameterName)) continue;
            return this.matchedParameter(i);
        }
        throw new ParameterNotFound(name, parameterNames);
    }

    private String matchedParameter(int position) {
        int matchedPosition = position + 1;
        String[] parameterNames = this.stepMatcher.parameterNames();
        if (matchedPosition <= parameterNames.length) {
            return this.stepMatcher.parameter(matchedPosition);
        }
        throw new ParameterNotFound(position, parameterNames);
    }

    private int parameterPosition(ParameterName[] names, int position) {
        if (names.length == 0) {
            return -1;
        }
        String positionName = names[position].name;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].name;
            if (name == null || !name.equals(positionName)) continue;
            return i;
        }
        return -1;
    }

    private boolean isGroupName(String name) {
        String[] groupNames;
        for (String groupName : groupNames = this.stepMatcher.parameterNames()) {
            if (!name.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    private String namedParameter(Map<String, String> namedParameters, String name) {
        return namedParameters.get(name);
    }

    private boolean isTableName(Map<String, String> namedParameters, String name) {
        return this.namedParameter(namedParameters, name) != null;
    }

    public static Step createPendingStep(String stepAsString, String previousNonAndStep) {
        return new PendingStep(stepAsString, previousNonAndStep);
    }

    public static Step createIgnorableStep(String stepAsString) {
        return new IgnorableStep(stepAsString);
    }

    public static Step createComment(String stepAsString) {
        return new Comment(stepAsString);
    }

    private void storeOutput(Object object, Method method) {
        ToContext annotation = method.getAnnotation(ToContext.class);
        if (annotation != null) {
            this.stepsContext.put(annotation.value(), object, annotation.retentionLevel());
        }
    }

    private static class ParameterName {
        private String name;
        private boolean annotated;
        private boolean fromContext;

        private ParameterName(String name, boolean annotated, boolean fromContext) {
            this.name = name;
            this.annotated = annotated;
            this.fromContext = fromContext;
        }
    }

    private class MethodInvoker {
        private final Method method;
        private final ParameterConverters parameterConverters;
        private final Paranamer paranamer;
        private final Meta meta;
        private final Type[] parameterTypes;

        public MethodInvoker(Method method, ParameterConverters parameterConverters, Paranamer paranamer, Meta meta) {
            this.method = method;
            this.parameterConverters = parameterConverters;
            this.paranamer = paranamer;
            this.meta = meta;
            this.parameterTypes = method.getGenericParameterTypes();
        }

        public Object invoke() throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(StepCreator.this.stepsInstance(), this.parameterValuesFrom(this.meta));
        }

        private Parameter[] methodParameters() {
            Parameter[] parameters = new Parameter[this.parameterTypes.length];
            String[] annotatedNames = StepCreator.this.annotatedParameterNames(this.method);
            String[] paranamerNames = this.paranamer.lookupParameterNames((AccessibleObject)this.method, false);
            for (int position = 0; position < this.parameterTypes.length; ++position) {
                String name = this.parameterNameFor(position, annotatedNames, paranamerNames);
                parameters[position] = new Parameter(position, this.parameterTypes[position], name);
            }
            return parameters;
        }

        private String parameterNameFor(int position, String[] annotatedNames, String[] paranamerNames) {
            String annotatedName = this.nameByPosition(annotatedNames, position);
            String paranamerName = this.nameByPosition(paranamerNames, position);
            if (annotatedName != null) {
                return annotatedName;
            }
            if (paranamerName != null) {
                return paranamerName;
            }
            return null;
        }

        private String nameByPosition(String[] names, int position) {
            return position < names.length ? names[position] : null;
        }

        private Object[] parameterValuesFrom(Meta meta) {
            Object[] values = new Object[this.parameterTypes.length];
            for (Parameter parameter : this.methodParameters()) {
                values[((Parameter)parameter).position] = this.parameterConverters.convert(parameter.valueFrom(meta), parameter.type);
            }
            return values;
        }

        private class Parameter {
            private final int position;
            private final Type type;
            private final String name;

            public Parameter(int position, Type type, String name) {
                this.position = position;
                this.type = type;
                this.name = name;
            }

            public String valueFrom(Meta meta) {
                if (this.name == null) {
                    return null;
                }
                return meta.getProperty(this.name);
            }
        }
    }

    public static class Comment
    extends AbstractStep {
        private final String stepAsString;

        public Comment(String stepAsString) {
            this.stepAsString = stepAsString;
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.comment(this.stepAsString);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.comment(this.stepAsString);
        }

        @Override
        public String asString(Keywords keywords) {
            return this.stepAsString;
        }
    }

    public static class IgnorableStep
    extends AbstractStep {
        private final String stepAsString;

        public IgnorableStep(String stepAsString) {
            this.stepAsString = stepAsString;
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.ignorable(this.stepAsString);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.ignorable(this.stepAsString);
        }

        @Override
        public String asString(Keywords keywords) {
            return this.stepAsString;
        }
    }

    public static class PendingStep
    extends AbstractStep {
        private final String stepAsString;
        private final String previousNonAndStep;
        private Method method;

        public PendingStep(String stepAsString, String previousNonAndStep) {
            this.stepAsString = stepAsString;
            this.previousNonAndStep = previousNonAndStep;
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.pending(this.stepAsString);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.pending(this.stepAsString);
        }

        public String stepAsString() {
            return this.stepAsString;
        }

        public String previousNonAndStepAsString() {
            return this.previousNonAndStep;
        }

        public void annotatedOn(Method method) {
            this.method = method;
        }

        public boolean annotated() {
            return this.method != null;
        }

        @Override
        public String asString(Keywords keywords) {
            return this.stepAsString;
        }
    }

    public class ParametrisedStep
    extends AbstractStep {
        private Object[] convertedParameters;
        private String parametrisedStep;
        private final String stepAsString;
        private final Method method;
        private final String stepWithoutStartingWord;
        private final Map<String, String> namedParameters;

        public ParametrisedStep(String stepAsString, Method method, String stepWithoutStartingWord, Map<String, String> namedParameters) {
            this.stepAsString = stepAsString;
            this.method = method;
            this.stepWithoutStartingWord = stepWithoutStartingWord;
            this.namedParameters = namedParameters;
        }

        public void describeTo(StoryReporter storyReporter) {
            storyReporter.beforeStep(this.stepAsString);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            Timer timer = new Timer().start();
            try {
                Object outputObject;
                this.parametriseStep();
                StepCreator.this.stepMonitor.performing(this.parametrisedStep, StepCreator.this.dryRun);
                StepCreator.this.stepMonitor.beforePerforming(this.parametrisedStep, StepCreator.this.dryRun, this.method);
                if (!StepCreator.this.dryRun && this.method != null) {
                    outputObject = this.method.invoke(StepCreator.this.stepsInstance(), this.convertedParameters);
                    StepCreator.this.storeOutput(outputObject, this.method);
                }
                outputObject = AbstractStepResult.successful(this.stepAsString).withParameterValues(this.parametrisedStep).setTimings(timer.stop());
                return outputObject;
            }
            catch (ParameterNotFound e) {
                StepResult stepResult = AbstractStepResult.pending(this.stepAsString).withParameterValues(this.parametrisedStep);
                return stepResult;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RestartingScenarioFailure) {
                    throw (RestartingScenarioFailure)e.getCause();
                }
                if (e.getCause() instanceof IgnoringStepsFailure) {
                    throw (IgnoringStepsFailure)e.getCause();
                }
                Throwable failureCause = e.getCause();
                if (failureCause instanceof UUIDExceptionWrapper) {
                    failureCause = failureCause.getCause();
                }
                StepResult stepResult = AbstractStepResult.failed(this.stepAsString, new UUIDExceptionWrapper(this.stepAsString, failureCause)).withParameterValues(this.parametrisedStep).setTimings(timer.stop());
                return stepResult;
            }
            catch (Throwable t) {
                StepResult stepResult = AbstractStepResult.failed(this.stepAsString, new UUIDExceptionWrapper(this.stepAsString, t)).withParameterValues(this.parametrisedStep).setTimings(timer.stop());
                return stepResult;
            }
            finally {
                StepCreator.this.stepMonitor.afterPerforming(this.parametrisedStep, StepCreator.this.dryRun, this.method);
            }
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            try {
                this.parametriseStep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return AbstractStepResult.notPerformed(this.stepAsString).withParameterValues(this.parametrisedStep);
        }

        @Override
        public String asString(Keywords keywords) {
            if (this.parametrisedStep == null) {
                this.parametriseStep();
            }
            return this.parametrisedStep;
        }

        private void parametriseStep() {
            StepCreator.this.stepMatcher.find(this.stepWithoutStartingWord);
            ParameterName[] names = StepCreator.this.parameterNames(this.method);
            Type[] types = StepCreator.this.parameterTypes(this.method, names);
            String[] parameterValues = StepCreator.this.parameterValuesForStep(this.namedParameters, types, names);
            this.convertedParameters = StepCreator.this.convertParameterValues(parameterValues, types, names);
            this.addNamedParametersToExamplesTables();
            this.parametrisedStep = StepCreator.this.parametrisedStep(this.stepAsString, this.namedParameters, types, parameterValues);
        }

        private void addNamedParametersToExamplesTables() {
            for (Object object : this.convertedParameters) {
                if (!(object instanceof ExamplesTable)) continue;
                ((ExamplesTable)object).withNamedParameters(this.namedParameters);
            }
        }
    }

    class UponFailureStep
    extends DelegatingStep {
        UponFailureStep(Step step) {
            super(step);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return super.perform(storyFailureIfItHappened);
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }
    }

    class UponSuccessStep
    extends DelegatingStep {
        UponSuccessStep(Step step) {
            super(step);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }
    }

    class UponAnyStep
    extends DelegatingStep {
        UponAnyStep(Step step) {
            super(step);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyFailureIfItHappened);
        }
    }

    private class BeforeOrAfterStep
    extends AbstractStep {
        private final Method method;
        private final Meta meta;

        public BeforeOrAfterStep(Method method, Meta meta) {
            this.method = method;
            this.meta = meta;
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            ParameterConverters paramConvertersWithExceptionInjector = this.paramConvertersWithExceptionInjector(storyFailureIfItHappened);
            MethodInvoker methodInvoker = new MethodInvoker(this.method, paramConvertersWithExceptionInjector, StepCreator.this.paranamer, this.meta);
            Timer timer = new Timer().start();
            try {
                Object outputObject = methodInvoker.invoke();
                StepCreator.this.storeOutput(outputObject, this.method);
                return AbstractStepResult.silent(this.method).setTimings(timer.stop());
            }
            catch (InvocationTargetException e) {
                return AbstractStepResult.failed(this.method, new UUIDExceptionWrapper(new BeforeOrAfterFailed(this.method, e.getCause()))).setTimings(timer.stop());
            }
            catch (Throwable t) {
                return AbstractStepResult.failed(this.method, new UUIDExceptionWrapper(new BeforeOrAfterFailed(this.method, t))).setTimings(timer.stop());
            }
        }

        private ParameterConverters paramConvertersWithExceptionInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
            return StepCreator.this.parameterConverters.newInstanceAdding(new UUIDExceptionWrapperInjector(storyFailureIfItHappened));
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyFailureIfItHappened);
        }

        @Override
        public String asString(Keywords keywords) {
            return this.method.getName() + ";" + this.meta.asString(keywords);
        }

        private class UUIDExceptionWrapperInjector
        implements ParameterConverters.ParameterConverter<UUIDExceptionWrapper> {
            private final UUIDExceptionWrapper storyFailureIfItHappened;

            public UUIDExceptionWrapperInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
                this.storyFailureIfItHappened = storyFailureIfItHappened;
            }

            @Override
            public boolean accept(Type type) {
                return UUIDExceptionWrapper.class == type;
            }

            @Override
            public UUIDExceptionWrapper convertValue(String value, Type type) {
                return this.storyFailureIfItHappened;
            }
        }
    }

    static class DelegatingStep
    extends AbstractStep {
        private final Step step;

        DelegatingStep(Step step) {
            this.step = step;
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.step.perform(storyFailureIfItHappened);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.step.doNotPerform(storyFailureIfItHappened);
        }

        @Override
        public String asString(Keywords keywords) {
            return this.step.asString(keywords);
        }
    }

    public static abstract class AbstractStep
    implements Step {
        @Override
        public String asString(Keywords keywords) {
            return this.toString();
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }

    public static class ParameterNotFound
    extends RuntimeException {
        public ParameterNotFound(String name, String[] parameters) {
            super("Parameter not found for name '" + name + "' amongst '" + Arrays.asList(parameters) + "'");
        }

        public ParameterNotFound(int position, String[] parameters) {
            super("Parameter not found for position '" + position + "' amongst '" + Arrays.asList(parameters) + "'");
        }
    }

    public static class Jsr330Helper {
        private static String getNamedValue(Annotation annotation) {
            return ((javax.inject.Named)annotation).value();
        }
    }
}

