/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.FilteredStory;
import org.jbehave.core.embedder.MatchingStepMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.failures.FailingUponPendingStep;
import org.jbehave.core.failures.IgnoringStepsFailure;
import org.jbehave.core.failures.PendingStepsFound;
import org.jbehave.core.failures.RestartingScenarioFailure;
import org.jbehave.core.failures.RestartingStoryFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.GivenStory;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.ConcurrentStoryReporter;
import org.jbehave.core.reporters.DelegatingStoryReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.PendingStepMethodGenerator;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepResult;
import org.jbehave.core.steps.Timer;
import org.jbehave.core.steps.Timing;
import org.jbehave.core.steps.context.StepsContext;

public class PerformableTree {
    private static final Map<String, String> NO_PARAMETERS = new HashMap<String, String>();
    private PerformableRoot root = new PerformableRoot();

    public PerformableRoot getRoot() {
        return this.root;
    }

    public void addStories(RunContext context, List<Story> stories) {
        this.root.addBeforeSteps(context.beforeOrAfterStoriesSteps(StepCollector.Stage.BEFORE));
        for (Story story : stories) {
            this.root.add(this.performableStory(context, story, NO_PARAMETERS));
        }
        this.root.addAfterSteps(context.beforeOrAfterStoriesSteps(StepCollector.Stage.AFTER));
    }

    private PerformableStory performableStory(RunContext context, Story story, Map<String, String> storyParameters) {
        PerformableStory performableStory = new PerformableStory(story, context.configuration().keywords(), context.givenStory());
        boolean storyAllowed = true;
        FilteredStory filteredStory = context.filter(story);
        Meta storyMeta = story.getMeta();
        if (!filteredStory.allowed()) {
            storyAllowed = false;
        }
        performableStory.allowed(storyAllowed);
        if (storyAllowed) {
            Map lifecycleSteps = context.lifecycleSteps(story.getLifecycle(), storyMeta, Scope.STORY);
            performableStory.addBeforeSteps(context.beforeOrAfterStorySteps(story, StepCollector.Stage.BEFORE));
            performableStory.addBeforeSteps((PerformableSteps)lifecycleSteps.get((Object)StepCollector.Stage.BEFORE));
            boolean runBeforeAndAfterScenarioSteps = this.shouldRunBeforeOrAfterScenarioSteps(context);
            Iterator<Scenario> iterator = story.getScenarios().iterator();
            while (iterator.hasNext()) {
                HashMap<String, String> scenarioParameters = new HashMap<String, String>(storyParameters);
                Scenario scenario = iterator.next();
                PerformableScenario performableScenario = this.performableScenario(context, story, scenarioParameters, filteredStory, storyMeta, runBeforeAndAfterScenarioSteps, scenario);
                if (!performableScenario.isPerformable()) continue;
                performableStory.add(performableScenario);
            }
            if (performableStory.hasAllowedScenarios()) {
                HashMap<String, String> givenStoryParameters = new HashMap<String, String>(storyParameters);
                this.addMetaParameters(givenStoryParameters, storyMeta);
                if (story.hasGivenStories()) {
                    performableStory.addGivenStories(this.performableGivenStories(context, story.getGivenStories(), givenStoryParameters));
                }
            }
            performableStory.addAfterSteps((PerformableSteps)lifecycleSteps.get((Object)StepCollector.Stage.AFTER));
            performableStory.addAfterSteps(context.beforeOrAfterStorySteps(story, StepCollector.Stage.AFTER));
        }
        return performableStory;
    }

    private PerformableScenario performableScenario(RunContext context, Story story, Map<String, String> storyParameters, FilteredStory filterContext, Meta storyMeta, boolean runBeforeAndAfterScenarioSteps, Scenario scenario) {
        PerformableScenario performableScenario = new PerformableScenario(scenario, story.getPath());
        boolean scenarioAllowed = true;
        if (this.failureOccurred(context) && context.configuration().storyControls().skipScenariosAfterFailure()) {
            return performableScenario;
        }
        if (!filterContext.allowed(scenario)) {
            scenarioAllowed = false;
        }
        performableScenario.allowed(scenarioAllowed);
        if (scenarioAllowed) {
            Lifecycle lifecycle = story.getLifecycle();
            Meta storyAndScenarioMeta = scenario.getMeta().inheritFrom(storyMeta);
            NormalPerformableScenario normalScenario = this.normalScenario(context, lifecycle, scenario, storyAndScenarioMeta, storyParameters);
            if (runBeforeAndAfterScenarioSteps) {
                normalScenario.addBeforeSteps(context.beforeOrAfterScenarioSteps(storyAndScenarioMeta, StepCollector.Stage.BEFORE, ScenarioType.NORMAL));
            }
            if (this.isParameterisedByExamples(scenario)) {
                ExamplesTable table = scenario.getExamplesTable();
                List<Map<String, String>> tableRows = table.getRows();
                for (int exampleIndex = 0; exampleIndex < tableRows.size(); ++exampleIndex) {
                    Map<String, String> scenarioParameters = tableRows.get(exampleIndex);
                    Meta exampleScenarioMeta = this.parameterMeta(context, scenarioParameters).inheritFrom(storyAndScenarioMeta);
                    boolean exampleScenarioAllowed = context.filter().allow(exampleScenarioMeta);
                    if (!exampleScenarioAllowed) continue;
                    ExamplePerformableScenario exampleScenario = this.exampleScenario(context, lifecycle, scenario, storyAndScenarioMeta, scenarioParameters, exampleIndex);
                    performableScenario.addExampleScenario(exampleScenario);
                }
            } else {
                performableScenario.useNormalScenario(normalScenario);
            }
            if (runBeforeAndAfterScenarioSteps) {
                normalScenario.addAfterSteps(context.beforeOrAfterScenarioSteps(storyAndScenarioMeta, StepCollector.Stage.AFTER, ScenarioType.NORMAL));
            }
        }
        return performableScenario;
    }

    private NormalPerformableScenario normalScenario(RunContext context, Lifecycle lifecycle, Scenario scenario, Meta storyAndScenarioMeta, Map<String, String> storyParameters) {
        NormalPerformableScenario normalScenario = new NormalPerformableScenario(scenario);
        normalScenario.setStoryAndScenarioMeta(storyAndScenarioMeta);
        this.addStepsWithLifecycle(normalScenario, context, lifecycle, storyParameters, scenario, storyAndScenarioMeta);
        return normalScenario;
    }

    private ExamplePerformableScenario exampleScenario(RunContext context, Lifecycle lifecycle, Scenario scenario, Meta storyAndScenarioMeta, Map<String, String> parameters, int exampleIndex) {
        ExamplePerformableScenario exampleScenario = new ExamplePerformableScenario(scenario, parameters, exampleIndex);
        exampleScenario.setStoryAndScenarioMeta(storyAndScenarioMeta);
        exampleScenario.addBeforeSteps(context.beforeOrAfterScenarioSteps(storyAndScenarioMeta, StepCollector.Stage.BEFORE, ScenarioType.EXAMPLE));
        this.addStepsWithLifecycle(exampleScenario, context, lifecycle, parameters, scenario, storyAndScenarioMeta);
        exampleScenario.addAfterSteps(context.beforeOrAfterScenarioSteps(storyAndScenarioMeta, StepCollector.Stage.AFTER, ScenarioType.EXAMPLE));
        return exampleScenario;
    }

    private Meta parameterMeta(RunContext context, Map<String, String> parameters) {
        Meta meta = Meta.EMPTY;
        Keywords keywords = context.configuration().keywords();
        String metaText = keywords.meta();
        if (parameters.containsKey(metaText)) {
            meta = Meta.createMeta(parameters.get(metaText), keywords);
        }
        return meta;
    }

    private void addStepsWithLifecycle(AbstractPerformableScenario performableScenario, RunContext context, Lifecycle lifecycle, Map<String, String> parameters, Scenario scenario, Meta storyAndScenarioMeta) {
        Map lifecycleSteps = context.lifecycleSteps(lifecycle, storyAndScenarioMeta, Scope.SCENARIO);
        performableScenario.addBeforeSteps(context.beforeOrAfterScenarioSteps(storyAndScenarioMeta, StepCollector.Stage.BEFORE, ScenarioType.ANY));
        performableScenario.addBeforeSteps((PerformableSteps)lifecycleSteps.get((Object)StepCollector.Stage.BEFORE));
        this.addMetaParameters(parameters, storyAndScenarioMeta);
        performableScenario.addGivenStories(this.performableGivenStories(context, scenario.getGivenStories(), parameters));
        performableScenario.addSteps(context.scenarioSteps(lifecycle, storyAndScenarioMeta, scenario, parameters));
        performableScenario.addAfterSteps((PerformableSteps)lifecycleSteps.get((Object)StepCollector.Stage.AFTER));
        performableScenario.addAfterSteps(context.beforeOrAfterScenarioSteps(storyAndScenarioMeta, StepCollector.Stage.AFTER, ScenarioType.ANY));
    }

    private List<PerformableStory> performableGivenStories(RunContext context, GivenStories givenStories, Map<String, String> parameters) {
        ArrayList<PerformableStory> stories = new ArrayList<PerformableStory>();
        if (givenStories.getPaths().size() > 0) {
            for (GivenStory givenStory : givenStories.getStories()) {
                RunContext childContext = context.childContextFor(givenStory);
                Story story = this.storyOfPath(context.configuration(), childContext.path());
                if (givenStory.hasAnchorParameters()) {
                    story = this.storyWithMatchingScenarios(story, givenStory.getAnchorParameters());
                }
                parameters.putAll(givenStory.getParameters());
                stories.add(this.performableStory(childContext, story, parameters));
            }
        }
        return stories;
    }

    private Story storyWithMatchingScenarios(Story story, Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return story;
        }
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        for (Scenario scenario : story.getScenarios()) {
            if (!this.matchesParameters(scenario, parameters)) continue;
            scenarios.add(scenario);
        }
        return story.cloneWithScenarios(scenarios);
    }

    private boolean matchesParameters(Scenario scenario, Map<String, String> parameters) {
        Meta meta = scenario.getMeta();
        for (String name : parameters.keySet()) {
            if (!meta.hasProperty(name)) continue;
            return meta.getProperty(name).equals(parameters.get(name));
        }
        return false;
    }

    public Story storyOfPath(Configuration configuration, String storyPath) {
        String storyAsText = configuration.storyLoader().loadStoryAsText(storyPath);
        return configuration.storyParser().parseStory(storyAsText, storyPath);
    }

    public Story storyOfText(Configuration configuration, String storyAsText, String storyId) {
        return configuration.storyParser().parseStory(storyAsText, storyId);
    }

    private void addMetaParameters(Map<String, String> storyParameters, Meta meta) {
        for (String name : meta.getPropertyNames()) {
            if (storyParameters.containsKey(name)) continue;
            storyParameters.put(name, meta.getProperty(name));
        }
    }

    private boolean shouldRunBeforeOrAfterScenarioSteps(RunContext context) {
        Configuration configuration = context.configuration();
        if (!configuration.storyControls().skipBeforeAndAfterScenarioStepsIfGivenStory()) {
            return true;
        }
        return !context.givenStory();
    }

    private boolean failureOccurred(RunContext context) {
        return context.failureOccurred();
    }

    private boolean isParameterisedByExamples(Scenario scenario) {
        return scenario.getExamplesTable().getHeaders().size() > 0 && !scenario.getGivenStories().requireParameters();
    }

    static void generatePendingStepMethods(RunContext context, List<Step> steps) {
        ArrayList<StepCreator.PendingStep> pendingSteps = new ArrayList<StepCreator.PendingStep>();
        for (Step step : steps) {
            if (!(step instanceof StepCreator.PendingStep)) continue;
            pendingSteps.add((StepCreator.PendingStep)step);
        }
        if (!pendingSteps.isEmpty()) {
            PendingStepMethodGenerator generator = new PendingStepMethodGenerator(context.configuration().keywords());
            ArrayList<String> methods = new ArrayList<String>();
            for (StepCreator.PendingStep pendingStep : pendingSteps) {
                if (pendingStep.annotated()) continue;
                methods.add(generator.generateMethod(pendingStep));
            }
        }
    }

    public void perform(RunContext context, Story story) {
        boolean restartingStory = false;
        try {
            this.performCancellable(context, story);
            if (context.restartStory()) {
                context.reporter().restartedStory(story, context.failure(context.state()));
                restartingStory = true;
                this.perform(context, story);
            }
        }
        catch (InterruptedException e) {
            if (context.isCancelled(story)) {
                context.reporter().storyCancelled(story, context.storyDuration(story));
                context.reporter().afterStory(context.givenStory);
            }
            throw new UUIDExceptionWrapper(e);
        }
        finally {
            if (!context.givenStory() && !restartingStory) {
                this.invokeDelayedReporters(context.reporter());
            }
        }
    }

    private void performCancellable(RunContext context, Story story) throws InterruptedException {
        if (context.configuration().storyControls().resetStateBeforeStory()) {
            context.resetState();
            context.resetFailures();
        }
        if (!story.getPath().equals(context.path())) {
            context.currentPath(story.getPath());
        }
        if (context.configuration.dryRun()) {
            context.reporter().dryRun();
        }
        this.root.get(story).perform(context);
        if (context.failureOccurred()) {
            context.addFailure();
        }
    }

    public void performBeforeOrAfterStories(RunContext context, StepCollector.Stage stage) {
        String storyPath = StringUtils.capitalize((String)stage.name().toLowerCase()) + "Stories";
        context.currentPath(storyPath);
        context.reporter().beforeStory(new Story(storyPath), false);
        try {
            (stage == StepCollector.Stage.BEFORE ? this.root.beforeSteps : this.root.afterSteps).perform(context);
        }
        catch (InterruptedException e) {
            throw new UUIDExceptionWrapper(e);
        }
        finally {
            this.invokeDelayedReporters(context.reporter());
        }
        context.reporter().afterStory(false);
        this.invokeDelayedReporters(context.reporter());
    }

    private void invokeDelayedReporters(StoryReporter reporter) {
        if (reporter instanceof ConcurrentStoryReporter) {
            ((ConcurrentStoryReporter)reporter).invokeDelayed();
        } else if (reporter instanceof DelegatingStoryReporter) {
            for (StoryReporter delegate : ((DelegatingStoryReporter)reporter).getDelegates()) {
                this.invokeDelayedReporters(delegate);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static void performGivenStories(RunContext context, List<PerformableStory> performableGivenStories, GivenStories givenStories) throws InterruptedException {
        if (performableGivenStories.size() > 0) {
            context.reporter().beforeGivenStories();
            context.reporter().givenStories(givenStories);
            for (PerformableStory story : performableGivenStories) {
                story.perform(context);
            }
            context.reporter().afterGivenStories();
        }
    }

    public RunContext newRunContext(Configuration configuration, List<CandidateSteps> candidateSteps, EmbedderMonitor embedderMonitor, MetaFilter filter, BatchFailures failures) {
        return new RunContext(configuration, candidateSteps, embedderMonitor, filter, failures);
    }

    public static class PerformableSteps
    implements Performable {
        private final transient List<Step> steps;
        private final transient List<StepCreator.PendingStep> pendingSteps;
        private List<MatchingStepMonitor.StepMatch> matches;
        private List<StepResult> results;

        public PerformableSteps() {
            this(null);
        }

        public PerformableSteps(List<Step> steps) {
            this(steps, null);
        }

        public PerformableSteps(List<Step> steps, List<MatchingStepMonitor.StepMatch> stepMatches) {
            this.steps = steps != null ? steps : new ArrayList();
            this.pendingSteps = this.pendingSteps();
            this.matches = stepMatches;
        }

        public void add(PerformableSteps performableSteps) {
            this.steps.addAll(performableSteps.steps);
            this.pendingSteps.addAll(performableSteps.pendingSteps);
            if (performableSteps.matches != null) {
                if (this.matches == null) {
                    this.matches = new ArrayList<MatchingStepMonitor.StepMatch>();
                }
                this.matches.addAll(performableSteps.matches);
            }
        }

        @Override
        public void perform(RunContext context) throws InterruptedException {
            if (this.steps.size() == 0) {
                return;
            }
            Keywords keywords = context.configuration().keywords();
            State state = context.state();
            StoryReporter reporter = context.reporter();
            this.results = new ArrayList<StepResult>();
            boolean ignoring = false;
            for (Step step : this.steps) {
                try {
                    context.interruptIfCancelled();
                    if (ignoring) {
                        reporter.ignorable(step.asString(keywords));
                        continue;
                    }
                    state = state.run(step, this.results, reporter);
                }
                catch (IgnoringStepsFailure e) {
                    reporter.ignorable(step.asString(keywords));
                    ignoring = true;
                }
                catch (RestartingScenarioFailure e) {
                    reporter.restarted(step.asString(keywords), e);
                    throw e;
                }
            }
            context.stateIs(state);
            context.pendingSteps(this.pendingSteps);
            this.generatePendingStepMethods(context, this.pendingSteps);
        }

        @Override
        public void reportFailures(FailureContext context) {
            if (this.results == null) {
                return;
            }
            for (StepResult result : this.results) {
                if (!(result instanceof AbstractStepResult.Failed)) continue;
                context.addFailure(result.getFailure());
            }
        }

        private List<StepCreator.PendingStep> pendingSteps() {
            ArrayList<StepCreator.PendingStep> pending = new ArrayList<StepCreator.PendingStep>();
            for (Step step : this.steps) {
                if (!(step instanceof StepCreator.PendingStep)) continue;
                pending.add((StepCreator.PendingStep)step);
            }
            return pending;
        }

        private void generatePendingStepMethods(RunContext context, List<StepCreator.PendingStep> pendingSteps) {
            if (!pendingSteps.isEmpty()) {
                PendingStepMethodGenerator generator = new PendingStepMethodGenerator(context.configuration().keywords());
                ArrayList<String> methods = new ArrayList<String>();
                for (StepCreator.PendingStep pendingStep : pendingSteps) {
                    if (pendingStep.annotated()) continue;
                    methods.add(generator.generateMethod(pendingStep));
                }
                context.reporter().pendingMethods(methods);
                if (context.configuration().pendingStepStrategy() instanceof FailingUponPendingStep) {
                    throw new PendingStepsFound(pendingSteps);
                }
            }
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class ExamplePerformableScenario
    extends AbstractPerformableScenario {
        private transient Scenario scenario;
        private final int exampleIndex;

        public ExamplePerformableScenario(Scenario scenario, Map<String, String> exampleParameters, int exampleIndex) {
            super(exampleParameters);
            this.scenario = scenario;
            this.exampleIndex = exampleIndex;
        }

        @Override
        public void perform(RunContext context) throws InterruptedException {
            Meta parameterMeta = this.parameterMeta(context.configuration().keywords(), this.parameters).inheritFrom(this.getStoryAndScenarioMeta());
            if (!parameterMeta.isEmpty() && !context.filter().allow(parameterMeta)) {
                return;
            }
            if (context.configuration().storyControls().resetStateBeforeScenario()) {
                context.resetState();
            }
            context.stepsContext().resetExample();
            context.reporter().example(this.parameters);
            context.reporter().example(this.parameters, this.exampleIndex);
            this.beforeSteps.perform(context);
            PerformableTree.performGivenStories(context, this.givenStories, this.scenario.getGivenStories());
            this.performRestartableSteps(context);
            this.afterSteps.perform(context);
        }

        @Override
        public void reportFailures(FailureContext context) {
            this.beforeSteps.reportFailures(context);
            this.steps.reportFailures(context);
            this.afterSteps.reportFailures(context);
        }

        private Meta parameterMeta(Keywords keywords, Map<String, String> parameters) {
            String meta = keywords.meta();
            if (parameters.containsKey(meta)) {
                return Meta.createMeta(parameters.get(meta), keywords);
            }
            return Meta.EMPTY;
        }
    }

    public static class NormalPerformableScenario
    extends AbstractPerformableScenario {
        private transient Scenario scenario;

        public NormalPerformableScenario(Scenario scenario) {
            this.scenario = scenario;
        }

        @Override
        public void perform(RunContext context) throws InterruptedException {
            if (context.configuration().storyControls().resetStateBeforeScenario()) {
                context.resetState();
            }
            this.beforeSteps.perform(context);
            PerformableTree.performGivenStories(context, this.givenStories, this.scenario.getGivenStories());
            this.performRestartableSteps(context);
            this.afterSteps.perform(context);
        }

        @Override
        public void reportFailures(FailureContext context) {
            this.beforeSteps.reportFailures(context);
            this.steps.reportFailures(context);
            this.afterSteps.reportFailures(context);
        }
    }

    public static abstract class AbstractPerformableScenario
    implements Performable {
        protected final Map<String, String> parameters;
        protected final List<PerformableStory> givenStories = new ArrayList<PerformableStory>();
        protected final PerformableSteps beforeSteps = new PerformableSteps();
        protected final PerformableSteps steps = new PerformableSteps();
        protected final PerformableSteps afterSteps = new PerformableSteps();
        private Meta storyAndScenarioMeta = new Meta();

        public AbstractPerformableScenario() {
            this(new HashMap<String, String>());
        }

        public AbstractPerformableScenario(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        public void addGivenStories(List<PerformableStory> givenStories) {
            this.givenStories.addAll(givenStories);
        }

        public void addBeforeSteps(PerformableSteps beforeSteps) {
            this.beforeSteps.add(beforeSteps);
        }

        public void addSteps(PerformableSteps steps) {
            this.steps.add(steps);
        }

        public void addAfterSteps(PerformableSteps afterSteps) {
            this.afterSteps.add(afterSteps);
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        protected void performRestartableSteps(RunContext context) throws InterruptedException {
            boolean restart = true;
            while (restart) {
                restart = false;
                try {
                    this.steps.perform(context);
                }
                catch (RestartingScenarioFailure e) {
                    restart = true;
                }
            }
        }

        public Meta getStoryAndScenarioMeta() {
            return this.storyAndScenarioMeta;
        }

        public void setStoryAndScenarioMeta(Meta storyAndScenarioMeta) {
            this.storyAndScenarioMeta = storyAndScenarioMeta;
        }
    }

    public static class PerformableScenario
    implements Performable {
        private final Scenario scenario;
        private final String storyPath;
        private boolean allowed;
        private Status status;
        private Timing timing = new Timing();
        private NormalPerformableScenario normalScenario;
        private List<ExamplePerformableScenario> exampleScenarios;

        public PerformableScenario(Scenario scenario, String storyPath) {
            this.scenario = scenario;
            this.storyPath = storyPath;
        }

        public void useNormalScenario(NormalPerformableScenario normalScenario) {
            this.normalScenario = normalScenario;
        }

        public void addExampleScenario(ExamplePerformableScenario exampleScenario) {
            if (this.exampleScenarios == null) {
                this.exampleScenarios = new ArrayList<ExamplePerformableScenario>();
            }
            this.exampleScenarios.add(exampleScenario);
        }

        public void allowed(boolean allowed) {
            this.allowed = allowed;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public Status getStatus() {
            return this.status;
        }

        public Timing getTiming() {
            return this.timing;
        }

        public Scenario getScenario() {
            return this.scenario;
        }

        public String getStoryPath() {
            return this.storyPath;
        }

        public Throwable getFailure() {
            FailureContext context = new FailureContext();
            this.reportFailures(context);
            List<Throwable> failures = context.getFailures();
            if (failures.size() > 0) {
                return failures.get(0);
            }
            return null;
        }

        public boolean hasNormalScenario() {
            return this.normalScenario != null;
        }

        public boolean hasExamples() {
            return this.exampleScenarios != null && this.exampleScenarios.size() > 0;
        }

        public boolean isPerformable() {
            return this.hasNormalScenario() || this.hasExamples() || !this.isAllowed();
        }

        public List<ExamplePerformableScenario> getExamples() {
            return this.exampleScenarios;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform(RunContext context) throws InterruptedException {
            if (!this.isAllowed()) {
                context.embedderMonitor().scenarioNotAllowed(this.scenario, context.filter());
                return;
            }
            Timer timer = new Timer().start();
            try {
                context.stepsContext().resetScenario();
                context.reporter().beforeScenario(this.scenario);
                context.reporter().beforeScenario(this.scenario.getTitle());
                context.reporter().scenarioMeta(this.scenario.getMeta());
                State state = context.state();
                if (this.hasExamples()) {
                    context.reporter().beforeExamples(this.scenario.getSteps(), this.scenario.getExamplesTable());
                    for (ExamplePerformableScenario exampleScenario : this.exampleScenarios) {
                        exampleScenario.perform(context);
                    }
                    context.reporter().afterExamples();
                } else {
                    context.stepsContext().resetExample();
                    this.normalScenario.perform(context);
                }
                this.status = context.status(state);
                context.reporter().afterScenario();
            }
            finally {
                this.timing.setTimings(timer.stop());
            }
        }

        @Override
        public void reportFailures(FailureContext context) {
            if (this.hasExamples()) {
                for (ExamplePerformableScenario exampleScenario : this.exampleScenarios) {
                    exampleScenario.reportFailures(context);
                }
            } else {
                this.normalScenario.reportFailures(context);
            }
        }
    }

    public static class PerformableStory
    implements Performable {
        private final Story story;
        private final transient Keywords keywords;
        private final boolean givenStory;
        private boolean allowed;
        private Status status;
        private Timing timing = new Timing();
        private List<PerformableStory> givenStories = new ArrayList<PerformableStory>();
        private List<PerformableSteps> beforeSteps = new ArrayList<PerformableSteps>();
        private List<PerformableScenario> scenarios = new ArrayList<PerformableScenario>();
        private List<PerformableSteps> afterSteps = new ArrayList<PerformableSteps>();

        public PerformableStory(Story story, Keywords keywords, boolean givenStory) {
            this.story = story;
            this.keywords = keywords;
            this.givenStory = givenStory;
        }

        public void allowed(boolean allowed) {
            this.allowed = allowed;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public Story getStory() {
            return this.story;
        }

        public Keywords getKeywords() {
            return this.keywords;
        }

        public boolean givenStory() {
            return this.givenStory;
        }

        public Status getStatus() {
            return this.status;
        }

        public Timing getTiming() {
            return this.timing;
        }

        public void addGivenStories(List<PerformableStory> performableGivenStories) {
            this.givenStories.addAll(performableGivenStories);
        }

        public void addBeforeSteps(PerformableSteps beforeSteps) {
            this.beforeSteps.add(beforeSteps);
        }

        public void addAfterSteps(PerformableSteps afterSteps) {
            this.afterSteps.add(afterSteps);
        }

        public void add(PerformableScenario performableScenario) {
            this.scenarios.add(performableScenario);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform(RunContext context) throws InterruptedException {
            if (!this.allowed) {
                context.reporter().storyNotAllowed(this.story, context.filter.asString());
                this.status = Status.NOT_ALLOWED;
            }
            Timer timer = new Timer().start();
            try {
                context.stepsContext().resetStory();
                context.reporter().beforeStory(this.story, this.givenStory);
                context.reporter().narrative(this.story.getNarrative());
                context.reporter().lifecyle(this.story.getLifecycle());
                State state = context.state();
                for (PerformableSteps steps : this.beforeSteps) {
                    steps.perform(context);
                }
                PerformableTree.performGivenStories(context, this.givenStories, this.story.getGivenStories());
                if (!context.failureOccurred() || !context.configuration().storyControls().skipStoryIfGivenStoryFailed()) {
                    this.performScenarios(context);
                }
                for (PerformableSteps steps : this.afterSteps) {
                    steps.perform(context);
                }
                if (context.restartStory()) {
                    context.reporter().afterStory(true);
                } else {
                    context.reporter().afterStory(this.givenStory);
                }
                this.status = context.status(state);
            }
            finally {
                this.timing.setTimings(timer.stop());
            }
        }

        @Override
        public void reportFailures(FailureContext context) {
            for (PerformableScenario scenario : this.scenarios) {
                scenario.reportFailures(context);
            }
        }

        private void performScenarios(RunContext context) throws InterruptedException {
            for (PerformableScenario scenario : this.scenarios) {
                scenario.perform(context);
            }
        }

        public List<PerformableScenario> getScenarios() {
            return this.scenarios;
        }

        public boolean hasAllowedScenarios() {
            for (PerformableScenario scenario : this.getScenarios()) {
                if (!scenario.isAllowed()) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Status {
        SUCCESSFUL,
        FAILED,
        PENDING,
        NOT_PERFORMED,
        NOT_ALLOWED;

    }

    public static class PerformableRoot {
        private PerformableSteps beforeSteps = new PerformableSteps();
        private Map<String, PerformableStory> stories = new LinkedHashMap<String, PerformableStory>();
        private PerformableSteps afterSteps = new PerformableSteps();

        public void addBeforeSteps(PerformableSteps beforeSteps) {
            this.beforeSteps = beforeSteps;
        }

        public void add(PerformableStory performableStory) {
            this.stories.put(performableStory.getStory().getPath(), performableStory);
        }

        public void addAfterSteps(PerformableSteps afterSteps) {
            this.afterSteps = afterSteps;
        }

        public PerformableStory get(Story story) {
            PerformableStory performableStory = this.stories.get(story.getPath());
            if (performableStory != null) {
                return performableStory;
            }
            throw new RuntimeException("No performable story for path " + story.getPath());
        }

        public List<PerformableStory> getStories() {
            return new ArrayList<PerformableStory>(this.stories.values());
        }
    }

    public static interface Performable {
        public void perform(RunContext var1) throws InterruptedException;

        public void reportFailures(FailureContext var1);
    }

    public static class FailureContext {
        List<Throwable> failures = new ArrayList<Throwable>();

        public void addFailure(Throwable failure) {
            this.failures.add(failure);
        }

        public List<Throwable> getFailures() {
            return this.failures;
        }
    }

    public static class RunContext {
        private final Configuration configuration;
        private final List<CandidateSteps> candidateSteps;
        private final EmbedderMonitor embedderMonitor;
        private final MetaFilter filter;
        private final BatchFailures failures;
        private final StepsContext stepsContext;
        private Map<Story, StoryDuration> cancelledStories = new HashMap<Story, StoryDuration>();
        private Map<String, List<StepCreator.PendingStep>> pendingStories = new HashMap<String, List<StepCreator.PendingStep>>();
        private final ThreadLocal<StoryReporter> reporter = new ThreadLocal();
        private String path;
        private boolean givenStory;
        private State state;

        public RunContext(Configuration configuration, List<CandidateSteps> candidateSteps, EmbedderMonitor embedderMonitor, MetaFilter filter, BatchFailures failures) {
            this.configuration = configuration;
            this.candidateSteps = candidateSteps;
            this.embedderMonitor = embedderMonitor;
            this.filter = filter;
            this.failures = failures;
            this.stepsContext = configuration.stepsContext();
            this.resetState();
        }

        public StepsContext stepsContext() {
            return this.stepsContext;
        }

        public boolean restartScenario() {
            for (Throwable cause = this.failure(this.state); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RestartingScenarioFailure)) continue;
                return true;
            }
            return false;
        }

        public boolean restartStory() {
            for (Throwable cause = this.failure(this.state); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RestartingStoryFailure)) continue;
                return true;
            }
            return false;
        }

        public void currentPath(String path) {
            this.path = path;
            this.reporter.set(this.configuration.storyReporter(path));
        }

        public void interruptIfCancelled() throws InterruptedException {
            for (Story story : this.cancelledStories.keySet()) {
                if (!this.path.equals(story.getPath())) continue;
                throw new InterruptedException(this.path);
            }
        }

        public boolean dryRun() {
            return this.configuration.storyControls().dryRun();
        }

        public Configuration configuration() {
            return this.configuration;
        }

        public boolean givenStory() {
            return this.givenStory;
        }

        public String path() {
            return this.path;
        }

        public FilteredStory filter(Story story) {
            return new FilteredStory(this.filter, story, this.configuration.storyControls(), this.givenStory);
        }

        public MetaFilter filter() {
            return this.filter;
        }

        public PerformableSteps beforeOrAfterStoriesSteps(StepCollector.Stage stage) {
            return new PerformableSteps(this.configuration.stepCollector().collectBeforeOrAfterStoriesSteps(this.candidateSteps, stage));
        }

        public PerformableSteps beforeOrAfterStorySteps(Story story, StepCollector.Stage stage) {
            return new PerformableSteps(this.configuration.stepCollector().collectBeforeOrAfterStorySteps(this.candidateSteps, story, stage, this.givenStory));
        }

        public PerformableSteps beforeOrAfterScenarioSteps(Meta storyAndScenarioMeta, StepCollector.Stage stage, ScenarioType type) {
            return new PerformableSteps(this.configuration.stepCollector().collectBeforeOrAfterScenarioSteps(this.candidateSteps, storyAndScenarioMeta, stage, type));
        }

        @Deprecated
        public PerformableSteps lifecycleSteps(Lifecycle lifecycle, Meta meta, StepCollector.Stage stage) {
            return this.lifecycleSteps(lifecycle, meta, stage, Scope.SCENARIO);
        }

        @Deprecated
        public PerformableSteps lifecycleSteps(Lifecycle lifecycle, Meta meta, StepCollector.Stage stage, Scope scope) {
            MatchingStepMonitor monitor = new MatchingStepMonitor(this.configuration.stepMonitor());
            List<Step> steps = this.configuration.stepCollector().collectLifecycleSteps(this.candidateSteps, lifecycle, meta, stage, scope);
            return new PerformableSteps(steps, monitor.matched());
        }

        private Map<StepCollector.Stage, PerformableSteps> lifecycleSteps(Lifecycle lifecycle, Meta meta, Scope scope) {
            MatchingStepMonitor monitor = new MatchingStepMonitor(this.configuration.stepMonitor());
            Map<StepCollector.Stage, List<Step>> steps = this.configuration.stepCollector().collectLifecycleSteps(this.candidateSteps, lifecycle, meta, scope);
            EnumMap<StepCollector.Stage, PerformableSteps> performableSteps = new EnumMap<StepCollector.Stage, PerformableSteps>(StepCollector.Stage.class);
            for (Map.Entry<StepCollector.Stage, List<Step>> entry : steps.entrySet()) {
                performableSteps.put(entry.getKey(), new PerformableSteps(entry.getValue(), monitor.matched()));
            }
            return performableSteps;
        }

        private PerformableSteps scenarioSteps(Lifecycle lifecycle, Meta meta, Scenario scenario, Map<String, String> parameters) {
            MatchingStepMonitor monitor = new MatchingStepMonitor(this.configuration.stepMonitor());
            StepCollector stepCollector = this.configuration.stepCollector();
            Map<StepCollector.Stage, List<Step>> beforeOrAfterStepSteps = stepCollector.collectLifecycleSteps(this.candidateSteps, lifecycle, meta, Scope.STEP);
            LinkedList<Step> steps = new LinkedList<Step>();
            for (Step step : stepCollector.collectScenarioSteps(this.candidateSteps, scenario, parameters, monitor)) {
                steps.addAll((Collection<Step>)beforeOrAfterStepSteps.get((Object)StepCollector.Stage.BEFORE));
                steps.add(step);
                steps.addAll((Collection<Step>)beforeOrAfterStepSteps.get((Object)StepCollector.Stage.AFTER));
            }
            return new PerformableSteps(steps, monitor.matched());
        }

        @Deprecated
        public PerformableSteps scenarioSteps(Scenario scenario, Map<String, String> parameters) {
            MatchingStepMonitor monitor = new MatchingStepMonitor(this.configuration.stepMonitor());
            List<Step> steps = this.configuration.stepCollector().collectScenarioSteps(this.candidateSteps, scenario, parameters, monitor);
            return new PerformableSteps(steps, monitor.matched());
        }

        public RunContext childContextFor(GivenStory givenStory) {
            RunContext child = new RunContext(this.configuration, this.candidateSteps, this.embedderMonitor, this.filter, this.failures);
            child.path = this.configuration.pathCalculator().calculate(this.path, givenStory.getPath());
            child.givenStory = true;
            return child;
        }

        public void cancelStory(Story story, StoryDuration storyDuration) {
            this.cancelledStories.put(story, storyDuration);
        }

        public boolean isCancelled(Story story) {
            return this.cancelledStories.containsKey(story);
        }

        public StoryDuration storyDuration(Story story) {
            return this.cancelledStories.get(story);
        }

        public State state() {
            return this.state;
        }

        public void stateIs(State state) {
            this.state = state;
        }

        public boolean failureOccurred() {
            return this.failed(this.state);
        }

        public void resetState() {
            this.state = new FineSoFar();
        }

        public void resetFailures() {
            this.failures.clear();
        }

        public StoryReporter reporter() {
            return this.reporter.get();
        }

        public boolean failed(State state) {
            return !state.getClass().equals(FineSoFar.class);
        }

        public Throwable failure(State state) {
            if (this.failed(state)) {
                return state.getFailure().getCause();
            }
            return null;
        }

        public void addFailure() {
            Throwable failure = this.failure(this.state);
            if (failure != null) {
                this.failures.put(this.state.toString(), failure);
            }
        }

        public void addFailure(String path, Throwable cause) {
            if (cause != null) {
                this.failures.put(path, cause);
            }
        }

        public void pendingSteps(List<StepCreator.PendingStep> pendingSteps) {
            if (!pendingSteps.isEmpty()) {
                this.pendingStories.put(this.path, pendingSteps);
            }
        }

        public boolean hasPendingSteps() {
            return this.pendingStories.containsKey(this.path);
        }

        public boolean isStoryPending() {
            return this.pendingStories.containsKey(this.path);
        }

        public boolean hasFailed() {
            return this.failed(this.state);
        }

        public Status status(State initial) {
            if (this.isStoryPending()) {
                return Status.PENDING;
            }
            if (this.failed(initial)) {
                return Status.NOT_PERFORMED;
            }
            return this.hasFailed() ? Status.FAILED : Status.SUCCESSFUL;
        }

        public MetaFilter getFilter() {
            return this.filter;
        }

        public BatchFailures getFailures() {
            return this.failures;
        }

        public EmbedderMonitor embedderMonitor() {
            return this.embedderMonitor;
        }
    }

    private static final class SomethingHappened
    implements State {
        private UUIDExceptionWrapper failure;

        public SomethingHappened(UUIDExceptionWrapper failure) {
            this.failure = failure;
        }

        @Override
        public State run(Step step, List<StepResult> results, StoryReporter reporter) {
            StepResult result = step.doNotPerform(this.getFailure());
            results.add(result);
            result.describeTo(reporter);
            return this;
        }

        @Override
        public UUIDExceptionWrapper getFailure() {
            return this.failure;
        }
    }

    private static final class FineSoFar
    implements State {
        private FineSoFar() {
        }

        @Override
        public State run(Step step, List<StepResult> results, StoryReporter reporter) {
            if (step instanceof StepCreator.ParametrisedStep) {
                ((StepCreator.ParametrisedStep)step).describeTo(reporter);
            }
            StepResult result = step.perform(this.getFailure());
            results.add(result);
            UUIDExceptionWrapper stepFailure = result.getFailure();
            State state = stepFailure == null ? this : new SomethingHappened(stepFailure);
            for (Step composedStep : step.getComposedSteps()) {
                state = state.run(composedStep, results, reporter);
            }
            result.describeTo(reporter);
            return state;
        }

        @Override
        public UUIDExceptionWrapper getFailure() {
            return null;
        }
    }

    public static interface State {
        public State run(Step var1, List<StepResult> var2, StoryReporter var3);

        public UUIDExceptionWrapper getFailure();
    }
}

