/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.embedder.MatchingStepMonitor;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStory;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.NullStepMonitor;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.Timing;

public class CrossReference {
    private boolean doJson = true;
    private boolean doXml = true;
    private String name;

    public CrossReference() {
        this("XREF");
    }

    public CrossReference(String name) {
        this.name = name;
    }

    public CrossReference withJsonOnly() {
        this.doJson = true;
        this.doXml = false;
        return this;
    }

    public CrossReference withXmlOnly() {
        this.doJson = false;
        this.doXml = true;
        return this;
    }

    public synchronized void serialise(PerformableTree.PerformableRoot root, File outputDirectory) {
        XRef xref = new XRef(root);
        if (this.doXml) {
            this.serialise((Object)xref, "xml", outputDirectory);
        }
        if (this.doJson) {
            this.serialise((Object)xref, "json", outputDirectory);
        }
    }

    private void serialise(Object object, String format, File outputDirectory) {
        try {
            this.serialise(object, this.xstream(format), this.writer(format, outputDirectory));
        }
        catch (IOException e) {
            throw new RuntimeException(this.name, e);
        }
    }

    private void serialise(Object object, XStream xstream, Writer writer) throws IOException {
        writer.write(xstream.toXML(object));
        writer.flush();
        writer.close();
    }

    private Writer writer(String format, File outputDirectory) throws IOException {
        String name = this.fileName(format);
        File outputDir = new File(outputDirectory, "view");
        outputDir.mkdirs();
        return new FileWriter(new File(outputDir, name));
    }

    private XStream xstream(String format) {
        XStream xstream = format.equals("json") ? new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()) : new XStream();
        this.configure(xstream);
        return xstream;
    }

    private void configure(XStream xstream) {
        xstream.setMode(1001);
        xstream.alias("xref", XRef.class);
        xstream.alias(this.name.toLowerCase(), PerformableTree.PerformableRoot.class);
        xstream.alias("performableStory", PerformableTree.PerformableStory.class);
        xstream.alias("performableScenario", PerformableTree.PerformableScenario.class);
        xstream.alias("performableSteps", PerformableTree.PerformableSteps.class);
        xstream.alias("normalPerformableScenario", PerformableTree.NormalPerformableScenario.class);
        xstream.alias("examplePerformableScenario", PerformableTree.ExamplePerformableScenario.class);
        xstream.alias("status", PerformableTree.Status.class);
        xstream.alias("story", Story.class);
        xstream.alias("scenario", Scenario.class);
        xstream.alias("lifecycleSteps", Lifecycle.Steps.class);
        xstream.alias("givenStory", GivenStory.class);
        xstream.alias("comment", AbstractStepResult.Comment.class);
        xstream.alias("failed", AbstractStepResult.Failed.class);
        xstream.alias("pending", AbstractStepResult.Pending.class);
        xstream.alias("notPerformed", AbstractStepResult.NotPerformed.class);
        xstream.alias("successful", AbstractStepResult.Successful.class);
        xstream.alias("ignorable", AbstractStepResult.Ignorable.class);
        xstream.alias("silent", AbstractStepResult.Silent.class);
        xstream.alias("skipped", AbstractStepResult.Skipped.class);
        xstream.alias("fromLandscape", TableTransformers.FromLandscape.class);
        xstream.alias("formatting", TableTransformers.Formatting.class);
        xstream.alias("replacing", TableTransformers.Replacing.class);
        xstream.alias("stepMatch", MatchingStepMonitor.StepMatch.class);
        xstream.alias("timing", Timing.class);
        xstream.omitField(ExamplesTable.class, "parameterConverters");
        xstream.omitField(ExamplesTable.class, "tableTransformers");
        xstream.omitField(ExamplesTable.class, "defaults");
    }

    private String fileName(String extension) {
        return this.name.toLowerCase() + "." + extension;
    }

    @Deprecated
    public synchronized void outputToFiles(StoryReporterBuilder storyReporterBuilder) {
    }

    @Deprecated
    public CrossReference withMetaFilter(String metaFilter) {
        return this;
    }

    @Deprecated
    public CrossReference withPendingStepStrategy(PendingStepStrategy pendingStepStrategy) {
        return this;
    }

    @Deprecated
    public CrossReference withOutputAfterEachStory(boolean outputAfterEachStory) {
        return this;
    }

    @Deprecated
    public CrossReference withThreadSafeDelegateFormat(Format format) {
        return this;
    }

    @Deprecated
    public CrossReference excludingStoriesWithNoExecutedScenarios(boolean exclude) {
        return this;
    }

    @Deprecated
    public String getMetaFilter() {
        return "";
    }

    @Deprecated
    public StepMonitor getStepMonitor() {
        return new NullStepMonitor();
    }

    @Deprecated
    protected XRefRoot newXRefRoot() {
        return new XRefRoot();
    }

    @Deprecated
    protected Writer makeWriter(File file) throws IOException {
        return new FileWriter(file);
    }

    @Deprecated
    protected void aliasForXRefStory(XStream xstream) {
    }

    @Deprecated
    protected void aliasForXRefRoot(XStream xstream) {
    }

    @Deprecated
    public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
        return new NullStoryReporter();
    }

    public static class XRef {
        private List<PerformableTree.PerformableStory> stories;
        private List<PerformableTree.PerformableScenario> scenarios = new ArrayList<PerformableTree.PerformableScenario>();

        public XRef(PerformableTree.PerformableRoot root) {
            this.stories = root.getStories();
            for (PerformableTree.PerformableStory story : this.stories) {
                this.scenarios.addAll(story.getScenarios());
            }
        }
    }

    @Deprecated
    public static class XRefStory {
    }

    @Deprecated
    public static class XRefRoot {
    }
}

