/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import java.util.List;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepType;

public abstract class AbstractCandidateSteps
implements CandidateSteps {
    private final Configuration configuration;

    public AbstractCandidateSteps(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    protected void checkForDuplicateCandidates(List<StepCandidate> candidates, StepType stepType, String patternAsString) {
        for (StepCandidate candidate : candidates) {
            if (candidate.getStepType() != stepType || !candidate.getPatternAsString().equals(patternAsString)) continue;
            throw new DuplicateCandidateFound(stepType, patternAsString);
        }
    }

    protected StepCandidate createCandidate(String stepPatternAsString, int priority, StepType stepType, Method method, Class<?> type, InjectableStepsFactory stepsFactory) {
        StepCandidate candidate = new StepCandidate(stepPatternAsString, priority, stepType, method, type, stepsFactory, this.configuration.stepsContext(), this.configuration.keywords(), this.configuration.stepPatternParser(), this.configuration.parameterConverters(), this.configuration.parameterControls());
        candidate.useStepMonitor(this.configuration.stepMonitor());
        candidate.useParanamer(this.configuration.paranamer());
        candidate.doDryRun(this.configuration.storyControls().dryRun());
        return candidate;
    }

    public static class DuplicateCandidateFound
    extends RuntimeException {
        public DuplicateCandidateFound(StepType stepType, String patternAsString) {
            super((Object)((Object)stepType) + " " + patternAsString);
        }
    }
}

