/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.NullStepMonitor;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepFinder;
import org.jbehave.core.steps.StepMonitor;

public class MarkUnmatchedStepsAsPending
implements StepCollector {
    private static final StepMonitor DEFAULT_STEP_MONITOR = new NullStepMonitor();
    private final StepFinder stepFinder;
    private final Keywords keywords;

    public MarkUnmatchedStepsAsPending() {
        this(new StepFinder());
    }

    public MarkUnmatchedStepsAsPending(StepFinder stepFinder) {
        this(stepFinder, new LocalizedKeywords());
    }

    public MarkUnmatchedStepsAsPending(Keywords keywords) {
        this(new StepFinder(), keywords);
    }

    public MarkUnmatchedStepsAsPending(StepFinder stepFinder, Keywords keywords) {
        this.stepFinder = stepFinder;
        this.keywords = keywords;
    }

    @Override
    public List<Step> collectBeforeOrAfterStoriesSteps(List<CandidateSteps> candidateSteps, StepCollector.Stage stage) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            steps.addAll(this.createSteps(candidates.listBeforeOrAfterStories(), stage));
        }
        return steps;
    }

    @Override
    public List<Step> collectBeforeOrAfterStorySteps(List<CandidateSteps> candidateSteps, Story story, StepCollector.Stage stage, boolean givenStory) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            steps.addAll(this.createSteps(candidates.listBeforeOrAfterStory(givenStory), story.getMeta(), stage));
        }
        return steps;
    }

    @Override
    public List<Step> collectBeforeOrAfterScenarioSteps(List<CandidateSteps> candidateSteps, Meta storyAndScenarioMeta, StepCollector.Stage stage, ScenarioType type) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            List<BeforeOrAfterStep> beforeOrAfterScenarioSteps = candidates.listBeforeOrAfterScenario(type);
            if (stage == StepCollector.Stage.BEFORE) {
                steps.addAll(this.createSteps(beforeOrAfterScenarioSteps, storyAndScenarioMeta, stage));
                continue;
            }
            steps.addAll(0, this.createStepsUponOutcome(beforeOrAfterScenarioSteps, storyAndScenarioMeta, stage));
        }
        return steps;
    }

    @Override
    @Deprecated
    public List<Step> collectLifecycleSteps(List<CandidateSteps> candidateSteps, Lifecycle lifecycle, Meta storyAndScenarioMeta, StepCollector.Stage stage) {
        return this.collectLifecycleSteps(candidateSteps, lifecycle, storyAndScenarioMeta, stage, Scope.SCENARIO);
    }

    @Override
    @Deprecated
    public List<Step> collectLifecycleSteps(List<CandidateSteps> candidateSteps, Lifecycle lifecycle, Meta storyAndScenarioMeta, StepCollector.Stage stage, Scope scope) {
        List<StepCandidate> allCandidates = this.stepFinder.collectCandidates(candidateSteps);
        ArrayList<Step> steps = new ArrayList<Step>();
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        if (stage == StepCollector.Stage.BEFORE) {
            steps.addAll(this.collectLifecycleBeforeSteps(allCandidates, lifecycle, scope, namedParameters));
        } else {
            steps.addAll(this.collectLifecycleAfterSteps(allCandidates, lifecycle, storyAndScenarioMeta, scope, namedParameters));
        }
        return steps;
    }

    @Override
    public Map<StepCollector.Stage, List<Step>> collectLifecycleSteps(List<CandidateSteps> candidateSteps, Lifecycle lifecycle, Meta storyAndScenarioMeta, Scope scope) {
        List<StepCandidate> allCandidates = this.stepFinder.collectCandidates(candidateSteps);
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        EnumMap<StepCollector.Stage, List<Step>> steps = new EnumMap<StepCollector.Stage, List<Step>>(StepCollector.Stage.class);
        steps.put(StepCollector.Stage.BEFORE, this.collectLifecycleBeforeSteps(allCandidates, lifecycle, scope, namedParameters));
        steps.put(StepCollector.Stage.AFTER, this.collectLifecycleAfterSteps(allCandidates, lifecycle, storyAndScenarioMeta, scope, namedParameters));
        return steps;
    }

    @Override
    public List<Step> collectScenarioSteps(List<CandidateSteps> candidateSteps, Scenario scenario, Map<String, String> parameters) {
        return this.collectScenarioSteps(candidateSteps, scenario, parameters, DEFAULT_STEP_MONITOR);
    }

    @Override
    public List<Step> collectScenarioSteps(List<CandidateSteps> candidateSteps, Scenario scenario, Map<String, String> parameters, StepMonitor stepMonitor) {
        ArrayList<Step> steps = new ArrayList<Step>();
        this.addMatchedSteps(scenario.getSteps(), steps, parameters, this.stepFinder.collectCandidates(candidateSteps), null, stepMonitor);
        return steps;
    }

    private List<Step> createSteps(List<BeforeOrAfterStep> beforeOrAfter, StepCollector.Stage stage) {
        return this.createSteps(beforeOrAfter, null, stage);
    }

    private List<Step> createSteps(List<BeforeOrAfterStep> beforeOrAfter, Meta meta, StepCollector.Stage stage) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (BeforeOrAfterStep step : beforeOrAfter) {
            if (stage != step.getStage()) continue;
            steps.add(meta == null ? step.createStep() : step.createStepWith(meta));
        }
        return steps;
    }

    private List<Step> createStepsUponOutcome(List<BeforeOrAfterStep> beforeOrAfter, Meta storyAndScenarioMeta, StepCollector.Stage stage) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (BeforeOrAfterStep step : beforeOrAfter) {
            if (stage != step.getStage()) continue;
            steps.add(step.createStepUponOutcome(storyAndScenarioMeta));
        }
        return steps;
    }

    private List<Step> collectLifecycleBeforeSteps(List<StepCandidate> allCandidates, Lifecycle lifecycle, Scope scope, Map<String, String> namedParameters) {
        ArrayList<Step> beforeSteps = new ArrayList<Step>();
        this.addMatchedSteps(lifecycle.getBeforeSteps(scope), beforeSteps, namedParameters, allCandidates, null);
        return beforeSteps;
    }

    private List<Step> collectLifecycleAfterSteps(List<StepCandidate> allCandidates, Lifecycle lifecycle, Meta storyAndScenarioMeta, Scope scope, Map<String, String> namedParameters) {
        ArrayList<Step> afterSteps = new ArrayList<Step>();
        for (AfterScenario.Outcome outcome : AfterScenario.Outcome.values()) {
            this.addMatchedSteps(lifecycle.getAfterSteps(scope, outcome, storyAndScenarioMeta), afterSteps, namedParameters, allCandidates, outcome);
        }
        return afterSteps;
    }

    private void addMatchedSteps(List<String> stepsAsString, List<Step> steps, Map<String, String> namedParameters, List<StepCandidate> allCandidates, AfterScenario.Outcome outcome) {
        this.addMatchedSteps(stepsAsString, steps, namedParameters, allCandidates, outcome, DEFAULT_STEP_MONITOR);
    }

    private void addMatchedSteps(List<String> stepsAsString, List<Step> steps, Map<String, String> namedParameters, List<StepCandidate> allCandidates, AfterScenario.Outcome outcome, StepMonitor stepMonitor) {
        String previousNonAndStep = null;
        for (String stepAsString : stepsAsString) {
            Step step = StepCreator.createPendingStep(stepAsString, previousNonAndStep);
            List<StepCandidate> prioritisedCandidates = this.stepFinder.prioritise(stepAsString, new ArrayList<StepCandidate>(allCandidates));
            for (StepCandidate candidate : prioritisedCandidates) {
                candidate.useStepMonitor(stepMonitor);
                if (candidate.ignore(stepAsString)) {
                    step = StepCreator.createIgnorableStep(stepAsString);
                    break;
                }
                if (candidate.comment(stepAsString)) {
                    step = StepCreator.createComment(stepAsString);
                    break;
                }
                if (!candidate.matches(stepAsString, previousNonAndStep)) continue;
                if (candidate.isPending()) {
                    ((StepCreator.PendingStep)step).annotatedOn(candidate.getMethod());
                } else {
                    ArrayList<Step> composedSteps = new ArrayList<Step>();
                    if (candidate.isComposite()) {
                        candidate.addComposedSteps(composedSteps, stepAsString, namedParameters, prioritisedCandidates);
                    }
                    step = outcome != null ? candidate.createMatchedStepUponOutcome(stepAsString, namedParameters, composedSteps, outcome) : candidate.createMatchedStep(stepAsString, namedParameters, composedSteps);
                }
                if (this.keywords.isAndStep(stepAsString) || this.keywords.isIgnorableStep(stepAsString)) break;
                previousNonAndStep = stepAsString;
                break;
            }
            if (!this.keywords.isAndStep(stepAsString) && !this.keywords.isIgnorableStep(stepAsString)) {
                previousNonAndStep = stepAsString;
            }
            steps.add(step);
        }
    }
}

