/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.Parameter;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.model.TableParsers;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.steps.ChainedRow;
import org.jbehave.core.steps.ConvertedParameters;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Parameters;
import org.jbehave.core.steps.Row;

public class ExamplesTable {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private static final String EMPTY_VALUE = "";
    public static final Pattern INLINED_PROPERTIES_PATTERN = Pattern.compile("\\{(.*?[^\\\\])\\}\\s*(.*)", 32);
    public static final ExamplesTable EMPTY = new ExamplesTable("");
    private static final String HEADER_SEPARATOR = "|";
    private static final String VALUE_SEPARATOR = "|";
    private static final String IGNORABLE_SEPARATOR = "|--";
    private final ParameterConverters parameterConverters;
    private final Row defaults;
    private final TableRows tableRows;
    private final Deque<TableProperties> tablePropertiesQueue = new LinkedList<TableProperties>();
    private Map<String, String> namedParameters = new HashMap<String, String>();
    private ParameterControls parameterControls;

    public ExamplesTable(String tableAsString) {
        this(tableAsString, "|", "|", new ParameterConverters(new LoadFromClasspath(), new TableTransformers()), new ParameterControls(), new TableParsers(), new TableTransformers());
    }

    public ExamplesTable(String tableAsString, String headerSeparator, String valueSeparator, ParameterConverters parameterConverters, ParameterControls parameterControls, TableParsers tableParsers, TableTransformers tableTransformers) {
        this(tableAsString, headerSeparator, valueSeparator, IGNORABLE_SEPARATOR, parameterConverters, parameterControls, tableParsers, tableTransformers);
    }

    public ExamplesTable(String tableAsString, String headerSeparator, String valueSeparator, String ignorableSeparator, ParameterConverters parameterConverters, ParameterControls parameterControls, TableParsers tableParsers, TableTransformers tableTransformers) {
        this(tableParsers.parseProperties(tableAsString, headerSeparator, valueSeparator, ignorableSeparator), parameterConverters, parameterControls, tableParsers, tableTransformers);
    }

    ExamplesTable(TablePropertiesQueue tablePropertiesQueue, ParameterConverters parameterConverters, ParameterControls parameterControls, TableParsers tableParsers, TableTransformers tableTransformers) {
        this.parameterConverters = parameterConverters;
        this.parameterControls = parameterControls;
        this.defaults = new ConvertedParameters(EMPTY_MAP, parameterConverters);
        this.tablePropertiesQueue.addAll(tablePropertiesQueue.getProperties());
        String transformedTable = this.applyTransformers(tableTransformers, tablePropertiesQueue.getTable(), tableParsers);
        this.tableRows = tableParsers.parseRows(transformedTable, this.lastTableProperties());
    }

    private TableProperties lastTableProperties() {
        return this.tablePropertiesQueue.getLast();
    }

    private ExamplesTable(ExamplesTable other, Row defaults) {
        this.tableRows = new TableRows(other.tableRows.getHeaders(), other.tableRows.getRows());
        this.parameterConverters = other.parameterConverters;
        this.tablePropertiesQueue.addAll(other.tablePropertiesQueue);
        this.defaults = defaults;
    }

    private String applyTransformers(TableTransformers tableTransformers, String tableAsString, TableParsers tableParsers) {
        String transformedTable = tableAsString;
        TableProperties previousProperties = null;
        for (TableProperties properties : this.tablePropertiesQueue) {
            String transformer = properties.getTransformer();
            if (transformer != null) {
                if (previousProperties != null) {
                    properties.overrideSeparatorsFrom(previousProperties);
                }
                transformedTable = tableTransformers.transform(transformer, transformedTable, tableParsers, properties);
            }
            previousProperties = properties;
        }
        return transformedTable;
    }

    public ExamplesTable withDefaults(Parameters defaults) {
        return new ExamplesTable(this, new ChainedRow(defaults, this.defaults));
    }

    public ExamplesTable withNamedParameters(Map<String, String> namedParameters) {
        this.namedParameters = namedParameters;
        return this;
    }

    public ExamplesTable withRowValues(int row, Map<String, String> values) {
        this.getRow(row).putAll(values);
        for (String header : values.keySet()) {
            if (this.getHeaders().contains(header)) continue;
            this.getHeaders().add(header);
        }
        return this;
    }

    public ExamplesTable withRows(List<Map<String, String>> values) {
        this.getHeaders().clear();
        this.tableRows.getRows().clear();
        if (!values.isEmpty()) {
            this.getHeaders().addAll(values.get(0).keySet());
            this.tableRows.getRows().addAll(values);
        }
        return this;
    }

    public Properties getProperties() {
        return this.lastTableProperties().getProperties();
    }

    public List<String> getHeaders() {
        return this.tableRows.getHeaders();
    }

    public Map<String, String> getRow(int row) {
        if (row > this.tableRows.getRows().size() - 1) {
            throw new RowNotFound(row);
        }
        Map<String, String> values = this.tableRows.getRows().get(row);
        if (this.getHeaders().size() != values.keySet().size()) {
            for (String header : this.getHeaders()) {
                if (values.containsKey(header)) continue;
                values.put(header, EMPTY_VALUE);
            }
        }
        return values;
    }

    public Parameters getRowAsParameters(int row) {
        return this.getRowAsParameters(row, false);
    }

    public Parameters getRowAsParameters(int row, boolean replaceNamedParameters) {
        Map<String, String> rowValues = this.getRow(row);
        return this.createParameters(replaceNamedParameters ? this.replaceNamedParameters(rowValues) : rowValues);
    }

    private Map<String, String> replaceNamedParameters(Map<String, String> row) {
        LinkedHashMap<String, String> replaced = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> rowEntry : row.entrySet()) {
            String replacedValue = rowEntry.getValue();
            for (Map.Entry<String, String> namedParameter : this.namedParameters.entrySet()) {
                replacedValue = this.parameterControls.replaceAllDelimitedNames(replacedValue, namedParameter.getKey(), namedParameter.getValue());
            }
            replaced.put(rowEntry.getKey(), replacedValue);
        }
        return replaced;
    }

    public int getRowCount() {
        return this.tableRows.getRows().size();
    }

    public boolean metaByRow() {
        return this.lastTableProperties().isMetaByRow();
    }

    public List<Map<String, String>> getRows() {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            rows.add(this.getRow(row));
        }
        return rows;
    }

    public List<Parameters> getRowsAsParameters() {
        return this.getRowsAsParameters(false);
    }

    public List<Parameters> getRowsAsParameters(boolean replaceNamedParameters) {
        ArrayList<Parameters> rows = new ArrayList<Parameters>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            rows.add(this.getRowAsParameters(row, replaceNamedParameters));
        }
        return rows;
    }

    public <T> List<T> getRowsAs(Class<T> type) {
        return this.getRowsAs(type, new HashMap<String, String>());
    }

    public <T> List<T> getRowsAs(Class<T> type, Map<String, String> fieldNameMapping) {
        ArrayList<T> rows = new ArrayList<T>();
        for (Parameters parameters : this.getRowsAsParameters()) {
            rows.add(this.mapToType(parameters, type, fieldNameMapping));
        }
        return rows;
    }

    private <T> T mapToType(Parameters parameters, Class<T> type, Map<String, String> fieldNameMapping) {
        try {
            T instance = type.newInstance();
            Map<String, String> values = parameters.values();
            for (String name : values.keySet()) {
                Field field = this.findField(type, name, fieldNameMapping);
                Type fieldType = field.getGenericType();
                Object value = parameters.valueAs(name, fieldType);
                field.setAccessible(true);
                field.set(instance, value);
            }
            return instance;
        }
        catch (Exception e) {
            throw new ParametersNotMappableToType(parameters, type, e);
        }
    }

    private <T> Field findField(Class<T> type, String name, Map<String, String> fieldNameMapping) throws NoSuchFieldException {
        String fieldName = fieldNameMapping.get(name);
        if (fieldName == null) {
            fieldName = name;
        }
        for (Field field : type.getDeclaredFields()) {
            Parameter parameter;
            if (!field.isAnnotationPresent(Parameter.class) || !fieldName.equals((parameter = field.getAnnotation(Parameter.class)).name())) continue;
            return field;
        }
        return this.findField(type, fieldName);
    }

    private Field findField(Class<?> type, String fieldName) throws NoSuchFieldException {
        for (Field field : type.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        if (type.getSuperclass() != null) {
            return this.findField(type.getSuperclass(), fieldName);
        }
        throw new NoSuchFieldException(fieldName);
    }

    private Parameters createParameters(Map<String, String> values) {
        return new ConvertedParameters(new ChainedRow(new ConvertedParameters(values, this.parameterConverters), this.defaults), this.parameterConverters);
    }

    public String getHeaderSeparator() {
        return this.lastTableProperties().getHeaderSeparator();
    }

    public String getValueSeparator() {
        return this.lastTableProperties().getValueSeparator();
    }

    public String asString() {
        if (this.tableRows.getRows().isEmpty()) {
            return EMPTY_VALUE;
        }
        return this.format();
    }

    public void outputTo(PrintStream output) {
        output.print(this.asString());
    }

    private String format() {
        StringBuilder sb = new StringBuilder();
        for (TableProperties tableProperties : this.tablePropertiesQueue) {
            String propertiesAsString = tableProperties.getPropertiesAsString();
            if (propertiesAsString.isEmpty()) continue;
            sb.append("{").append(propertiesAsString).append("}").append(this.lastTableProperties().getRowSeparator());
        }
        for (String string : this.getHeaders()) {
            sb.append(this.getHeaderSeparator()).append(string);
        }
        sb.append(this.getHeaderSeparator()).append(this.lastTableProperties().getRowSeparator());
        for (Map map : this.getRows()) {
            for (String header : this.getHeaders()) {
                sb.append(this.getValueSeparator()).append((String)map.get(header));
            }
            sb.append(this.getValueSeparator()).append(this.lastTableProperties().getRowSeparator());
        }
        return sb.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static final class TableRows {
        private final List<String> headers;
        private final List<Map<String, String>> rows;

        public TableRows(List<String> headers, List<Map<String, String>> rows) {
            this.headers = headers;
            this.rows = rows;
        }

        public List<String> getHeaders() {
            return this.headers;
        }

        public List<Map<String, String>> getRows() {
            return this.rows;
        }
    }

    static final class TablePropertiesQueue {
        private final String table;
        private final Deque<TableProperties> properties;

        TablePropertiesQueue(String table, Deque<TableProperties> properties) {
            this.table = table;
            this.properties = properties;
        }

        String getTable() {
            return this.table;
        }

        Deque<TableProperties> getProperties() {
            return this.properties;
        }
    }

    public static final class TableProperties {
        private static final String COMMA = ",";
        private static final String COMMA_REGEX = "\\,";
        private static final String EQUAL = "=";
        private static final String PIPE_REGEX = "\\|";
        private static final String DECORATORS_REGEX = Stream.of(Decorator.values()).map(Enum::name).collect(Collectors.joining("|", "(", ")"));
        private static final Pattern DECORATED_PROPERTY_PATTERN = Pattern.compile("\\s*\\{([^=,\\s]+(\\|" + DECORATORS_REGEX + ")*)}\\s*", 2);
        private static final String HEADER_SEPARATOR = "|";
        private static final String VALUE_SEPARATOR = "|";
        private static final String IGNORABLE_SEPARATOR = "|--";
        private static final String COMMENT_SEPARATOR = "#";
        private static final String HEADER_SEPARATOR_KEY = "headerSeparator";
        private static final String VALUE_SEPARATOR_KEY = "valueSeparator";
        private static final String IGNORABLE_SEPARATOR_KEY = "ignorableSeparator";
        private static final String COMMENT_SEPARATOR_KEY = "commentSeparator";
        private static final String ROW_SEPARATOR = "\n";
        private final Properties properties = new Properties();
        private final String propertiesAsString;

        public TableProperties(Properties properties) {
            this.properties.putAll((Map<?, ?>)properties);
            if (!this.properties.containsKey(HEADER_SEPARATOR_KEY)) {
                this.properties.setProperty(HEADER_SEPARATOR_KEY, "|");
            }
            if (!this.properties.containsKey(VALUE_SEPARATOR_KEY)) {
                this.properties.setProperty(VALUE_SEPARATOR_KEY, "|");
            }
            if (!this.properties.containsKey(IGNORABLE_SEPARATOR_KEY)) {
                this.properties.setProperty(IGNORABLE_SEPARATOR_KEY, "|--");
            }
            if (!this.properties.containsKey(COMMENT_SEPARATOR_KEY)) {
                this.properties.setProperty(COMMENT_SEPARATOR_KEY, COMMENT_SEPARATOR);
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Object, Object> property : this.properties.entrySet()) {
                sb.append(property.getKey()).append(EQUAL).append(property.getValue()).append(COMMA);
            }
            this.propertiesAsString = sb.substring(0, sb.length() - 1);
        }

        public TableProperties(String propertiesAsString) {
            this(propertiesAsString, "|", "|", "|--");
        }

        public TableProperties(String propertiesAsString, String defaultHeaderSeparator, String defaultValueSeparator, String defaultIgnorableSeparator) {
            this.properties.setProperty(HEADER_SEPARATOR_KEY, defaultHeaderSeparator);
            this.properties.setProperty(VALUE_SEPARATOR_KEY, defaultValueSeparator);
            this.properties.setProperty(IGNORABLE_SEPARATOR_KEY, defaultIgnorableSeparator);
            this.properties.putAll(this.parseProperties(propertiesAsString));
            this.propertiesAsString = propertiesAsString;
        }

        private Map<String, String> parseProperties(String propertiesAsString) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            if (!StringUtils.isEmpty((CharSequence)propertiesAsString)) {
                for (String propertyAsString : propertiesAsString.split("(?<!\\\\),")) {
                    String[] property = StringUtils.split((String)propertyAsString, (String)EQUAL, (int)2);
                    String propertyName = property[0];
                    String propertyValue = property[1];
                    Matcher decoratedPropertyMatcher = DECORATED_PROPERTY_PATTERN.matcher(propertyName);
                    if (decoratedPropertyMatcher.matches()) {
                        String[] propertyWithDecorators = decoratedPropertyMatcher.group(1).split(PIPE_REGEX);
                        propertyName = propertyWithDecorators[0];
                        for (int i = 1; i < propertyWithDecorators.length; ++i) {
                            String decorator = propertyWithDecorators[i].toUpperCase();
                            propertyValue = this.decoratePropertyValue(propertyValue, Decorator.valueOf(decorator));
                        }
                    } else {
                        propertyValue = propertyValue.trim();
                    }
                    result.put(propertyName.trim(), StringUtils.replace((String)propertyValue, (String)COMMA_REGEX, (String)COMMA));
                }
            }
            return result;
        }

        private String decoratePropertyValue(String value, Decorator decorator) {
            switch (decorator) {
                case VERBATIM: {
                    return value;
                }
                case LOWERCASE: {
                    return value.toLowerCase();
                }
                case UPPERCASE: {
                    return value.toUpperCase();
                }
            }
            return value.trim();
        }

        public String getRowSeparator() {
            return ROW_SEPARATOR;
        }

        public String getHeaderSeparator() {
            return this.properties.getProperty(HEADER_SEPARATOR_KEY);
        }

        public String getValueSeparator() {
            return this.properties.getProperty(VALUE_SEPARATOR_KEY);
        }

        public String getIgnorableSeparator() {
            return this.properties.getProperty(IGNORABLE_SEPARATOR_KEY);
        }

        public String getCommentSeparator() {
            return this.properties.getProperty(COMMENT_SEPARATOR_KEY);
        }

        void overrideSeparatorsFrom(TableProperties properties) {
            Stream.of(HEADER_SEPARATOR_KEY, VALUE_SEPARATOR_KEY, IGNORABLE_SEPARATOR_KEY, COMMENT_SEPARATOR_KEY).forEach(key -> {
                String value = properties.properties.getProperty((String)key);
                if (value != null) {
                    this.properties.setProperty((String)key, value);
                }
            });
        }

        public boolean isTrim() {
            return Boolean.parseBoolean(this.properties.getProperty("trim", "true"));
        }

        public boolean isMetaByRow() {
            return Boolean.parseBoolean(this.properties.getProperty("metaByRow", "false"));
        }

        public String getTransformer() {
            return this.properties.getProperty("transformer");
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getPropertiesAsString() {
            return this.propertiesAsString;
        }

        public static enum Decorator {
            LOWERCASE,
            UPPERCASE,
            VERBATIM,
            TRIM;

        }
    }

    public static class ParametersNotMappableToType
    extends RuntimeException {
        public ParametersNotMappableToType(Parameters parameters, Class<?> type, Exception e) {
            super(parameters.values() + " not mappable to type " + type, e);
        }
    }

    public static class RowNotFound
    extends RuntimeException {
        public RowNotFound(int row) {
            super(Integer.toString(row));
        }
    }
}

