/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.ExamplesTableFactory;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.TableParsers;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.parsers.AbstractRegexParser;
import org.jbehave.core.parsers.StoryParser;

public class RegexStoryParser
extends AbstractRegexParser
implements StoryParser {
    public static final ResourceLoader DEFAULT_RESOURCE_LOADER = new LoadFromClasspath();
    public static final TableTransformers DEFAULT_TABLE_TRANSFORMERS = new TableTransformers();
    private final ExamplesTableFactory tableFactory;

    public RegexStoryParser() {
        this(new LocalizedKeywords());
    }

    public RegexStoryParser(Keywords keywords) {
        this(keywords, DEFAULT_RESOURCE_LOADER, DEFAULT_TABLE_TRANSFORMERS);
    }

    public RegexStoryParser(ResourceLoader resourceLoader, TableTransformers tableTransformers) {
        this(new LocalizedKeywords(), resourceLoader, tableTransformers);
    }

    public RegexStoryParser(Keywords keywords, ResourceLoader resourceLoader, TableTransformers tableTransformers) {
        this(keywords, new ExamplesTableFactory(keywords, resourceLoader, new TableParsers(), tableTransformers));
    }

    public RegexStoryParser(Keywords keywords, ResourceLoader resourceLoader, TableParsers tableParsers, TableTransformers tableTransformers) {
        this(keywords, new ExamplesTableFactory(keywords, resourceLoader, tableParsers, tableTransformers));
    }

    public RegexStoryParser(ExamplesTableFactory tableFactory) {
        this(tableFactory.keywords(), tableFactory);
    }

    public RegexStoryParser(Keywords keywords, ExamplesTableFactory tableFactory) {
        super(keywords);
        this.tableFactory = tableFactory;
        this.tableFactory.useKeywords(keywords);
    }

    public RegexStoryParser(Configuration configuration) {
        this(configuration.keywords(), configuration.examplesTableFactory());
    }

    @Override
    public Story parseStory(String storyAsText) {
        return this.parseStory(storyAsText, null);
    }

    @Override
    public Story parseStory(String storyAsText, String storyPath) {
        Description description = this.parseDescriptionFrom(storyAsText);
        Meta meta = this.parseStoryMetaFrom(storyAsText);
        Narrative narrative = this.parseNarrativeFrom(storyAsText);
        GivenStories givenStories = this.parseGivenStories(storyAsText);
        Lifecycle lifecycle = this.parseLifecycle(storyAsText);
        List<Scenario> scenarios = this.parseScenariosFrom(storyAsText);
        Story story = new Story(storyPath, description, meta, narrative, givenStories, lifecycle, scenarios);
        if (storyPath != null) {
            story.namedAs(new File(storyPath).getName());
        }
        return story;
    }

    private Description parseDescriptionFrom(String storyAsText) {
        Matcher findingDescription = this.findingDescription().matcher(storyAsText);
        if (findingDescription.matches()) {
            return new Description(findingDescription.group(1).trim());
        }
        return Description.EMPTY;
    }

    private Meta parseStoryMetaFrom(String storyAsText) {
        Matcher findingMeta = this.findingStoryMeta().matcher(this.preScenarioText(storyAsText));
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return Meta.createMeta(meta, this.keywords());
        }
        return Meta.EMPTY;
    }

    private String preScenarioText(String storyAsText) {
        String[] split = storyAsText.split(this.keywords().scenario());
        return split.length > 0 ? split[0] : storyAsText;
    }

    private Narrative parseNarrativeFrom(String storyAsText) {
        Matcher findingNarrative = this.findingNarrative().matcher(storyAsText);
        if (findingNarrative.matches()) {
            String narrative = findingNarrative.group(1).trim();
            return this.createNarrative(narrative);
        }
        return Narrative.EMPTY;
    }

    private Narrative createNarrative(String narrative) {
        Matcher findingElements = this.findingNarrativeElements().matcher(narrative);
        if (findingElements.matches()) {
            String inOrderTo = findingElements.group(1).trim();
            String asA = findingElements.group(2).trim();
            String iWantTo = findingElements.group(3).trim();
            return new Narrative(inOrderTo, asA, iWantTo);
        }
        Matcher findingAlternativeElements = this.findingAlternativeNarrativeElements().matcher(narrative);
        if (findingAlternativeElements.matches()) {
            String asA = findingAlternativeElements.group(1).trim();
            String iWantTo = findingAlternativeElements.group(2).trim();
            String soThat = findingAlternativeElements.group(3).trim();
            return new Narrative("", asA, iWantTo, soThat);
        }
        return Narrative.EMPTY;
    }

    private GivenStories parseGivenStories(String storyAsText) {
        Matcher findingGivenStories;
        String scenarioKeyword = this.keywords().scenario();
        String beforeScenario = "";
        if (StringUtils.contains((CharSequence)storyAsText, (CharSequence)scenarioKeyword)) {
            beforeScenario = StringUtils.substringBefore((String)storyAsText, (String)scenarioKeyword);
        }
        String givenStories = (findingGivenStories = this.findingStoryGivenStories().matcher(beforeScenario)).find() ? findingGivenStories.group(1).trim() : "";
        return new GivenStories(givenStories);
    }

    private Lifecycle parseLifecycle(String storyAsText) {
        Matcher findingLifecycle;
        String scenarioKeyword = this.keywords().scenario();
        String beforeScenario = "";
        if (StringUtils.contains((CharSequence)storyAsText, (CharSequence)scenarioKeyword)) {
            beforeScenario = StringUtils.substringBefore((String)storyAsText, (String)scenarioKeyword);
        }
        String lifecycle = (findingLifecycle = this.findingLifecycle().matcher(beforeScenario)).find() ? findingLifecycle.group(1).trim() : "";
        Matcher findingBeforeAndAfter = Pattern.compile(".*" + this.keywords().before() + "(.*)\\s*" + this.keywords().after() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingBeforeAndAfter.matches()) {
            String beforeLifecycle = findingBeforeAndAfter.group(1).trim();
            List<Lifecycle.Steps> beforeSteps = this.parseBeforeLifecycle(beforeLifecycle);
            String afterLifecycle = findingBeforeAndAfter.group(2).trim();
            List<Lifecycle.Steps> afterSteps = this.parseAfterLifecycle(afterLifecycle);
            return new Lifecycle(beforeSteps, afterSteps);
        }
        Matcher findingBefore = Pattern.compile(".*" + this.keywords().before() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingBefore.matches()) {
            String beforeLifecycle = findingBefore.group(1).trim();
            List<Lifecycle.Steps> beforeSteps = this.parseBeforeLifecycle(beforeLifecycle);
            return new Lifecycle(beforeSteps, Arrays.asList(new Lifecycle.Steps[0]));
        }
        Matcher findingAfter = Pattern.compile(".*" + this.keywords().after() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingAfter.matches()) {
            List<Lifecycle.Steps> beforeSteps = Arrays.asList(new Lifecycle.Steps[0]);
            String afterLifecycle = findingAfter.group(1).trim();
            List<Lifecycle.Steps> afterSteps = this.parseAfterLifecycle(afterLifecycle);
            return new Lifecycle(beforeSteps, afterSteps);
        }
        return Lifecycle.EMPTY;
    }

    private Pattern findingBeforeAndAfterSteps() {
        String initialStartingWords = this.concatenateWithOr("\\n", "", this.keywords().before(), this.keywords().after());
        String followingStartingWords = this.concatenateFollowingStartingWords();
        return Pattern.compile("((" + initialStartingWords + ")\\s(.)*?)\\s*(\\Z|" + followingStartingWords + "|\\n" + this.keywords().examplesTable() + ")", 32);
    }

    private List<Lifecycle.Steps> parseBeforeLifecycle(String lifecycleAsText) {
        ArrayList<Lifecycle.Steps> list = new ArrayList<Lifecycle.Steps>();
        for (String byScope : lifecycleAsText.split(this.keywords().scope())) {
            if ((byScope = byScope.trim()).isEmpty()) continue;
            Scope scope = this.parseScope(this.findScope(this.keywords().scope() + byScope));
            Lifecycle.Steps steps = new Lifecycle.Steps(scope, this.findSteps(this.startingWithNL(byScope)));
            list.add(steps);
        }
        return list;
    }

    private List<Lifecycle.Steps> parseAfterLifecycle(String lifecycleAsText) {
        ArrayList<Lifecycle.Steps> list = new ArrayList<Lifecycle.Steps>();
        for (String byScope : lifecycleAsText.split(this.keywords().scope())) {
            if ((byScope = byScope.trim()).isEmpty()) continue;
            Scope scope = this.parseScope(this.findScope(this.keywords().scope() + byScope));
            for (String byOutcome : byScope.split(this.keywords().outcome())) {
                if ((byOutcome = byOutcome.trim()).isEmpty()) continue;
                String outcomeAsText = this.findOutcome(byOutcome);
                String filtersAsText = this.findFilters(StringUtils.removeStart((String)byOutcome, (String)outcomeAsText));
                List<String> steps = this.findSteps(this.startingWithNL(StringUtils.removeStart((String)byOutcome, (String)filtersAsText)));
                list.add(new Lifecycle.Steps(scope, this.parseOutcome(outcomeAsText), this.parseFilters(filtersAsText), steps));
            }
        }
        return list;
    }

    private String findScope(String lifecycleAsText) {
        Matcher findingScope = this.findingLifecycleScope().matcher(lifecycleAsText.trim());
        if (findingScope.matches()) {
            return findingScope.group(1).trim();
        }
        return "";
    }

    private Scope parseScope(String scopeAsText) {
        if (scopeAsText.trim().equals(this.keywords().scopeStep())) {
            return Scope.STEP;
        }
        if (scopeAsText.trim().equals(this.keywords().scopeScenario())) {
            return Scope.SCENARIO;
        }
        if (scopeAsText.trim().equals(this.keywords().scopeStory())) {
            return Scope.STORY;
        }
        return Scope.SCENARIO;
    }

    private String findOutcome(String stepsByOutcome) {
        Matcher findingOutcome = this.findingLifecycleOutcome().matcher(stepsByOutcome);
        if (findingOutcome.matches()) {
            return findingOutcome.group(1).trim();
        }
        return this.keywords().outcomeAny();
    }

    private AfterScenario.Outcome parseOutcome(String outcomeAsText) {
        if (outcomeAsText.equals(this.keywords().outcomeSuccess())) {
            return AfterScenario.Outcome.SUCCESS;
        }
        if (outcomeAsText.equals(this.keywords().outcomeFailure())) {
            return AfterScenario.Outcome.FAILURE;
        }
        return AfterScenario.Outcome.ANY;
    }

    private String findFilters(String stepsByFilters) {
        Matcher findingFilters = this.findingLifecycleFilters().matcher(stepsByFilters.trim());
        if (findingFilters.matches()) {
            return findingFilters.group(1).trim();
        }
        return "";
    }

    private String parseFilters(String filtersAsText) {
        return StringUtils.removeStart((String)filtersAsText, (String)this.keywords().metaFilter()).trim();
    }

    private List<Scenario> parseScenariosFrom(String storyAsText) {
        ArrayList<Scenario> parsed = new ArrayList<Scenario>();
        for (String scenarioAsText : this.splitScenarios(storyAsText)) {
            parsed.add(this.parseScenario(scenarioAsText));
        }
        return parsed;
    }

    private List<String> splitScenarios(String storyAsText) {
        String scenarioKeyword = this.keywords().scenario();
        if (StringUtils.contains((CharSequence)storyAsText, (CharSequence)scenarioKeyword)) {
            storyAsText = StringUtils.substringAfter((String)storyAsText, (String)scenarioKeyword);
        }
        return this.splitElements(storyAsText, scenarioKeyword);
    }

    private Scenario parseScenario(String scenarioAsText) {
        String title = this.findScenarioTitle(scenarioAsText);
        String scenarioWithoutKeyword = StringUtils.removeStart((String)scenarioAsText, (String)this.keywords().scenario()).trim();
        String scenarioWithoutTitle = StringUtils.removeStart((String)scenarioWithoutKeyword, (String)title);
        scenarioWithoutTitle = this.startingWithNL(scenarioWithoutTitle);
        Meta meta = this.findScenarioMeta(scenarioWithoutTitle);
        String examplesTableAsString = this.findExamplesTable(scenarioWithoutTitle);
        ExamplesTable examplesTable = this.parseExamplesTable(examplesTableAsString);
        GivenStories givenStories = this.findScenarioGivenStories(scenarioWithoutTitle);
        if (givenStories.requireParameters()) {
            givenStories.useExamplesTable(examplesTable);
        }
        ArrayList<String> rawSteps = new ArrayList<String>();
        if (examplesTableAsString.trim().isEmpty()) {
            rawSteps.addAll(this.findSteps(scenarioWithoutTitle));
        } else {
            int afterExampleIndex = scenarioWithoutTitle.indexOf(examplesTableAsString) + examplesTableAsString.length();
            rawSteps.addAll(this.findSteps(scenarioWithoutTitle.substring(0, afterExampleIndex)));
        }
        return new Scenario(title, meta, givenStories, examplesTable, rawSteps);
    }

    private String findScenarioTitle(String scenarioAsText) {
        Matcher findingTitle = this.findingScenarioTitle().matcher(scenarioAsText);
        return findingTitle.find() ? findingTitle.group(1).trim() : "";
    }

    private Meta findScenarioMeta(String scenarioAsText) {
        Matcher findingMeta = this.findingScenarioMeta().matcher(scenarioAsText);
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return Meta.createMeta(meta, this.keywords());
        }
        return Meta.EMPTY;
    }

    private String findExamplesTable(String scenarioAsText) {
        Matcher findingTable = this.findingExamplesTable().matcher(scenarioAsText);
        return findingTable.find() ? findingTable.group(1).trim() : "";
    }

    private ExamplesTable parseExamplesTable(String tableInput) {
        return this.tableFactory.createExamplesTable(tableInput);
    }

    private GivenStories findScenarioGivenStories(String scenarioAsText) {
        Matcher findingGivenStories = this.findingScenarioGivenStories().matcher(scenarioAsText);
        String givenStories = findingGivenStories.find() ? findingGivenStories.group(1).trim() : "";
        return new GivenStories(givenStories);
    }

    private Pattern findingDescription() {
        String metaOrNarrativeOrLifecycleOrScenario = this.concatenateWithOr(this.keywords().meta(), this.keywords().narrative(), this.keywords().lifecycle(), this.keywords().scenario());
        return Pattern.compile("(.*?)(" + metaOrNarrativeOrLifecycleOrScenario + ").*", 32);
    }

    private Pattern findingStoryMeta() {
        String narrativeOrLifecycleOrGivenStories = this.concatenateWithOr(this.keywords().narrative(), this.keywords().lifecycle(), this.keywords().givenStories());
        return Pattern.compile(".*" + this.keywords().meta() + "(.*?)\\s*(\\Z|" + narrativeOrLifecycleOrGivenStories + ").*", 32);
    }

    private Pattern findingNarrative() {
        String givenStoriesOrLifecycleOrScenario = this.concatenateWithOr(this.keywords().givenStories(), this.keywords().lifecycle(), this.keywords().scenario());
        return Pattern.compile(".*" + this.keywords().narrative() + "(.*?)\\s*(" + givenStoriesOrLifecycleOrScenario + ").*", 32);
    }

    private Pattern findingNarrativeElements() {
        return Pattern.compile(".*" + this.keywords().inOrderTo() + "(.*)\\s*" + this.keywords().asA() + "(.*)\\s*" + this.keywords().iWantTo() + "(.*)", 32);
    }

    private Pattern findingAlternativeNarrativeElements() {
        return Pattern.compile(".*" + this.keywords().asA() + "(.*)\\s*" + this.keywords().iWantTo() + "(.*)\\s*" + this.keywords().soThat() + "(.*)", 32);
    }

    private Pattern findingStoryGivenStories() {
        String lifecycleOrScenario = this.concatenateWithOr(this.keywords().lifecycle(), this.keywords().scenario());
        return Pattern.compile(".*" + this.keywords().givenStories() + "(.*?)\\s*(\\Z|" + lifecycleOrScenario + ").*", 32);
    }

    private Pattern findingLifecycle() {
        return Pattern.compile(".*" + this.keywords().lifecycle() + "\\s*(.*)", 32);
    }

    private Pattern findingLifecycleScope() {
        String startingWords = this.concatenateInitialStartingWords();
        return Pattern.compile(this.keywords().scope() + "((.)*?)\\s*(" + this.keywords().outcome() + "|" + this.keywords().metaFilter() + "|" + startingWords + ").*", 32);
    }

    private Pattern findingLifecycleOutcome() {
        String startingWords = this.concatenateInitialStartingWords();
        String outcomes = this.concatenateWithOr(this.keywords().outcomeAny(), this.keywords().outcomeSuccess(), this.keywords().outcomeFailure());
        return Pattern.compile("\\s*(" + outcomes + ")\\s*(" + this.keywords().metaFilter() + "|" + startingWords + ").*", 32);
    }

    private Pattern findingLifecycleFilters() {
        String startingWords = this.concatenateInitialStartingWords();
        String filters = this.concatenateWithOr(this.keywords().metaFilter());
        return Pattern.compile("\\s*(" + filters + "[\\w\\+\\-\\_\\s]*)(" + startingWords + ").*", 32);
    }

    private Pattern findingScenarioTitle() {
        String startingWords = this.concatenateInitialStartingWords();
        return Pattern.compile(this.keywords().scenario() + "(.*?)\\s*(" + this.keywords().meta() + "|" + startingWords + "|$).*", 32);
    }

    private Pattern findingScenarioMeta() {
        String startingWords = this.concatenateInitialStartingWords();
        return Pattern.compile(".*" + this.keywords().meta() + "(.*?)\\s*(" + this.keywords().givenStories() + "|" + startingWords + "|$).*", 32);
    }

    private Pattern findingScenarioGivenStories() {
        String startingWords = this.concatenateInitialStartingWords();
        return Pattern.compile("\\n" + this.keywords().givenStories() + "((.|\\n)*?)\\s*(" + startingWords + ").*", 32);
    }

    private Pattern findingExamplesTable() {
        return Pattern.compile("\\n" + this.keywords().examplesTable() + "\\s*(.*?)(?:\\n" + this.keywords().ignorable() + ".*)?$", 32);
    }
}

