/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.StepCollector;

public class DelegatingStoryReporter
implements StoryReporter {
    private final Collection<StoryReporter> delegates;

    public DelegatingStoryReporter(Collection<StoryReporter> delegates) {
        this.delegates = delegates;
    }

    public DelegatingStoryReporter(StoryReporter ... delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public void afterScenario() {
        for (StoryReporter reporter : this.delegates) {
            reporter.afterScenario();
        }
    }

    @Override
    public void afterStory(boolean givenStory) {
        for (StoryReporter reporter : this.delegates) {
            reporter.afterStory(givenStory);
        }
    }

    @Override
    public void beforeScenario(Scenario scenario) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeScenario(scenario);
        }
    }

    @Override
    public void beforeScenario(String scenarioTitle) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeScenario(scenarioTitle);
        }
    }

    @Override
    public void scenarioMeta(Meta meta) {
        for (StoryReporter reporter : this.delegates) {
            reporter.scenarioMeta(meta);
        }
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeStory(story, givenStory);
        }
    }

    @Override
    public void narrative(Narrative narrative) {
        for (StoryReporter reporter : this.delegates) {
            reporter.narrative(narrative);
        }
    }

    @Override
    public void lifecyle(Lifecycle lifecycle) {
        for (StoryReporter reporter : this.delegates) {
            reporter.lifecyle(lifecycle);
        }
    }

    @Override
    public void beforeScenarioSteps(StepCollector.Stage stage) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeScenarioSteps(stage);
        }
    }

    @Override
    public void afterScenarioSteps(StepCollector.Stage stage) {
        for (StoryReporter reporter : this.delegates) {
            reporter.afterScenarioSteps(stage);
        }
    }

    @Override
    public void beforeStorySteps(StepCollector.Stage stage) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeStorySteps(stage);
        }
    }

    @Override
    public void afterStorySteps(StepCollector.Stage stage) {
        for (StoryReporter reporter : this.delegates) {
            reporter.afterStorySteps(stage);
        }
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeExamples(steps, table);
        }
    }

    @Override
    public void example(Map<String, String> tableRow) {
        for (StoryReporter reporter : this.delegates) {
            reporter.example(tableRow);
        }
    }

    @Override
    public void example(Map<String, String> tableRow, int exampleIndex) {
        for (StoryReporter reporter : this.delegates) {
            reporter.example(tableRow, exampleIndex);
        }
    }

    @Override
    public void afterExamples() {
        for (StoryReporter reporter : this.delegates) {
            reporter.afterExamples();
        }
    }

    @Override
    public void failed(String step, Throwable cause) {
        for (StoryReporter reporter : this.delegates) {
            reporter.failed(step, cause);
        }
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        for (StoryReporter reporter : this.delegates) {
            reporter.failedOutcomes(step, table);
        }
    }

    @Override
    public void beforeGivenStories() {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeGivenStories();
        }
    }

    @Override
    public void givenStories(GivenStories givenStories) {
        for (StoryReporter reporter : this.delegates) {
            reporter.givenStories(givenStories);
        }
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        for (StoryReporter reporter : this.delegates) {
            reporter.givenStories(storyPaths);
        }
    }

    @Override
    public void afterGivenStories() {
        for (StoryReporter reporter : this.delegates) {
            reporter.afterGivenStories();
        }
    }

    @Override
    public void beforeStep(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.beforeStep(step);
        }
    }

    @Override
    public void ignorable(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.ignorable(step);
        }
    }

    @Override
    public void comment(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.comment(step);
        }
    }

    @Override
    public void notPerformed(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.notPerformed(step);
        }
    }

    @Override
    public void pending(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.pending(step);
        }
    }

    @Override
    public void successful(String step) {
        for (StoryReporter reporter : this.delegates) {
            reporter.successful(step);
        }
    }

    @Override
    public void scenarioNotAllowed(Scenario scenario, String filter) {
        for (StoryReporter reporter : this.delegates) {
            reporter.scenarioNotAllowed(scenario, filter);
        }
    }

    @Override
    public void storyNotAllowed(Story story, String filter) {
        for (StoryReporter reporter : this.delegates) {
            reporter.storyNotAllowed(story, filter);
        }
    }

    @Override
    public void dryRun() {
        for (StoryReporter reporter : this.delegates) {
            reporter.dryRun();
        }
    }

    @Override
    public void pendingMethods(List<String> methods) {
        for (StoryReporter reporter : this.delegates) {
            reporter.pendingMethods(methods);
        }
    }

    @Override
    public void restarted(String step, Throwable cause) {
        for (StoryReporter reporter : this.delegates) {
            reporter.restarted(step, cause);
        }
    }

    @Override
    public void restartedStory(Story story, Throwable cause) {
        for (StoryReporter reporter : this.delegates) {
            reporter.restartedStory(story, cause);
        }
    }

    @Override
    public void storyCancelled(Story story, StoryDuration storyDuration) {
        for (StoryReporter reporter : this.delegates) {
            reporter.storyCancelled(story, storyDuration);
        }
    }

    public Collection<StoryReporter> getDelegates() {
        return this.delegates;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

