/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.io.CodeLocations;
import org.jbehave.core.io.StoryLocation;
import org.jbehave.core.reporters.PrintStreamFactory;

public class FilePrintStreamFactory
implements PrintStreamFactory {
    private final StoryLocation storyLocation;
    private FileConfiguration configuration;
    private File outputFile;

    public FilePrintStreamFactory(StoryLocation storyLocation) {
        this(storyLocation, new FileConfiguration());
    }

    public FilePrintStreamFactory(StoryLocation storyLocation, FileConfiguration configuration) {
        this.storyLocation = storyLocation;
        this.configuration = configuration;
    }

    @Override
    public PrintStream createPrintStream() {
        try {
            this.outputFile = this.outputFile();
            this.outputFile.getParentFile().mkdirs();
            return new FilePrintStream(this.outputFile, false);
        }
        catch (Exception e) {
            throw new PrintStreamCreationFailed(this.outputFile, e);
        }
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void useConfiguration(FileConfiguration configuration) {
        this.configuration = configuration;
        this.outputFile = this.outputFile();
    }

    public FileConfiguration configuration() {
        return this.configuration;
    }

    protected File outputFile() {
        return new File(this.outputDirectory(), this.outputName());
    }

    protected File outputDirectory() {
        return new File(this.configuration.getPathResolver().resolveDirectory(this.storyLocation, this.configuration.getRelativeDirectory()));
    }

    protected String outputName() {
        return this.configuration.getPathResolver().resolveName(this.storyLocation, this.configuration.getExtension());
    }

    public class PrintStreamCreationFailed
    extends RuntimeException {
        public PrintStreamCreationFailed(File file, Exception cause) {
            super("Failed to create print stream for file " + file, cause);
        }
    }

    public static class FileConfiguration {
        public static final String RELATIVE_DIRECTORY = "jbehave";
        public static final String EXTENSION = "html";
        private final String relativeDirectory;
        private final String extension;
        private final FilePathResolver pathResolver;

        public FileConfiguration() {
            this(EXTENSION);
        }

        public FileConfiguration(String extension) {
            this(RELATIVE_DIRECTORY, extension, new ResolveToPackagedName());
        }

        public FileConfiguration(String relativeDirectory, String extension, FilePathResolver pathResolver) {
            this.relativeDirectory = relativeDirectory;
            this.extension = extension;
            this.pathResolver = pathResolver;
        }

        public String getRelativeDirectory() {
            return this.relativeDirectory;
        }

        public String getExtension() {
            return this.extension;
        }

        public FilePathResolver getPathResolver() {
            return this.pathResolver;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class FilePrintStream
    extends PrintStream {
        private final File outputFile;
        private final boolean append;

        public FilePrintStream(File outputFile, boolean append) throws FileNotFoundException {
            super(new FileOutputStream(outputFile, append));
            this.outputFile = outputFile;
            this.append = append;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.outputFile).append(this.append).toString();
        }
    }

    public static class ResolveToSimpleName
    extends AbstractPathResolver {
        @Override
        public String resolveName(StoryLocation storyLocation, String extension) {
            String name = storyLocation.getPath();
            if (StringUtils.contains((CharSequence)name, (int)47)) {
                name = StringUtils.substringAfterLast((String)name, (String)"/");
            }
            return StringUtils.substringBeforeLast((String)name, (String)".") + "." + extension;
        }
    }

    public static class ResolveToPackagedName
    extends AbstractPathResolver {
        @Override
        public String resolveName(StoryLocation storyLocation, String extension) {
            String name = storyLocation.getPath().replaceAll(":?/", ".");
            if (name.startsWith(".")) {
                name = name.substring(1);
            }
            return StringUtils.substringBeforeLast((String)name, (String)".") + "." + extension;
        }
    }

    public static abstract class AbstractPathResolver
    implements FilePathResolver {
        @Override
        public String resolveDirectory(StoryLocation storyLocation, String relativeDirectory) {
            File parent = new File(CodeLocations.getPathFromURL(storyLocation.getCodeLocation())).getParentFile();
            return parent.getPath().replace('\\', '/') + "/" + relativeDirectory;
        }
    }

    public static interface FilePathResolver {
        public String resolveDirectory(StoryLocation var1, String var2);

        public String resolveName(StoryLocation var1, String var2);
    }
}

