/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.model.Composite;
import org.jbehave.core.parsers.CompositeParser;
import org.jbehave.core.steps.AbstractCandidateSteps;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.PatternVariantBuilder;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepType;

public class CompositeCandidateSteps
extends AbstractCandidateSteps {
    private final Set<String> compositePaths;

    public CompositeCandidateSteps(Configuration configuration, Set<String> compositePaths) {
        super(configuration);
        this.compositePaths = compositePaths;
    }

    @Override
    public List<StepCandidate> listCandidates() {
        CompositeParser parser = this.configuration().compositeParser();
        StoryLoader resourceLoader = this.configuration().storyLoader();
        ArrayList<StepCandidate> candidates = new ArrayList<StepCandidate>();
        for (String compositePath : this.compositePaths) {
            List<Composite> composites = parser.parseComposites(resourceLoader.loadResourceAsText(compositePath));
            this.addCandidatesFromComposites(candidates, composites);
        }
        return candidates;
    }

    private void addCandidatesFromComposites(List<StepCandidate> candidates, List<Composite> composites) {
        for (Composite composite : composites) {
            String[] steps = composite.getSteps().toArray(new String[0]);
            this.addCandidatesFromVariants(candidates, composite.getStepType(), composite.getStepWithoutStartingWord(), composite.getPriority(), steps);
        }
    }

    private void addCandidatesFromVariants(List<StepCandidate> candidates, StepType stepType, String value, int priority, String[] steps) {
        PatternVariantBuilder b = new PatternVariantBuilder(value);
        for (String variant : b.allVariants()) {
            StepCandidate candidate = this.createCandidate(variant, priority, stepType, null, null, null);
            this.checkForDuplicateCandidates(candidates, candidate);
            candidate.composedOf(steps);
            candidates.add(candidate);
        }
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterStories() {
        return Collections.emptyList();
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterStory(boolean givenStory) {
        return Collections.emptyList();
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterScenario(ScenarioType type) {
        return Collections.emptyList();
    }
}

