/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStories;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.Alias;
import org.jbehave.core.annotations.Aliases;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStories;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Composite;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.steps.AbstractCandidateSteps;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.InstanceStepsFactory;
import org.jbehave.core.steps.PatternVariantBuilder;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepType;

public class Steps
extends AbstractCandidateSteps {
    private Class<?> type;
    private InjectableStepsFactory stepsFactory;
    private StepCreator stepCreator;

    public Steps() {
        this(new MostUsefulConfiguration());
    }

    public Steps(Configuration configuration) {
        super(configuration);
        this.type = this.getClass();
        this.stepsFactory = new InstanceStepsFactory(configuration, this);
        this.stepCreator = new StepCreator(this.type, this.stepsFactory, this.configuration().stepsContext(), this.configuration().parameterConverters(), this.configuration().parameterControls(), null, this.configuration().stepMonitor());
    }

    public Steps(Configuration configuration, Object instance) {
        this(configuration, instance.getClass(), new InstanceStepsFactory(configuration, instance));
    }

    public Steps(Configuration configuration, Class<?> type, InjectableStepsFactory stepsFactory) {
        super(configuration);
        this.type = type;
        this.stepsFactory = stepsFactory;
        this.stepCreator = new StepCreator(type, stepsFactory, this.configuration().stepsContext(), this.configuration().parameterConverters(), this.configuration().parameterControls(), null, this.configuration().stepMonitor());
    }

    public Class<?> type() {
        return this.type;
    }

    public Object instance() {
        return this.stepsFactory.createInstanceOfType(this.type);
    }

    @Override
    public List<StepCandidate> listCandidates() {
        ArrayList<StepCandidate> candidates = new ArrayList<StepCandidate>();
        for (Method method : this.allMethods()) {
            int priority;
            String value;
            Annotation annotation;
            if (method.isAnnotationPresent(Given.class)) {
                annotation = method.getAnnotation(Given.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.GIVEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.GIVEN, priority);
            }
            if (method.isAnnotationPresent(When.class)) {
                annotation = method.getAnnotation(When.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.WHEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.WHEN, priority);
            }
            if (!method.isAnnotationPresent(Then.class)) continue;
            annotation = method.getAnnotation(Then.class);
            value = annotation.value();
            priority = annotation.priority();
            this.addCandidatesFromVariants(candidates, method, StepType.THEN, value, priority);
            this.addCandidatesFromAliases(candidates, method, StepType.THEN, priority);
        }
        return candidates;
    }

    private void addCandidatesFromVariants(List<StepCandidate> candidates, Method method, StepType stepType, String value, int priority) {
        PatternVariantBuilder b = new PatternVariantBuilder(value);
        for (String variant : b.allVariants()) {
            this.addCandidate(candidates, method, stepType, variant, priority);
        }
    }

    private void addCandidatesFromAliases(List<StepCandidate> candidates, Method method, StepType stepType, int priority) {
        if (method.isAnnotationPresent(Aliases.class)) {
            String[] aliases;
            for (String alias : aliases = method.getAnnotation(Aliases.class).values()) {
                this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
            }
        }
        if (method.isAnnotationPresent(Alias.class)) {
            String alias = method.getAnnotation(Alias.class).value();
            this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
        }
    }

    private void addCandidate(List<StepCandidate> candidates, Method method, StepType stepType, String stepPatternAsString, int priority) {
        StepCandidate candidate = this.createCandidate(stepPatternAsString, priority, stepType, method, this.type, this.stepsFactory);
        this.checkForDuplicateCandidates(candidates, candidate);
        if (method.isAnnotationPresent(Composite.class)) {
            candidate.composedOf(method.getAnnotation(Composite.class).steps());
        }
        candidates.add(candidate);
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterStories() {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.listSteps(BeforeStories.class, StepCollector.Stage.BEFORE, v -> true, BeforeStories::order));
        steps.addAll(this.listSteps(AfterStories.class, StepCollector.Stage.AFTER, v -> true, AfterStories::order));
        return steps;
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterStory(boolean givenStory) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.listSteps(BeforeStory.class, StepCollector.Stage.BEFORE, v -> v.uponGivenStory() == givenStory, BeforeStory::order));
        steps.addAll(this.listSteps(AfterStory.class, StepCollector.Stage.AFTER, v -> v.uponGivenStory() == givenStory, AfterStory::order));
        return steps;
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterScenario(ScenarioType type) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.listSteps(BeforeScenario.class, StepCollector.Stage.BEFORE, v -> v.uponType() == type, BeforeScenario::order));
        for (AfterScenario.Outcome outcome : new AfterScenario.Outcome[]{AfterScenario.Outcome.ANY, AfterScenario.Outcome.SUCCESS, AfterScenario.Outcome.FAILURE}) {
            steps.addAll(this.listSteps(AfterScenario.class, StepCollector.Stage.AFTER, m -> new BeforeOrAfterStep(StepCollector.Stage.AFTER, (Method)m, outcome, this.stepCreator), v -> v.uponType() == type && v.uponOutcome() == outcome, AfterScenario::order));
        }
        return steps;
    }

    private <T extends Annotation> List<BeforeOrAfterStep> listSteps(Class<T> type, StepCollector.Stage stage, Predicate<T> predicate, ToIntFunction<T> order) {
        return this.listSteps(type, stage, m -> new BeforeOrAfterStep(stage, (Method)m, this.stepCreator), predicate, order);
    }

    private <T extends Annotation> List<BeforeOrAfterStep> listSteps(Class<T> type, StepCollector.Stage stage, Function<Method, BeforeOrAfterStep> factory, Predicate<T> predicate, ToIntFunction<T> order) {
        Comparator orderComparator = StepCollector.Stage.AFTER == stage ? Comparator.naturalOrder() : Comparator.reverseOrder();
        return this.methodsAnnotatedWith(type).entrySet().stream().filter(e -> predicate.test(e.getValue())).collect(Collectors.toList()).stream().sorted(Comparator.comparing(e -> order.applyAsInt(e.getValue()), orderComparator)).map(Map.Entry::getKey).map(factory).collect(Collectors.toList());
    }

    private Method[] allMethods() {
        return this.type.getMethods();
    }

    private <T extends Annotation> Map<Method, T> methodsAnnotatedWith(Class<T> annotationClass) {
        LinkedHashMap<Method, T> annotated = new LinkedHashMap<Method, T>();
        for (Method method : this.allMethods()) {
            T annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            annotated.put(method, annotation);
        }
        return annotated;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.instance()).toString();
    }
}

