/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.StepExecution;
import org.jberet._private.BatchLogger;
import org.jberet.creation.ArtifactCreationContext;
import org.jberet.job.model.Job;
import org.jberet.runtime.AbstractExecution;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.JobStopNotificationListener;
import org.jberet.util.BatchUtil;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class JobExecutionImpl
extends AbstractExecution
implements JobExecution,
Cloneable {
    private static final long serialVersionUID = 3706885354351337764L;
    private static final char RESTART_POSITION_USER_SEP = '\"';
    private long id;
    private final JobInstanceImpl jobInstance;
    private Job substitutedJob;
    private final List<StepExecution> stepExecutions = new CopyOnWriteArrayList<StepExecution>();
    private Properties jobParameters;
    protected long createTime;
    protected long lastUpdatedTime;
    private String restartPosition;
    private String user;
    private transient CountDownLatch jobTerminationLatch = new CountDownLatch(1);
    private final AtomicBoolean stopRequested = new AtomicBoolean();
    private final transient List<JobStopNotificationListener> jobStopNotificationListeners = new ArrayList<JobStopNotificationListener>();

    public JobExecutionImpl(final JobInstanceImpl jobInstance, Properties jobParameters) throws JobStartException {
        this.jobInstance = jobInstance;
        this.jobParameters = jobParameters;
        this.substitutedJob = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(new PrivilegedAction<Job>(){

            @Override
            public Job run() {
                return BatchUtil.clone(jobInstance.unsubstitutedJob);
            }
        }) : BatchUtil.clone(jobInstance.unsubstitutedJob);
        this.createTime = System.currentTimeMillis();
        this.setBatchStatus(BatchStatus.STARTING);
    }

    public JobExecutionImpl(JobInstanceImpl jobInstance, long id, Properties jobParameters, Date createTime, Date startTime, Date endTime, Date lastUpdatedTime, String batchStatus, String exitStatus, String restartPositionAndUser) {
        this.jobInstance = jobInstance;
        this.jobParameters = jobParameters;
        this.id = id;
        if (createTime != null) {
            this.createTime = createTime.getTime();
        }
        if (startTime != null) {
            this.startTime = startTime.getTime();
        }
        if (endTime != null) {
            this.endTime = endTime.getTime();
        }
        if (lastUpdatedTime != null) {
            this.lastUpdatedTime = lastUpdatedTime.getTime();
        }
        this.batchStatus = BatchStatus.valueOf((String)batchStatus);
        this.exitStatus = exitStatus;
        this.splitRestartPositionAndUser(restartPositionAndUser);
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public JobExecutionImpl clone() {
        JobExecutionImpl result = null;
        try {
            result = (JobExecutionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            BatchLogger.LOGGER.failToClone(e, this, this.getJobName(), "");
        }
        return result;
    }

    public void awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.jobTerminationLatch != null) {
            if (timeout <= 0L) {
                this.jobTerminationLatch.await();
            } else {
                this.jobTerminationLatch.await(timeout, timeUnit);
            }
        }
    }

    public Job getSubstitutedJob() {
        return this.substitutedJob;
    }

    @Override
    public void setBatchStatus(BatchStatus batchStatus) {
        super.setBatchStatus(batchStatus);
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    public long getExecutionId() {
        return this.id;
    }

    public String getJobName() {
        return this.jobInstance.getJobName();
    }

    public Date getCreateTime() {
        return new Date(this.createTime);
    }

    public Date getLastUpdatedTime() {
        return new Date(this.lastUpdatedTime);
    }

    public JobInstanceImpl getJobInstance() {
        return this.jobInstance;
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }

    public void addJobParameter(String k, String v) {
        if (this.jobParameters == null) {
            this.jobParameters = new Properties();
        }
        this.jobParameters.setProperty(k, v);
    }

    public List<StepExecution> getStepExecutions() {
        return this.stepExecutions;
    }

    public void addStepExecution(StepExecution stepExecution) {
        this.stepExecutions.add(stepExecution);
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    public void setRestartPosition(String restartPosition) {
        this.restartPosition = restartPosition;
    }

    public String getRestartPosition() {
        return this.restartPosition;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String combineRestartPositionAndUser() {
        if (this.restartPosition == null && this.user == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.restartPosition != null) {
            sb.append(this.restartPosition);
        }
        if (this.user != null) {
            sb.append('\"').append(this.user);
        }
        return sb.toString();
    }

    private void splitRestartPositionAndUser(String restartPositionAndUser) {
        if (restartPositionAndUser != null) {
            int i = restartPositionAndUser.indexOf(34);
            if (i < 0) {
                this.restartPosition = restartPositionAndUser;
            } else if (i > 0) {
                this.restartPosition = restartPositionAndUser.substring(0, i);
                this.user = restartPositionAndUser.substring(i + 1);
            } else {
                this.user = restartPositionAndUser.substring(1);
            }
        }
    }

    public boolean isStopRequested() {
        return this.stopRequested.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        JobStopNotificationListener[] ls;
        this.stopRequested.set(true);
        List<JobStopNotificationListener> list = this.jobStopNotificationListeners;
        synchronized (list) {
            ls = this.jobStopNotificationListeners.toArray(new JobStopNotificationListener[this.jobStopNotificationListeners.size()]);
        }
        for (JobStopNotificationListener l : ls) {
            l.stopRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJobStopNotifier(JobStopNotificationListener l) {
        List<JobStopNotificationListener> list = this.jobStopNotificationListeners;
        synchronized (list) {
            this.jobStopNotificationListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterJobStopNotifier(JobStopNotificationListener l) {
        List<JobStopNotificationListener> list = this.jobStopNotificationListeners;
        synchronized (list) {
            this.jobStopNotificationListeners.remove(l);
        }
    }

    public void setLastUpdatedTime(long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void cleanUp() {
        this.substitutedJob = null;
        if (this.batchStatus == BatchStatus.COMPLETED) {
            this.jobInstance.setUnsubstitutedJob(null);
        }
        ArtifactCreationContext.removeCurrentArtifactCreationContext();
        this.jobTerminationLatch.countDown();
        this.jobTerminationLatch = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobExecutionImpl that = (JobExecutionImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }
}

