/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation.compiler;

import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class MemberValuePopulate
implements MemberValueVisitor {
    private String value;

    public MemberValuePopulate(String value) {
        this.value = value;
    }

    public void visitAnnotationMemberValue(AnnotationMemberValue annotationMemberValue) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public void visitArrayMemberValue(ArrayMemberValue arrayMemberValue) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public void visitBooleanMemberValue(BooleanMemberValue booleanMemberValue) {
        Boolean bool = new Boolean(this.value);
        booleanMemberValue.setValue(bool.booleanValue());
    }

    public void visitByteMemberValue(ByteMemberValue byteMemberValue) {
        byteMemberValue.setValue(Byte.parseByte(this.value));
    }

    public void visitCharMemberValue(CharMemberValue charMemberValue) {
        charMemberValue.setValue(this.value.charAt(0));
    }

    public void visitDoubleMemberValue(DoubleMemberValue doubleMemberValue) {
        doubleMemberValue.setValue(Double.parseDouble(this.value));
    }

    public void visitEnumMemberValue(EnumMemberValue enumMemberValue) {
        int index = this.value.lastIndexOf(46);
        if (index == -1) {
            throw new RuntimeException("Enum must be fully qualified: " + this.value);
        }
        String className = this.value.substring(0, index);
        String en = this.value.substring(index + 1);
        enumMemberValue.setType(className);
        enumMemberValue.setValue(en);
    }

    public void visitFloatMemberValue(FloatMemberValue floatMemberValue) {
        floatMemberValue.setValue(Float.parseFloat(this.value));
    }

    public void visitIntegerMemberValue(IntegerMemberValue integerMemberValue) {
        integerMemberValue.setValue(Integer.parseInt(this.value));
    }

    public void visitLongMemberValue(LongMemberValue longMemberValue) {
        longMemberValue.setValue(Long.parseLong(this.value));
    }

    public void visitShortMemberValue(ShortMemberValue shortMemberValue) {
        shortMemberValue.setValue(Short.parseShort(this.value));
    }

    public void visitStringMemberValue(StringMemberValue stringMemberValue) {
        stringMemberValue.setValue(this.value);
    }

    public void visitClassMemberValue(ClassMemberValue classMemberValue) {
        if (this.value.endsWith(".class")) {
            this.value = this.value.substring(0, this.value.indexOf(".class"));
        }
        classMemberValue.setValue(this.value);
    }
}

