/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.io.ObjectStreamException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.ContainerProxyCacheKey;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.aop.proxy.container.InstanceProxyContainer;
import org.jboss.aop.proxy.container.MarshalledContainerProxy;
import org.jboss.aop.proxy.container.MarshalledProxyAdvisor;
import org.jboss.aop.proxy.container.ProxyAdvisorDomain;

public class ProxyTemplate
implements Delegate,
AspectManaged {
    private transient Advisor classAdvisor;
    private transient InstanceAdvisor instanceAdvisor;
    protected volatile transient Advisor currentAdvisor;
    private Object delegate;
    private Object[] mixins;
    private SimpleMetaData metadata;
    private ContainerProxyCacheKey key;

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public void setContainerProxyCacheKey(ContainerProxyCacheKey key) {
        this.key = key;
    }

    public Advisor getAdvisor() {
        return this.currentAdvisor;
    }

    public void setAdvisor(Advisor advisor) {
        this.currentAdvisor = this.classAdvisor = advisor;
    }

    public void setMetadata(SimpleMetaData metadata) {
        this.metadata = metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstanceAdvisor(InstanceAdvisor ia) {
        ProxyTemplate proxyTemplate = this;
        synchronized (proxyTemplate) {
            if (this.instanceAdvisor != null) {
                throw new RuntimeException("InstanceAdvisor already set");
            }
            if (!(ia instanceof InstanceProxyContainer)) {
                throw new RuntimeException("Wrong type for instance advisor: " + this.instanceAdvisor);
            }
            this.instanceAdvisor = ia;
            this.currentAdvisor = (InstanceProxyContainer)ia;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceAdvisor getInstanceAdvisor() {
        ProxyTemplate proxyTemplate = this;
        synchronized (proxyTemplate) {
            if (this.instanceAdvisor == null) {
                InstanceProxyContainer ipc = ((ClassProxyContainer)this.currentAdvisor).createInstanceProxyContainer();
                this.setInstanceAdvisor(ipc);
            }
        }
        return this.instanceAdvisor;
    }

    public boolean equals(Object obj) {
        if (this.delegate != null) {
            if (obj != null && obj instanceof Delegate) {
                obj = ((Delegate)obj).getDelegate();
            }
            return this.delegate.equals(obj);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.delegate != null) {
            return this.delegate.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        if (this.delegate != null) {
            return this.delegate.toString() + " (proxied by " + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + ")";
        }
        return super.toString() + "(empty proxy of " + this.getClass().getSuperclass().getName() + ")";
    }

    private Object writeReplace() throws ObjectStreamException {
        return new MarshalledContainerProxy(this, this.key, this.mixins, this.delegate, this.currentAdvisor, this.metadata);
    }

    public void localUnmarshal(MarshalledContainerProxy proxy) {
        this.delegate = proxy.getDelegate();
        this.mixins = proxy.getMixins();
        this.metadata = proxy.getMetadata();
        this.key = proxy.getKey();
        this.currentAdvisor = this.classAdvisor = ContainerCache.getCachedContainer(this.key);
        if (proxy.getInstanceAdvisorDomainName() != null) {
            ProxyAdvisorDomain domain = (ProxyAdvisorDomain)AspectManager.getTopLevelAspectManager().findManagerByName(proxy.getInstanceAdvisorDomainName());
            this.currentAdvisor = domain.getAdvisor();
        }
    }

    public void remoteUnmarshal(MarshalledContainerProxy proxy, MarshalledProxyAdvisor advisor) {
        this.delegate = proxy.getDelegate();
        this.mixins = proxy.getMixins();
        this.metadata = proxy.getMetadata();
        this.key = proxy.getKey();
        this.classAdvisor = advisor;
        this.currentAdvisor = advisor;
        this.instanceAdvisor = advisor;
    }
}

