/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.lang.reflect.Method;
import java.util.Stack;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.ContextLifecycleManager;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.context.TestContext;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunnerAdaptor;
import org.jboss.arquillian.spi.event.Event;
import org.jboss.arquillian.spi.event.suite.After;
import org.jboss.arquillian.spi.event.suite.AfterClass;
import org.jboss.arquillian.spi.event.suite.AfterSuite;
import org.jboss.arquillian.spi.event.suite.Before;
import org.jboss.arquillian.spi.event.suite.BeforeClass;
import org.jboss.arquillian.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.spi.event.suite.Test;

public class EventTestRunnerAdaptor
implements TestRunnerAdaptor {
    private ContextLifecycleManager contextLifecycle;
    private Stack<Context> activeContext = new Stack();

    public EventTestRunnerAdaptor(ContextLifecycleManager contextLifecycle) {
        Validate.notNull(contextLifecycle, "ContextLifecycle must be specified");
        this.contextLifecycle = contextLifecycle;
    }

    public Context getActiveContext() {
        if (this.activeContext.empty()) {
            return null;
        }
        return this.activeContext.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeSuite() throws Exception {
        SuiteContext suiteContext = this.contextLifecycle.createRestoreSuiteContext();
        try {
            suiteContext.fire((Event)new BeforeSuite());
        }
        finally {
            this.activeContext.push(suiteContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSuite() throws Exception {
        this.contextLifecycle.createRestoreSuiteContext().fire((Event)new AfterSuite());
        try {
            this.contextLifecycle.destroySuiteContext();
        }
        finally {
            this.activeContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeClass(Class<?> testClass) throws Exception {
        Validate.notNull(testClass, "TestClass must be specified");
        ClassContext classContext = this.contextLifecycle.createRestoreClassContext(testClass);
        try {
            BeforeClass event = new BeforeClass(testClass);
            classContext.add(TestClass.class, event.getTestClass());
            classContext.fire((Event)event);
        }
        finally {
            this.activeContext.push(classContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterClass(Class<?> testClass) throws Exception {
        Validate.notNull(testClass, "TestClass must be specified");
        this.contextLifecycle.createRestoreClassContext(testClass).fire((Event)new AfterClass(testClass));
        try {
            this.contextLifecycle.destroyClassContext(testClass);
        }
        finally {
            this.activeContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(Object testInstance, Method testMethod) throws Exception {
        Validate.notNull(testInstance, "TestInstance must be specified");
        Validate.notNull(testMethod, "TestMethod must be specified");
        TestContext testContext = this.contextLifecycle.createRestoreTestContext(testInstance);
        try {
            testContext.fire((Event)new Before(testInstance, testMethod));
        }
        finally {
            this.activeContext.push(testContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object testInstance, Method testMethod) throws Exception {
        Validate.notNull(testInstance, "TestInstance must be specified");
        Validate.notNull(testMethod, "TestMethod must be specified");
        this.contextLifecycle.createRestoreTestContext(testInstance).fire((Event)new After(testInstance, testMethod));
        try {
            this.contextLifecycle.destroyTestContext(testInstance);
        }
        finally {
            this.activeContext.pop();
        }
    }

    public TestResult test(TestMethodExecutor testMethodExecutor) throws Exception {
        Validate.notNull(testMethodExecutor, "TestMethodExecutor must be specified");
        Test test = new Test(testMethodExecutor);
        TestContext context = this.contextLifecycle.createRestoreTestContext(testMethodExecutor.getInstance());
        context.fire((Event)test);
        return context.get(TestResult.class);
    }
}

