/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.context;

import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.ProfileBuilder;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.context.TestContext;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ServiceLoader;

public class ContextLifecycleManager {
    private Configuration configuration;
    private ProfileBuilder profileBuilder;
    private ServiceLoader serviceLoader;
    private SuiteContext suiteContext;
    private ConcurrentHashMap<Class<?>, ClassContext> classContextStore;
    private ConcurrentHashMap<Object, TestContext> testContextStore;

    public ContextLifecycleManager(ProfileBuilder profileBuilder, ServiceLoader serviceLoader) {
        this(new Configuration(), profileBuilder, serviceLoader);
    }

    public ContextLifecycleManager(Configuration configuration, ProfileBuilder profileBuilder, ServiceLoader serviceLoader) {
        Validate.notNull(configuration, "Configuration must be specified");
        Validate.notNull(profileBuilder, "ProfileBuilder must be specified");
        Validate.notNull(serviceLoader, "ServiceLoader must be specified");
        this.configuration = configuration;
        this.profileBuilder = profileBuilder;
        this.serviceLoader = serviceLoader;
        this.classContextStore = new ConcurrentHashMap();
        this.testContextStore = new ConcurrentHashMap();
    }

    public SuiteContext createRestoreSuiteContext() {
        if (this.suiteContext == null) {
            this.suiteContext = new SuiteContext(this.serviceLoader);
            this.suiteContext.add(Configuration.class, this.configuration);
            this.profileBuilder.buildSuiteContext(this.suiteContext);
        }
        return this.suiteContext;
    }

    public void destroySuiteContext() {
        this.suiteContext = null;
    }

    public ClassContext createRestoreClassContext(Class<?> testClass) {
        Validate.notNull(testClass, "TestClass must be specified");
        if (this.suiteContext == null) {
            throw new IllegalStateException("No " + SuiteContext.class.getSimpleName() + " found, please create one before creating a " + ClassContext.class.getSimpleName());
        }
        if (!this.classContextStore.containsKey(testClass)) {
            ClassContext classContext = new ClassContext(this.createRestoreSuiteContext());
            this.profileBuilder.buildClassContext(classContext, testClass);
            this.classContextStore.putIfAbsent(testClass, classContext);
        }
        return this.classContextStore.get(testClass);
    }

    public void destroyClassContext(Class<?> testClass) {
        this.classContextStore.remove(testClass);
    }

    public TestContext createRestoreTestContext(Object testInstance) {
        Validate.notNull(testInstance, "TestInstance must be specified");
        if (!this.testContextStore.containsKey(testInstance)) {
            TestContext testContext = new TestContext(this.createRestoreClassContext(testInstance.getClass()));
            this.profileBuilder.buildTestContext(testContext, testInstance);
            this.testContextStore.putIfAbsent(testInstance, testContext);
        }
        return this.testContextStore.get(testInstance);
    }

    public void destroyTestContext(Object testInstance) {
        this.testContextStore.remove(testInstance);
    }
}

