/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client;

import java.lang.reflect.Method;
import org.jboss.arquillian.api.OperateOnDeployment;
import org.jboss.arquillian.impl.ThreadContext;
import org.jboss.arquillian.impl.client.container.event.ContainerControlEvent;
import org.jboss.arquillian.impl.client.container.event.DeploymentEvent;
import org.jboss.arquillian.impl.core.spi.EventContext;
import org.jboss.arquillian.impl.core.spi.context.ContainerContext;
import org.jboss.arquillian.impl.core.spi.context.DeploymentContext;
import org.jboss.arquillian.impl.domain.Container;
import org.jboss.arquillian.impl.domain.ContainerRegistry;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.spi.client.test.DeploymentTargetDescription;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.event.suite.After;
import org.jboss.arquillian.spi.event.suite.Before;
import org.jboss.arquillian.spi.event.suite.Test;
import org.jboss.arquillian.spi.event.suite.TestEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerDeploymentContextHandler {
    @Inject
    private Instance<ContainerContext> containerContext;
    @Inject
    private Instance<DeploymentContext> deploymentContext;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContainerContext(@Observes EventContext<ContainerControlEvent> context) {
        ContainerContext containerContext = (ContainerContext)this.containerContext.get();
        ContainerControlEvent event = context.getEvent();
        try {
            containerContext.activate(event.getContainerName());
            ThreadContext.set(event.getContainer().getClassLoader());
            context.proceed();
        }
        finally {
            ThreadContext.reset();
            containerContext.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDeploymentContext(@Observes EventContext<DeploymentEvent> context) {
        DeploymentContext deploymentContext = (DeploymentContext)this.deploymentContext.get();
        try {
            DeploymentEvent event = context.getEvent();
            deploymentContext.activate(event.getDeployment());
            context.proceed();
        }
        finally {
            deploymentContext.deactivate();
        }
    }

    public void createBeforeContext(@Observes EventContext<Before> context) {
        this.createContext(context);
    }

    public void createTestContext(@Observes EventContext<Test> context) {
        this.createContext(context);
    }

    public void createAfterContext(@Observes EventContext<After> context) {
        this.createContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContext(EventContext<? extends TestEvent> context) {
        try {
            this.lookup(context.getEvent().getTestMethod(), new Activate());
            context.proceed();
        }
        finally {
            this.lookup(context.getEvent().getTestMethod(), new DeActivate());
        }
    }

    private void lookup(Method method, ResultCallback callback) {
        DeploymentTargetDescription deploymentTarget = this.locateDeployment(method);
        ContainerRegistry containerRegistry = (ContainerRegistry)this.containerRegistry.get();
        DeploymentScenario deploymentScenario = (DeploymentScenario)this.deploymentScenario.get();
        DeploymentDescription deployment = deploymentScenario.getDeployment(deploymentTarget);
        Container container = containerRegistry.getContainer(deployment.getTarget());
        callback.call(container, deployment);
    }

    private DeploymentTargetDescription locateDeployment(Method method) {
        DeploymentTargetDescription target = null;
        target = method.isAnnotationPresent(OperateOnDeployment.class) ? new DeploymentTargetDescription(method.getAnnotation(OperateOnDeployment.class).value()) : DeploymentTargetDescription.DEFAULT;
        return target;
    }

    private class DeActivate
    extends ResultCallback {
        private DeActivate() {
        }

        void call(Container container, DeploymentDescription deployment) {
            ((ContainerContext)ContainerDeploymentContextHandler.this.containerContext.get()).deactivate();
            ((DeploymentContext)ContainerDeploymentContextHandler.this.deploymentContext.get()).deactivate();
        }
    }

    private class Activate
    extends ResultCallback {
        private Activate() {
        }

        void call(Container container, DeploymentDescription deployment) {
            ((ContainerContext)ContainerDeploymentContextHandler.this.containerContext.get()).activate(container.getName());
            ((DeploymentContext)ContainerDeploymentContextHandler.this.deploymentContext.get()).activate(deployment);
        }
    }

    private abstract class ResultCallback {
        private ResultCallback() {
        }

        abstract void call(Container var1, DeploymentDescription var2);
    }
}

