/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.deployment.tool;

import java.io.File;
import java.io.FileOutputStream;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.event.container.BeforeDeploy;
import org.jboss.shrinkwrap.api.Archive;

public class ArchiveDeploymentToolingExporter {
    static final String ARQUILLIAN_TOOLING_DEPLOYMENT_FOLDER = "arquillian.tooling.deployment.folder";

    public void export(@Observes BeforeDeploy event) throws Exception {
        String deploymentOutputFolder = System.getProperty(ARQUILLIAN_TOOLING_DEPLOYMENT_FOLDER);
        if (deploymentOutputFolder == null) {
            return;
        }
        Archive deployment = event.getDeployment().getTestableArchive();
        if (deployment == null) {
            return;
        }
    }

    protected void writeOutToFile(File target, String content) {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(content, "Content must be specified");
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(target);
            output.write(content.getBytes());
            output.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write content to file", e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close output stream", e);
                }
            }
        }
    }
}

