/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.UncheckedThrow;
import org.jboss.arquillian.impl.core.Validate;
import org.jboss.arquillian.impl.core.spi.EventContext;
import org.jboss.arquillian.impl.core.spi.InvocationException;
import org.jboss.arquillian.impl.core.spi.NonManagedObserver;
import org.jboss.arquillian.impl.core.spi.ObserverMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventContextImpl<T>
implements EventContext<T> {
    private ManagerImpl manager;
    private List<ObserverMethod> interceptors;
    private List<ObserverMethod> observers;
    private NonManagedObserver<T> nonManagedObserver;
    private T event;
    private int currentInterceptor = 0;

    public EventContextImpl(ManagerImpl manager, List<ObserverMethod> interceptors, List<ObserverMethod> observers, NonManagedObserver<T> nonManagedObserver, T event) {
        Validate.notNull(manager, "Manager must be specified");
        Validate.notNull(event, "Event must be specified");
        this.manager = manager;
        this.interceptors = interceptors == null ? new ArrayList() : interceptors;
        this.observers = observers == null ? new ArrayList() : observers;
        this.nonManagedObserver = nonManagedObserver;
        this.event = event;
    }

    @Override
    public T getEvent() {
        return this.event;
    }

    @Override
    public void proceed() {
        if (this.currentInterceptor == this.interceptors.size()) {
            this.invokeObservers();
            this.invokeNonManagedObserver();
        } else {
            ObserverMethod interceptor = this.interceptors.get(this.currentInterceptor++);
            this.manager.debug(interceptor, true);
            interceptor.invoke(this.manager, this);
        }
    }

    private void invokeObservers() {
        for (ObserverMethod observer : this.observers) {
            try {
                this.manager.debug(observer, false);
                observer.invoke(this.manager, this.event);
            }
            catch (InvocationException e) {
                Throwable cause = e.getCause();
                if (this.manager.isExceptionHandled(cause)) {
                    UncheckedThrow.throwUnchecked(cause);
                    continue;
                }
                this.manager.fireException(cause);
            }
        }
    }

    private void invokeNonManagedObserver() {
        if (this.nonManagedObserver != null) {
            this.manager.inject(this.nonManagedObserver);
            this.nonManagedObserver.fired(this.getEvent());
        }
    }
}

