/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi;

import java.util.jar.Manifest;
import org.jboss.arquillian.container.osgi.CommonDeployableContainer;
import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentObserver {
    static final Logger logger = LoggerFactory.getLogger((String)DeploymentObserver.class.getPackage().getName());

    public void autostartBundle(@Observes AfterDeploy event) throws Exception {
        CommonDeployableContainer container;
        if (event.getDeployableContainer() instanceof CommonDeployableContainer && (container = (CommonDeployableContainer)event.getDeployableContainer()).isAutostartBundle()) {
            Manifest manifest = new Manifest(event.getDeployment().getArchive().get("/META-INF/MANIFEST.MF").getAsset().openStream());
            OSGiMetaData metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
            if (metadata.getFragmentHost() == null) {
                container.startBundle(metadata.getBundleSymbolicName(), metadata.getBundleVersion().toString());
            } else {
                logger.debug("Fragment bundle cannot be started");
            }
        }
    }
}

