/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.arquillian.container.weld.embedded.mock.MockEjBServices;
import org.jboss.arquillian.container.weld.embedded.mock.MockSecurityServices;
import org.jboss.arquillian.container.weld.embedded.mock.MockTransactionServices;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;

public class FlatDeployment
implements CDI11Deployment {
    private final Collection<BeanDeploymentArchive> beanDeploymentArchives;
    private final ServiceRegistry services = new SimpleServiceRegistry();
    private Set<Extension> extensions;

    public FlatDeployment(BeanDeploymentArchive beanDeploymentArchive, Extension ... extensions) {
        this(new BeanDeploymentArchive[]{beanDeploymentArchive}, (Environment)Environments.SE, extensions);
    }

    public FlatDeployment(BeanDeploymentArchive beanDeploymentArchive, Environment environment, Extension ... extensions) {
        this(new BeanDeploymentArchive[]{beanDeploymentArchive}, environment, extensions);
    }

    public FlatDeployment(BeanDeploymentArchive[] beanDeploymentArchives, Extension ... extensions) {
        this(beanDeploymentArchives, (Environment)Environments.SE, extensions);
    }

    public FlatDeployment(BeanDeploymentArchive[] beanDeploymentArchives, Environment environment, Extension ... extensions) {
        this.beanDeploymentArchives = Arrays.asList(beanDeploymentArchives);
        this.extensions = new HashSet<Extension>(Arrays.asList(extensions));
        this.configureServices(environment);
    }

    protected void configureServices(Environment environment) {
        if (environment.equals(Environments.EE) || environment.equals(Environments.EE_INJECT)) {
            this.services.add(TransactionServices.class, (Service)new MockTransactionServices());
            this.services.add(EjbServices.class, (Service)new MockEjBServices());
            this.services.add(SecurityServices.class, (Service)new MockSecurityServices());
        }
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        if (this.extensions.isEmpty()) {
            Iterator<Extension> extensionsIterator = ServiceLoader.load(Extension.class).iterator();
            while (extensionsIterator.hasNext()) {
                this.extensions.add(extensionsIterator.next());
            }
        }
        return FlatDeployment.transform(this.extensions.toArray(new Extension[0]));
    }

    public static Iterable<Metadata<Extension>> transform(Extension ... extensions) {
        ArrayList<Metadata<Extension>> result = new ArrayList<Metadata<Extension>>();
        for (final Extension extension : extensions) {
            result.add(new Metadata<Extension>(){

                public String getLocation() {
                    return "unknown";
                }

                public Extension getValue() {
                    return extension;
                }
            });
        }
        return result;
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        return this.getWar();
    }

    protected BeanDeploymentArchive getWar() {
        return this.getBeanDeploymentArchives().iterator().next();
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        for (BeanDeploymentArchive archive : this.beanDeploymentArchives) {
            if (!archive.getBeanClasses().contains(beanClass)) continue;
            return archive;
        }
        return null;
    }
}

