/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded.mock;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Extension;
import org.jboss.arquillian.container.weld.embedded.mock.BeanDeploymentArchiveImpl;
import org.jboss.arquillian.container.weld.embedded.mock.FlatDeployment;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.manager.api.WeldManager;

public class TestContainer {
    private final Deployment deployment;
    private final Bootstrap bootstrap;
    private Environment environment = Environments.SE;
    private Map<String, Object> sessionStore;

    public TestContainer(BeansXml beansXml, Collection<Class<?>> classes) {
        this((Deployment)new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(beansXml, classes, (Environment)Environments.SE), (Environment)Environments.SE, new Extension[0]));
    }

    public TestContainer(Collection<URL> beansXml, Collection<Class<?>> classes) {
        this.bootstrap = new WeldBootstrap();
        this.deployment = new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(this.bootstrap.parse(beansXml), classes, (Environment)Environments.SE), (Environment)Environments.SE, new Extension[0]);
    }

    public TestContainer(String beanArchiveId, BeansXml beansXml, Collection<Class<?>> classes) {
        this(beanArchiveId, beansXml, classes, (Environment)Environments.SE, false);
    }

    public TestContainer(String beanArchiveId, BeansXml beansXml, Collection<Class<?>> classes, Environment environment, boolean merge) {
        this.bootstrap = new WeldBootstrap();
        this.deployment = new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(beanArchiveId, beansXml, classes, environment), environment, new Extension[0]);
    }

    public TestContainer(BeansXml beansXml, Class<?> ... classes) {
        this((Deployment)new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(beansXml, Arrays.asList(classes), (Environment)Environments.SE), (Environment)Environments.SE, new Extension[0]));
    }

    public TestContainer(Class<?> ... classes) {
        this((Deployment)new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(Arrays.asList(classes), (Environment)Environments.SE), (Environment)Environments.SE, new Extension[0]));
    }

    public TestContainer(Deployment deployment) {
        this.bootstrap = new WeldBootstrap();
        this.deployment = deployment;
    }

    public TestContainer ensureRequestActive() {
        RequestContext requestContext = (RequestContext)this.instance().select(RequestContext.class, new Annotation[]{UnboundLiteral.INSTANCE}).get();
        requestContext.activate();
        BoundSessionContext sessionContext = (BoundSessionContext)this.instance().select(BoundSessionContext.class, new Annotation[0]).get();
        sessionContext.associate(this.sessionStore);
        sessionContext.activate();
        return this;
    }

    public TestContainer startContainer() {
        return this.startContainer((Environment)Environments.SE);
    }

    public TestContainer startContainer(Environment environment) {
        this.sessionStore = new HashMap<String, Object>();
        this.environment = environment;
        this.bootstrap.startContainer(environment, this.deployment).startInitialization().deployBeans().validateBeans().endInitialization();
        if (environment.equals(Environments.SE)) {
            for (BeanDeploymentArchive beanDeploymentArchive : this.deployment.getBeanDeploymentArchives()) {
                this.bootstrap.getManager(beanDeploymentArchive).fireEvent(new Object(), new Annotation[]{InitializedLiteral.APPLICATION});
            }
        }
        return this;
    }

    public WeldManager getBeanManager(BeanDeploymentArchive beanDeploymentArchive) {
        return this.bootstrap.getManager(beanDeploymentArchive);
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public TestContainer stopContainer() {
        BoundSessionContext sessionContext;
        RequestContext requestContext = (RequestContext)this.instance().select(RequestContext.class, new Annotation[]{UnboundLiteral.INSTANCE}).get();
        if (requestContext.isActive()) {
            requestContext.invalidate();
            requestContext.deactivate();
        }
        if ((sessionContext = (BoundSessionContext)this.instance().select(BoundSessionContext.class, new Annotation[0]).get()).isActive()) {
            sessionContext.invalidate();
            sessionContext.deactivate();
            sessionContext.dissociate(this.sessionStore);
        }
        if (this.environment.equals(Environments.SE)) {
            for (BeanDeploymentArchive beanDeploymentArchive : this.deployment.getBeanDeploymentArchives()) {
                this.bootstrap.getManager(beanDeploymentArchive).fireEvent(new Object(), new Annotation[]{DestroyedLiteral.APPLICATION});
            }
        }
        this.bootstrap.shutdown();
        return this;
    }

    public Instance<Context> instance() {
        return Container.instance().deploymentManager().instance().select(Context.class, new Annotation[0]);
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public Map<String, Object> getSessionStore() {
        return this.sessionStore;
    }

    public static class Runner {
        private static Runnable NO_OP = new Runnable(){

            @Override
            public void run(WeldManager beanManager) {
            }
        };
        private final List<URL> beansXml;
        private final List<Class<?>> classes;

        public Runner(List<URL> beansXml, List<Class<?>> classes) {
            this.beansXml = beansXml;
            this.classes = classes;
        }

        public void run() throws Exception {
            this.run(NO_OP);
        }

        public void run(Runnable runnable) throws Exception {
            TestContainer container = null;
            try {
                container = new TestContainer(this.beansXml, this.classes);
                container.startContainer().ensureRequestActive();
                runnable.run(container.getBeanManager((BeanDeploymentArchive)container.getDeployment().getBeanDeploymentArchives().iterator().next()));
            }
            finally {
                if (container != null) {
                    container.stopContainer();
                }
            }
        }

        public void runAndExpect(Exception expected) {
            this.runAndExpect(NO_OP, expected);
        }

        public void runAndExpect(Runnable runnable, Exception expected) {
            block4: {
                try {
                    this.run();
                }
                catch (Exception e) {
                    if (!expected.getClass().isAssignableFrom(e.getClass())) {
                        AssertionError t = new AssertionError((Object)("Expected exception " + expected + " but got " + e));
                        ((Throwable)((Object)t)).initCause(e);
                        throw t;
                    }
                    if (expected.getMessage() == null) {
                        return;
                    }
                    String errorCode = expected.getMessage().substring(0, 11);
                    if (!e.getMessage().startsWith(errorCode)) break block4;
                    return;
                }
            }
            throw new AssertionError((Object)("Expected exception " + expected + " but none was thrown"));
        }

        public static interface Runnable {
            public void run(WeldManager var1);
        }
    }
}

