/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded;

import jakarta.decorator.Decorator;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Model;
import jakarta.enterprise.inject.Stereotype;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.interceptor.Interceptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.metadata.FilterPredicate;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableSet;

final class Utils {
    private static final String BEANS_XML_REGEX = ".*/beans\\.xml";
    private static final List<Class<? extends Annotation>> META_ANNOTATIONS = ImmutableList.of((Object[])new Class[]{Stereotype.class, NormalScope.class});
    private static final Set<Class<? extends Annotation>> BEAN_DEFINING_ANNOTATIONS = ImmutableSet.of((Object[])new Class[]{Dependent.class, RequestScoped.class, ConversationScoped.class, SessionScoped.class, ApplicationScoped.class, Interceptor.class, Decorator.class, Model.class, NormalScope.class, Stereotype.class});
    private static final Set<Class<? extends Annotation>> BEAN_DEFINING_ANNOTATIONS_WITH_EE_ANNOTATIONS = ImmutableSet.of((Object[])new Class[]{Dependent.class, RequestScoped.class, ConversationScoped.class, SessionScoped.class, ApplicationScoped.class, Interceptor.class, Decorator.class, Model.class, NormalScope.class, Stereotype.class, Singleton.class, Stateful.class, Stateless.class});

    private Utils() {
    }

    static <T> T getBeanReference(BeanManager manager, Class<T> type) {
        Bean bean = manager.resolve(manager.getBeans(type, new Annotation[0]));
        return (T)manager.getReference(bean, type, manager.createCreationalContext(null));
    }

    public static String findArchiveId(Archive<?> archive) {
        return archive.getName();
    }

    public static Collection<URL> findBeansXml(Archive<?> archive) {
        Validate.notNull(archive, (String)"Archive must be specified");
        ArrayList<URL> beansXmls = new ArrayList<URL>();
        Map nestedArchives = archive.getContent(Filters.include((String)".*\\.jar|.*\\.war"));
        for (Map.Entry nestedArchiveEntry : nestedArchives.entrySet()) {
            if (!(((Node)nestedArchiveEntry.getValue()).getAsset() instanceof ArchiveAsset)) continue;
            ArchiveAsset nestedArchive = (ArchiveAsset)((Node)nestedArchiveEntry.getValue()).getAsset();
            Map classes = nestedArchive.getArchive().getContent(Filters.include((String)BEANS_XML_REGEX));
            for (final Map.Entry entry : classes.entrySet()) {
                try {
                    beansXmls.add(new URL(null, "archive://" + nestedArchive.getArchive().getName() + ((ArchivePath)entry.getKey()).get(), new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            return new URLConnection(u){

                                @Override
                                public void connect() throws IOException {
                                }

                                @Override
                                public InputStream getInputStream() throws IOException {
                                    return ((Node)entry.getValue()).getAsset().openStream();
                                }
                            };
                        }
                    }));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Map classes = archive.getContent(Filters.include((String)BEANS_XML_REGEX));
        for (final Map.Entry entry : classes.entrySet()) {
            try {
                beansXmls.add(new URL(null, "archive://" + ((ArchivePath)entry.getKey()).get(), new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return ((Node)entry.getValue()).getAsset().openStream();
                            }
                        };
                    }
                }));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return beansXmls;
    }

    public static Collection<Class<?>> findBeanClasses(Archive<?> archive, ClassLoader classLoader, BeansXml beansXml, ResourceLoader resourceLoader, Environment environment) {
        Validate.notNull(archive, (String)"Archive must be specified");
        ArrayList beanClasses = new ArrayList();
        try {
            Map nestedArchives = archive.getContent(Filters.include((String)".*\\.jar|.*\\.war|.*\\.rar"));
            for (Map.Entry nestedArchiveEntry : nestedArchives.entrySet()) {
                ArchiveAsset nestedArchive;
                Map markerFiles;
                if (!(((Node)nestedArchiveEntry.getValue()).getAsset() instanceof ArchiveAsset) || (markerFiles = (nestedArchive = (ArchiveAsset)((Node)nestedArchiveEntry.getValue()).getAsset()).getArchive().getContent(Filters.include((String)BEANS_XML_REGEX))).isEmpty()) continue;
                beanClasses.addAll(Utils.filterClasses(nestedArchive.getArchive(), classLoader, beansXml, resourceLoader, environment));
            }
            Map markerFiles = archive.getContent(Filters.include((String)BEANS_XML_REGEX));
            if (!markerFiles.isEmpty()) {
                beanClasses.addAll(Utils.filterClasses(archive, classLoader, beansXml, resourceLoader, environment));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class from archive " + archive.getName(), e);
        }
        return beanClasses;
    }

    public static String findClassName(ArchivePath path) {
        String className = path.get();
        if ((className = className.replaceAll("/WEB-INF/classes/", "").replaceAll("/META-INF/versions/\\d*/", "")).charAt(0) == '/') {
            className = className.substring(1);
        }
        className = className.replaceAll("\\.class", "");
        className = className.replaceAll("/", ".");
        return className;
    }

    private static Collection<Class<?>> filterClasses(Archive<?> archive, ClassLoader classLoader, BeansXml beansXml, ResourceLoader resourceLoader, Environment environment) throws ClassNotFoundException {
        ArrayList beanClasses = new ArrayList();
        Map classes = archive.getContent(Filters.include((String)".*\\.class"));
        BeanDiscoveryMode discoveryMode = beansXml.getBeanDiscoveryMode();
        for (Map.Entry classEntry : classes.entrySet()) {
            if (beansXml.getScanning().getExcludes().isEmpty()) {
                Class<?> loadedClass = classLoader.loadClass(Utils.findClassName((ArchivePath)classEntry.getKey()));
                Utils.addBeanClassIfNeeded(loadedClass, beanClasses, discoveryMode, environment);
                continue;
            }
            boolean isExcluded = false;
            for (Metadata filterMetadata : beansXml.getScanning().getExcludes()) {
                FilterPredicate excludePredicate = new FilterPredicate(filterMetadata, resourceLoader);
                if (!excludePredicate.test(Utils.findClassName((ArchivePath)classEntry.getKey()))) continue;
                isExcluded = true;
                break;
            }
            if (isExcluded) continue;
            Class<?> loadedClass = classLoader.loadClass(Utils.findClassName((ArchivePath)classEntry.getKey()));
            Utils.addBeanClassIfNeeded(loadedClass, beanClasses, discoveryMode, environment);
        }
        return beanClasses;
    }

    private static void addBeanClassIfNeeded(Class<?> potentialBeanClass, List<Class<?>> knownBeanClasses, BeanDiscoveryMode mode, Environment environment) {
        if (mode.equals((Object)BeanDiscoveryMode.ANNOTATED)) {
            Set<Class<? extends Annotation>> completeSetOfBeanDefiningAnnotations = environment != null && (environment.equals(Environments.EE_INJECT) || environment.equals(Environments.EE)) ? BEAN_DEFINING_ANNOTATIONS_WITH_EE_ANNOTATIONS : BEAN_DEFINING_ANNOTATIONS;
            if (Utils.hasBeanDefiningAnnotation(potentialBeanClass, completeSetOfBeanDefiningAnnotations)) {
                knownBeanClasses.add(potentialBeanClass);
            }
        } else {
            knownBeanClasses.add(potentialBeanClass);
        }
    }

    private static boolean hasBeanDefiningAnnotation(Class<?> clazz, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        for (Class<? extends Annotation> beanDefiningAnnotation : initialBeanDefiningAnnotations) {
            if (clazz.getDeclaredAnnotation(beanDefiningAnnotation) == null) continue;
            return true;
        }
        for (Class<? extends Annotation> metaAnnotation : META_ANNOTATIONS) {
            if (!Utils.hasBeanDefiningMetaAnnotationSpecified(clazz.getAnnotations(), metaAnnotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasBeanDefiningMetaAnnotationSpecified(Annotation[] annotations, Class<? extends Annotation> metaAnnotationType) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getDeclaredAnnotation(metaAnnotationType) == null) continue;
            return true;
        }
        return false;
    }
}

