/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene;

import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.LocationEnricher;
import org.jboss.arquillian.graphene.enricher.PageFragmentEnricher;
import org.jboss.arquillian.graphene.guard.RequestGuardFactory;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.request.RequestGuard;
import org.jboss.arquillian.graphene.request.RequestType;
import org.jboss.arquillian.graphene.wait.WebDriverWait;
import org.jboss.arquillian.graphene.wait.WebDriverWaitImpl;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GrapheneUtilityImpl
implements Graphene.Utility {
    GrapheneUtilityImpl() {
    }

    public <T> T guardHttp(T target) {
        return this.getRequestGuardFactoryFor(target).guard(target, RequestType.HTTP, true);
    }

    public <T> T guardNoRequest(T target) {
        return this.getRequestGuardFactoryFor(target).guard(target, RequestType.NONE, true);
    }

    public <T> T guardAjax(T target) {
        return this.getRequestGuardFactoryFor(target).guard(target, RequestType.XHR, true);
    }

    public <T> T waitForHttp(T target) {
        return this.getRequestGuardFactoryFor(target).guard(target, RequestType.HTTP, false);
    }

    public WebDriverWait<Void> waitAjax() {
        return this.waitAjax(this.context().getWebDriver(new Class[0]));
    }

    public WebDriverWait<Void> waitAjax(WebDriver driver) {
        return new WebDriverWaitImpl<Object>(null, driver, ((GrapheneProxyInstance)driver).getContext().getConfiguration().getWaitAjaxInterval());
    }

    public WebDriverWait<Void> waitGui() {
        return this.waitGui(this.context().getWebDriver(new Class[0]));
    }

    public WebDriverWait<Void> waitGui(WebDriver driver) {
        return new WebDriverWaitImpl<Object>(null, driver, ((GrapheneProxyInstance)driver).getContext().getConfiguration().getWaitGuiInterval());
    }

    public WebDriverWait<Void> waitModel() {
        return this.waitModel(this.context().getWebDriver(new Class[0]));
    }

    public WebDriverWait<Void> waitModel(WebDriver driver) {
        return new WebDriverWaitImpl<Object>(null, driver, ((GrapheneProxyInstance)driver).getContext().getConfiguration().getWaitModelInterval());
    }

    public <T> T createPageFragment(Class<T> clazz, WebElement root) {
        return PageFragmentEnricher.createPageFragment(clazz, root);
    }

    public <T> T goTo(Class<T> clazz) {
        return this.goTo(clazz, Default.class);
    }

    public <T> T goTo(Class<T> pageObject, Class<?> browserQualifier) {
        LocationEnricher locationEnricher = new LocationEnricher();
        return locationEnricher.goTo(pageObject, browserQualifier);
    }

    private RequestGuardFactory getRequestGuardFactoryFor(Object target) {
        GrapheneContext context = GrapheneProxy.isProxyInstance(target) ? ((GrapheneProxyInstance)target).getContext() : this.context();
        return new RequestGuardFactory(JSInterfaceFactory.create(context, RequestGuard.class), JSInterfaceFactory.create(context, Document.class), context);
    }

    private GrapheneContext context() {
        GrapheneContext context = GrapheneContext.lastContext();
        if (context == null) {
            throw new IllegalStateException("The last used Graphene context is not available.");
        }
        return context;
    }
}

