/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.WebElementUtils;
import org.jboss.arquillian.graphene.findby.FindByUtilities;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebElementEnricher
extends AbstractSearchContextEnricher {
    @Inject
    private Instance<GrapheneConfiguration> configuration;

    public WebElementEnricher() {
    }

    public WebElementEnricher(Instance<GrapheneConfiguration> configuration) {
        this.configuration = configuration;
    }

    public void enrich(SearchContext searchContext, Object target) {
        try {
            List<Field> fields = FindByUtilities.getListOfFieldsAnnotatedWithFindBys(target);
            for (Field field : fields) {
                SearchContext localSearchContext;
                GrapheneContext grapheneContext;
                GrapheneContext grapheneContext2 = grapheneContext = searchContext == null ? null : ((GrapheneProxyInstance)searchContext).getContext();
                if (grapheneContext == null) {
                    grapheneContext = GrapheneContext.getContextFor(ReflectionHelper.getQualifier(field.getAnnotations()));
                    localSearchContext = grapheneContext.getWebDriver(new Class[]{SearchContext.class});
                } else {
                    localSearchContext = searchContext;
                }
                By by = FindByUtilities.getCorrectBy(field, ((GrapheneConfiguration)this.configuration.get()).getDefaultElementLocatingStrategy());
                if (field.getType().isAssignableFrom(WebElement.class)) {
                    WebElement element = WebElementUtils.findElementLazily(by, localSearchContext);
                    WebElementEnricher.setValue(field, target, element);
                    continue;
                }
                if (!field.getType().isAssignableFrom(List.class) || !this.getListType(field).isAssignableFrom(WebElement.class)) continue;
                List<WebElement> elements = WebElementUtils.findElementsLazily(by, localSearchContext);
                WebElementEnricher.setValue(field, target, elements);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int getPrecedence() {
        return 1;
    }
}

