/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import com.google.common.io.Resources;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.context.ExtendedGrapheneContext;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.javascript.ExecutionResolver;
import org.jboss.arquillian.graphene.javascript.JSCall;
import org.jboss.arquillian.graphene.javascript.JSInterface;
import org.jboss.arquillian.graphene.javascript.JSInterfaceHandler;
import org.jboss.arquillian.graphene.javascript.JavaScriptUtils;
import org.jboss.arquillian.graphene.page.extension.JavaScriptPageExtension;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.openqa.selenium.JavascriptExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecutionResolver
implements ExecutionResolver {
    public static final String FUNCTION;
    public static final String CALL = "return invokeInterface({0}, \"{1}\", arguments);";
    protected static final Logger LOGGER;

    public Object execute(GrapheneContext context, JSCall call) {
        ExtendedGrapheneContext c = (ExtendedGrapheneContext)context;
        JSInterface target = call.getTarget();
        if (target.getName() == null) {
            throw new IllegalStateException("Can't use " + this.getClass() + " for " + target.getInterface() + ", because the @JavaScript annotation doesn't define non empty value()");
        }
        this.registerExtension(c.getPageExtensionRegistry(), target);
        long LIMIT = context.getConfiguration().getJavascriptInstallationLimit();
        for (long i = 1L; i <= 5L; ++i) {
            try {
                Object returnValue = this.executeScriptForCall((JavascriptExecutor)context.getWebDriver(new Class[]{JavascriptExecutor.class}), call);
                Object castedResult = this.castResult(call, returnValue);
                return castedResult;
            }
            catch (RuntimeException e) {
                if (i == LIMIT) {
                    throw new IllegalStateException("Can't invoke the javacript " + call.getTarget().getInterface().getName() + "#" + call.getMethod().getMethod().getName() + "()", e);
                }
                try {
                    c.getPageExtensionInstallatorProvider().installator(target.getName()).install();
                }
                catch (RuntimeException ignored) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new IllegalStateException("Can't invoke the javacript " + call.getTarget().getInterface().getName() + "#" + call.getMethod().getMethod().getName() + "()");
    }

    protected Object[] castArguments(Object[] arguments) {
        Object[] result = new Object[arguments.length];
        System.arraycopy(arguments, 0, result, 0, arguments.length);
        for (int i = 0; i < result.length; ++i) {
            Object arg = result[i];
            if (arg == null || !arg.getClass().isEnum()) continue;
            result[i] = this.castEnumToString(arg);
        }
        return result;
    }

    protected Object castResult(JSCall call, Object returnValue) {
        Class<?> returnType = call.getMethod().getMethod().getReturnType();
        if (returnType.isEnum()) {
            return this.castStringToEnum(returnType, returnValue);
        }
        return returnValue;
    }

    protected Object castEnumToString(Object enumValue) {
        return enumValue.toString();
    }

    protected Object castStringToEnum(Class<?> returnType, Object returnValue) {
        try {
            Method method = returnType.getMethod("valueOf", String.class);
            return method.invoke(null, returnValue.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException("returnValue '" + returnValue + "' can't be cast to enum value", e);
        }
    }

    protected Object executeScriptForCall(JavascriptExecutor executor, JSCall call) {
        Object[] arguments;
        String script = this.resolveScriptToExecute(call);
        Object returnValue = JavaScriptUtils.execute(executor, script, arguments = this.castArguments(call.getArguments()));
        if (returnValue instanceof String && ((String)returnValue).startsWith("GRAPHENE ERROR: ")) {
            throw new IllegalStateException("exception thrown when executing method '" + call.getMethod().getName() + "': " + ((String)returnValue).substring(16));
        }
        return returnValue;
    }

    protected String resolveScriptToExecute(JSCall call) {
        String functionCall = MessageFormat.format(CALL, call.getTarget().getName(), call.getMethod().getName());
        String functionDefinitionWithCall = FUNCTION + functionCall;
        return functionDefinitionWithCall;
    }

    protected <T> void registerExtension(PageExtensionRegistry registry, JSInterface target) {
        if (target.getName() == null || target.getName().length() == 0) {
            throw new IllegalArgumentException("The extension " + target.getInterface() + "has no mapping.");
        }
        if (registry.getExtension(target.getName()) != null) {
            return;
        }
        JavaScriptPageExtension extension = new JavaScriptPageExtension(target.getInterface());
        registry.register(extension);
        for (JSInterface dependency : target.getJSInterfaceDependencies()) {
            this.registerExtension(registry, dependency);
        }
    }

    static {
        LOGGER = Logger.getLogger(DefaultExecutionResolver.class.getName());
        try {
            URL resource = JSInterfaceHandler.class.getResource("call.js");
            FUNCTION = Resources.toString((URL)resource, (Charset)Charset.defaultCharset());
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }
}

