/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spock.container;

import java.lang.reflect.Method;
import org.jboss.arquillian.spock.ArquillianSputnik;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.spockframework.runtime.Sputnik;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;

final class SpockSpecificationFilter
extends Filter {
    private static final MethodInfo NOT_FOUND = new MethodInfo();
    private final Sputnik spockRunner;
    private final String methodName;
    private final SpecInfo currentSpec;

    SpockSpecificationFilter(Sputnik spockRunner, String methodName) {
        this.spockRunner = spockRunner;
        this.methodName = methodName;
        this.currentSpec = this.obtainCurrentSpecification();
    }

    public boolean shouldRun(Description description) {
        MethodInfo featureMethod = this.findCorrespondingFeatureMethod(description.getMethodName());
        if (NOT_FOUND.equals(featureMethod)) {
            return false;
        }
        return this.methodName.equals(((Method)featureMethod.getReflection()).getName());
    }

    public String describe() {
        return "Filter Feature methods for Spock Framework";
    }

    private SpecInfo obtainCurrentSpecification() {
        try {
            Method method = ArquillianSputnik.class.getDeclaredMethod("getSpec", new Class[0]);
            method.setAccessible(true);
            return (SpecInfo)method.invoke((Object)this.spockRunner, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not obtain SpecInfo from Sputnik Runner", e);
        }
    }

    private MethodInfo findCorrespondingFeatureMethod(String featureMethodName) {
        MethodInfo methodInfo = NOT_FOUND;
        for (FeatureInfo feature : this.currentSpec.getAllFeatures()) {
            MethodInfo featureMethod = feature.getFeatureMethod();
            if (!featureMethodName.equals(featureMethod.getName())) continue;
            methodInfo = featureMethod;
            break;
        }
        return methodInfo;
    }
}

