/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spock.container;

import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.spock.ArquillianSputnik;
import org.jboss.arquillian.spock.container.SpockSpecificationFilter;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.spockframework.runtime.Sputnik;

public class SpockTestRunner
implements TestRunner {
    protected List<RunListener> getRunListeners() {
        return Collections.emptyList();
    }

    public TestResult execute(Class<?> testClass, String methodName) {
        Result testResult = new Result();
        try {
            ArquillianSputnik spockRunner = new ArquillianSputnik(testClass, true);
            spockRunner.filter((Filter)new SpockSpecificationFilter((Sputnik)spockRunner, methodName));
            this.runTest((Sputnik)spockRunner, testResult);
        }
        catch (Exception e) {
            return TestResult.failed((Throwable)e);
        }
        return this.convertToTestResult(testResult);
    }

    public void runTest(Sputnik spockRunner, Result testResult) {
        RunNotifier notifier = new RunNotifier();
        notifier.addFirstListener(testResult.createListener());
        for (RunListener listener : this.getRunListeners()) {
            notifier.addListener(listener);
        }
        spockRunner.run(notifier);
    }

    private TestResult convertToTestResult(Result result) {
        TestResult newResult = TestResult.passed();
        Throwable throwable = null;
        if (result.getFailureCount() > 0) {
            throwable = ((Failure)result.getFailures().get(0)).getException();
            newResult = TestResult.failed((Throwable)throwable);
        }
        if (result.getIgnoreCount() > 0) {
            newResult = TestResult.skipped(throwable);
        }
        return newResult;
    }
}

