/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.cdi;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.testenricher.cdi.MethodParameterInjectionPoint;
import org.jboss.arquillian.testenricher.cdi.SecurityActions;

public class CDIInjectionEnricher
implements TestEnricher {
    private static final String ANNOTATION_NAME = "javax.inject.Inject";
    private static final Logger log = Logger.getLogger(CDIInjectionEnricher.class.getName());
    @Inject
    private Instance<BeanManager> beanManagerInst;

    public BeanManager getBeanManager() {
        return (BeanManager)this.beanManagerInst.get();
    }

    public void enrich(Object testCase) {
        if (SecurityActions.isClassPresent(ANNOTATION_NAME)) {
            this.injectClass(testCase);
        }
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        if (SecurityActions.isClassPresent(ANNOTATION_NAME)) {
            BeanManager beanManager = this.getBeanManager();
            if (beanManager == null) {
                return values;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                try {
                    values[i] = this.getInstanceByType(beanManager, i, method);
                    continue;
                }
                catch (Exception e) {
                    log.info("CDIEnricher tried to lookup method parameter of type " + parameterTypes[i] + " but caught exception: " + e.getMessage());
                }
            }
        }
        return values;
    }

    private <T> T getInstanceByType(BeanManager manager, int position, Method method) {
        CreationalContext cc = manager.createCreationalContext(null);
        return (T)manager.getInjectableReference(new MethodParameterInjectionPoint(method, position, manager), cc);
    }

    protected void injectClass(Object testCase) {
        try {
            BeanManager beanManager = this.getBeanManager();
            if (beanManager != null) {
                this.injectNonContextualInstance(beanManager, testCase);
            } else {
                log.info("BeanManager cannot be located in context Either you are using an archive with no beans.xml, or the BeanManager has not been produced.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject members", e);
        }
    }

    protected void injectNonContextualInstance(BeanManager manager, Object instance) {
        CreationalContext creationalContext = manager.createCreationalContext(null);
        InjectionTarget injectionTarget = manager.createInjectionTarget(manager.createAnnotatedType(instance.getClass()));
        injectionTarget.inject(instance, creationalContext);
    }
}

