/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.jboss.as.controller.ModelController;
import org.jboss.as.jmx.BaseMBeanServerPlugin;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.as.jmx.model.ConfiguredDomains;
import org.jboss.as.jmx.model.ModelControllerMBeanHelper;
import org.jboss.as.jmx.model.SecurityActions;
import org.jboss.as.jmx.model.TypeConverters;

public class ModelControllerMBeanServerPlugin
extends BaseMBeanServerPlugin {
    private final ConfiguredDomains configuredDomains;
    private final ModelControllerMBeanHelper legacyHelper;
    private final ModelControllerMBeanHelper exprHelper;

    public ModelControllerMBeanServerPlugin(ConfiguredDomains configuredDomains, ModelController controller, boolean legacyWithProperPropertyFormat) {
        assert (configuredDomains != null);
        this.configuredDomains = configuredDomains;
        this.legacyHelper = configuredDomains.getLegacyDomain() != null ? new ModelControllerMBeanHelper(TypeConverters.createLegacyTypeConverters(legacyWithProperPropertyFormat), configuredDomains, configuredDomains.getLegacyDomain(), controller) : null;
        this.exprHelper = configuredDomains.getExprDomain() != null ? new ModelControllerMBeanHelper(TypeConverters.createExpressionTypeConverters(), configuredDomains, configuredDomains.getExprDomain(), controller) : null;
    }

    public boolean accepts(ObjectName objectName) {
        String domain = objectName.getDomain();
        if (!objectName.isDomainPattern()) {
            return domain.equals(this.configuredDomains.getLegacyDomain()) || domain.equals(this.configuredDomains.getExprDomain());
        }
        Pattern p = Pattern.compile(objectName.getDomain().replace("*", ".*"));
        return p.matcher(this.configuredDomains.getLegacyDomain()).matches() || p.matcher(this.configuredDomains.getExprDomain()).matches();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.getHelper(name).getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.getHelper(name).getAttributes(name, attributes);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        if (this.getHelper(loaderName).resolvePathAddress(loaderName) != null) {
            return SecurityActions.getClassLoader(this.getClass());
        }
        throw ModelControllerMBeanHelper.createInstanceNotFoundException(loaderName);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        if (this.getHelper(mbeanName).resolvePathAddress(mbeanName) != null) {
            return SecurityActions.getClassLoader(this.getClass());
        }
        throw ModelControllerMBeanHelper.createInstanceNotFoundException(mbeanName);
    }

    public String[] getDomains() {
        return this.configuredDomains.getDomains();
    }

    public Integer getMBeanCount() {
        int count = 0;
        if (this.legacyHelper != null) {
            count += this.legacyHelper.getMBeanCount();
        }
        if (this.exprHelper != null) {
            count += this.exprHelper.getMBeanCount();
        }
        return count;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.getHelper(name).getMBeanInfo(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.getHelper(name).getObjectInstance(name);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.getHelper(name).invoke(name, operationName, params, signature);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return false;
    }

    public boolean isRegistered(ObjectName name) {
        return this.getHelper(name).resolvePathAddress(name) != null;
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        if (name != null && !name.isDomainPattern()) {
            return this.getHelper(name).queryMBeans(name, query);
        }
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        if (this.legacyHelper != null) {
            instances.addAll(this.legacyHelper.queryMBeans(name, query));
        }
        if (this.exprHelper != null) {
            instances.addAll(this.exprHelper.queryMBeans(name, query));
        }
        return instances;
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        if (name != null && !name.isDomainPattern()) {
            return this.getHelper(name).queryNames(name, query);
        }
        HashSet<ObjectName> instances = new HashSet<ObjectName>();
        if (this.legacyHelper != null) {
            instances.addAll(this.legacyHelper.queryNames(name, query));
        }
        if (this.exprHelper != null) {
            instances.addAll(this.exprHelper.queryNames(name, query));
        }
        return instances;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.getHelper(name).setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.getHelper(name).setAttributes(name, attributes);
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
    }

    private ModelControllerMBeanHelper getHelper(ObjectName name) {
        String domain = name.getDomain();
        if (domain.equals(this.configuredDomains.getLegacyDomain()) || name.isDomainPattern()) {
            return this.legacyHelper;
        }
        if (domain.equals(this.configuredDomains.getExprDomain())) {
            return this.exprHelper;
        }
        throw JmxMessages.MESSAGES.unknownDomain(domain);
    }
}

