/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.ExecutorService;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelFactory;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.sasl.JBossSaslProvider;
import org.xnio.IoUtils;

public abstract class ManagementClientChannelStrategy {
    public abstract ManagementChannel getChannel() throws IOException;

    public abstract void requestDone();

    public static synchronized ManagementClientChannelStrategy create(ManagementChannel channel) {
        return new Existing(channel);
    }

    public static ManagementClientChannelStrategy create(String hostName, int port, ExecutorService executorService, ManagementOperationHandler handler, CallbackHandler cbHandler) throws URISyntaxException, IOException {
        return new EstablishingWithNewEndpoint(hostName, port, executorService, handler, cbHandler);
    }

    public static ManagementClientChannelStrategy create(String hostName, int port, Endpoint endpoint, ManagementOperationHandler handler, CallbackHandler cbHandler) throws URISyntaxException, IOException {
        return new EstablishingWithExistingEndpoint(hostName, port, endpoint, handler, cbHandler);
    }

    private static class EstablishingWithExistingEndpoint
    extends Establishing {
        private final Endpoint endpoint;

        public EstablishingWithExistingEndpoint(String hostName, int port, Endpoint endpoint, ManagementOperationHandler handler, CallbackHandler cbHandler) {
            super(hostName, port, handler, cbHandler);
            this.endpoint = endpoint;
        }

        @Override
        void addConfigurationProperties(ProtocolChannelClient.Configuration<ManagementChannel> configuration) {
            configuration.setEndpoint(this.endpoint);
        }
    }

    private static class EstablishingWithNewEndpoint
    extends Establishing {
        private final ExecutorService executorService;

        public EstablishingWithNewEndpoint(String hostName, int port, ExecutorService executorService, ManagementOperationHandler handler, CallbackHandler cbHandler) {
            super(hostName, port, handler, cbHandler);
            this.executorService = executorService;
        }

        @Override
        void addConfigurationProperties(ProtocolChannelClient.Configuration<ManagementChannel> configuration) {
            configuration.setUriScheme("remote");
            configuration.setEndpointName("endpoint");
            configuration.setExecutor(this.executorService);
        }
    }

    private static abstract class Establishing
    extends ManagementClientChannelStrategy {
        private static final String CONNECT_TIME_OUT_PROPERTY = "org.jboss.as.client.connect.timeout";
        private static final Provider saslProvider = new JBossSaslProvider();
        private final String hostName;
        private final int port;
        private final ManagementOperationHandler handler;
        private volatile ProtocolChannelClient<ManagementChannel> client;
        private volatile ManagementChannel channel;
        private final CallbackHandler callbackHandler;

        public Establishing(String hostName, int port, ManagementOperationHandler handler, CallbackHandler callbackHandler) {
            this.hostName = hostName;
            this.port = port;
            this.handler = handler;
            this.callbackHandler = callbackHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ManagementChannel getChannel() throws IOException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (Security.getProvider(saslProvider.getName()) == null) {
                        Security.insertProviderAt(saslProvider, 1);
                    }
                    return null;
                }
            });
            ProtocolChannelClient.Configuration<ManagementChannel> configuration = new ProtocolChannelClient.Configuration<ManagementChannel>();
            try {
                this.addConfigurationProperties(configuration);
                configuration.setUri(new URI("remote://" + this.hostName + ":" + this.port));
                configuration.setChannelFactory(new ManagementChannelFactory());
                configuration.setConnectTimeoutProperty(CONNECT_TIME_OUT_PROPERTY);
                this.client = ProtocolChannelClient.create(configuration);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            boolean ok = false;
            try {
                try {
                    this.client.connect(this.callbackHandler);
                }
                catch (ConnectException e) {
                    throw new ConnectException("Could not connect to " + configuration.getUri() + " in " + configuration.getConnectTimeout() + "ms. " + "Make sure the server is running and/or consider setting a longer timeout by setting -D" + CONNECT_TIME_OUT_PROPERTY + "=<timeout in ms>.");
                }
                this.channel = this.client.openChannel("management");
                this.channel.setOperationHandler(this.handler);
                this.channel.startReceiving();
                ok = true;
            }
            finally {
                if (!ok) {
                    IoUtils.safeClose((Closeable)((Object)this.channel));
                    IoUtils.safeClose(this.client);
                }
            }
            return this.channel;
        }

        @Override
        public void requestDone() {
            IoUtils.safeClose(this.client);
        }

        abstract void addConfigurationProperties(ProtocolChannelClient.Configuration<ManagementChannel> var1);
    }

    private static class Existing
    extends ManagementClientChannelStrategy {
        private final ManagementChannel channel;

        Existing(ManagementChannel channel) {
            this.channel = channel;
        }

        @Override
        public ManagementChannel getChannel() throws IOException {
            return this.channel;
        }

        @Override
        public void requestDone() {
        }
    }
}

