/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security;

import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.RealmBase;
import org.jboss.as.web.security.JBossGenericPrincipal;
import org.jboss.as.web.security.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.CacheableManager;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingType;

public class JBossWebRealm
extends RealmBase {
    private static Logger log = Logger.getLogger(JBossWebRealm.class);
    protected static final String name = "JBossWebRealm";
    protected AuthenticationManager authenticationManager = null;
    protected AuthorizationManager authorizationManager = null;
    protected MappingManager mappingManager = null;
    protected CertificatePrincipal certMapping = new SubjectDNMapping();
    protected Map<String, Set<String>> principalVersusRolesMap;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    public void setMappingManager(MappingManager mappingManager) {
        this.mappingManager = mappingManager;
    }

    public Principal authenticate(String username, String credentials) {
        Subject subject;
        if (username == null && credentials == null) {
            return null;
        }
        if (this.authenticationManager == null) {
            throw new IllegalStateException("Authentication Manager has not been set");
        }
        if (this.authorizationManager == null) {
            throw new IllegalStateException("Authorization Manager has not been set");
        }
        Principal userPrincipal = this.getPrincipal(username);
        boolean isValid = this.authenticationManager.isValid(userPrincipal, (Object)credentials, subject = new Subject());
        if (isValid) {
            MappingContext mc;
            if (log.isTraceEnabled()) {
                log.trace((Object)("User: " + userPrincipal + " is authenticated"));
            }
            SecurityContext sc = SecurityActions.createSecurityContext(this.authenticationManager.getSecurityDomain());
            userPrincipal = this.getPrincipal(subject);
            sc.getUtil().createSubjectInfo(userPrincipal, (Object)credentials, subject);
            SecurityActions.setSecurityContextOnAssociation(sc);
            SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(sc);
            if (this.mappingManager != null && (mc = this.mappingManager.getMappingContext(MappingType.ROLE.name())) != null && mc.hasModules()) {
                SecurityRolesAssociation.setSecurityRoles(this.principalVersusRolesMap);
            }
            RoleGroup roles = this.authorizationManager.getSubjectRoles(subject, (CallbackHandler)scb);
            List rolesAsList = roles.getRoles();
            List<String> rolesAsStringList = new ArrayList<String>();
            for (Role role : rolesAsList) {
                rolesAsStringList.add(role.getRoleName());
            }
            if (this.mappingManager != null) {
                MappingContext mc2 = this.mappingManager.getMappingContext(MappingType.ROLE.name());
                if (mc2 == null || !mc2.hasModules()) {
                    rolesAsStringList = this.mapUserRoles(rolesAsStringList);
                }
            } else {
                rolesAsStringList = this.mapUserRoles(rolesAsStringList);
            }
            if (this.authenticationManager instanceof CacheableManager) {
                CacheableManager cm = (CacheableManager)this.authenticationManager;
                return new JBossGenericPrincipal((Realm)this, userPrincipal.getName(), null, rolesAsStringList, userPrincipal, null, cm);
            }
            return new JBossGenericPrincipal((Realm)this, userPrincipal.getName(), null, rolesAsStringList, userPrincipal, null);
        }
        return super.authenticate(username, credentials);
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (certs == null || certs.length < 1) {
            return null;
        }
        if (this.authenticationManager == null) {
            throw new IllegalStateException("Authentication Manager has not been set");
        }
        if (this.authorizationManager == null) {
            throw new IllegalStateException("Authorization Manager has not been set");
        }
        Object userPrincipal = null;
        try {
            userPrincipal = this.certMapping.toPrincipal(certs);
            Subject subject = new Subject();
            boolean isValid = this.authenticationManager.isValid(userPrincipal, (Object)certs, subject);
            if (isValid) {
                MappingContext mc;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("User: " + userPrincipal + " is authenticated"));
                }
                SecurityContext sc = SecurityActions.createSecurityContext(this.authenticationManager.getSecurityDomain());
                userPrincipal = this.getPrincipal(subject);
                sc.getUtil().createSubjectInfo(userPrincipal, (Object)certs, subject);
                SecurityActions.setSecurityContextOnAssociation(sc);
                SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(sc);
                if (this.mappingManager != null && (mc = this.mappingManager.getMappingContext(MappingType.ROLE.name())) != null && mc.hasModules()) {
                    SecurityRolesAssociation.setSecurityRoles(this.principalVersusRolesMap);
                }
                RoleGroup roles = this.authorizationManager.getSubjectRoles(subject, (CallbackHandler)scb);
                List rolesAsList = roles.getRoles();
                List<String> rolesAsStringList = new ArrayList<String>();
                for (Role role : rolesAsList) {
                    rolesAsStringList.add(role.getRoleName());
                }
                if (this.mappingManager != null) {
                    MappingContext mc2 = this.mappingManager.getMappingContext(MappingType.ROLE.name());
                    if (mc2 == null || !mc2.hasModules()) {
                        rolesAsStringList = this.mapUserRoles(rolesAsStringList);
                    }
                } else {
                    rolesAsStringList = this.mapUserRoles(rolesAsStringList);
                }
                if (this.authenticationManager instanceof CacheableManager) {
                    CacheableManager cm = (CacheableManager)this.authenticationManager;
                    userPrincipal = new JBossGenericPrincipal((Realm)this, userPrincipal.getName(), null, rolesAsStringList, (Principal)userPrincipal, null, (CacheableManager<?, Principal>)cm);
                } else {
                    userPrincipal = new JBossGenericPrincipal((Realm)this, userPrincipal.getName(), null, rolesAsStringList, (Principal)userPrincipal, null);
                }
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("User: " + userPrincipal + " is NOT authenticated"));
                }
                userPrincipal = null;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error during authenticate(X509Certificate[])");
        }
        return userPrincipal;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return new SimplePrincipal(username);
    }

    public Map<String, Set<String>> getPrincipalVersusRolesMap() {
        return this.principalVersusRolesMap;
    }

    public void setPrincipalVersusRolesMap(Map<String, Set<String>> principalVersusRolesMap) {
        this.principalVersusRolesMap = principalVersusRolesMap;
    }

    protected List<String> mapUserRoles(List<String> rolesList) {
        if (this.principalVersusRolesMap != null && this.principalVersusRolesMap.size() > 0) {
            ArrayList<String> mappedRoles = new ArrayList<String>();
            for (String role : rolesList) {
                Set<String> roles = this.principalVersusRolesMap.get(role);
                if (roles != null && roles.size() > 0) {
                    for (String r : roles) {
                        if (mappedRoles.contains(r)) continue;
                        mappedRoles.add(r);
                    }
                    continue;
                }
                if (mappedRoles.contains(role)) continue;
                mappedRoles.add(role);
            }
            return mappedRoles;
        }
        return rolesList;
    }

    private Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                Enumeration e;
                Group g;
                if (!(p instanceof Group) && principal == null) {
                    principal = p;
                }
                if (!(p instanceof Group) || !(g = (Group)Group.class.cast(p)).getName().equals("CallerPrincipal") || callerPrincipal != null || !(e = g.members()).hasMoreElements()) continue;
                callerPrincipal = (Principal)e.nextElement();
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }
}

