/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.jboss.ejb3.interceptors.annotation.impl.InterceptorsImpl;
import org.jboss.ejb3.interceptors.annotation.impl.PostActivateImpl;
import org.jboss.ejb3.interceptors.annotation.impl.PostConstructImpl;
import org.jboss.ejb3.interceptors.annotation.impl.PreDestroyImpl;
import org.jboss.ejb3.interceptors.annotation.impl.PrePassivateImpl;
import org.jboss.ejb3.interceptors.aop.annotation.DefaultInterceptors;
import org.jboss.ejb3.interceptors.aop.annotation.DefaultInterceptorsImpl;
import org.jboss.ejb3.interceptors.aop.annotation.InterceptorOrder;
import org.jboss.ejb3.interceptors.aop.annotation.InterceptorOrderImpl;
import org.jboss.ejb3.interceptors.lang.ClassHelper;
import org.jboss.ejb3.interceptors.metadata.EnvironmentInterceptorMetaDataBridge;
import org.jboss.ejb3.interceptors.util.InterceptorCollection;
import org.jboss.ejb3.metadata.MetaDataBridge;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInterceptorMetaDataBridge
extends EnvironmentInterceptorMetaDataBridge<JBossEnterpriseBeanMetaData>
implements MetaDataBridge<JBossEnterpriseBeanMetaData> {
    private static final Logger log = Logger.getLogger(BeanInterceptorMetaDataBridge.class);
    private volatile boolean initialisedBean;
    private DefaultInterceptors defaultInterceptors;
    private Interceptors interceptors;
    private InterceptorOrder interceptorOrder;
    private ExcludeDefaultInterceptors excludeDefaultInterceptors;
    private Map<DeclaredMethodSignature, Interceptors> methodInterceptors = new HashMap<DeclaredMethodSignature, Interceptors>();
    private Map<DeclaredMethodSignature, InterceptorOrder> methodInterceptorOrders = new HashMap<DeclaredMethodSignature, InterceptorOrder>();
    private Map<DeclaredMethodSignature, ExcludeDefaultInterceptors> methodExcludeDefaultInterceptors = new HashMap<DeclaredMethodSignature, ExcludeDefaultInterceptors>();
    private Map<DeclaredMethodSignature, ExcludeClassInterceptors> methodExcludeClassInterceptors = new HashMap<DeclaredMethodSignature, ExcludeClassInterceptors>();
    private Map<DeclaredMethodSignature, AroundInvoke> aroundInvokes;
    private Map<DeclaredMethodSignature, PostConstruct> postConstructs;
    private Map<DeclaredMethodSignature, PostActivate> postActivates;
    private Map<DeclaredMethodSignature, PrePassivate> prePassivates;
    private Map<DeclaredMethodSignature, PreDestroy> preDestroys;
    private Class<?> beanClass;
    private ClassLoader classLoader;
    private JBossEnterpriseBeanMetaData beanMetaData;
    public static long time;

    public BeanInterceptorMetaDataBridge(Class<?> beanClass, ClassLoader classLoader, JBossEnterpriseBeanMetaData beanMetaData) {
        assert (beanClass != null) : "beanClass is null";
        this.beanClass = beanClass;
        this.classLoader = classLoader;
        this.beanMetaData = beanMetaData;
        this.initialise();
    }

    protected Class<?> getBeanClass() {
        return this.beanClass;
    }

    private static boolean add(InterceptorCollection interceptors, ClassLoader classLoader, InterceptorBindingMetaData binding) {
        boolean result = false;
        Object interceptorClassesMetaData = binding.isTotalOrdering() ? binding.getInterceptorOrder() : binding.getInterceptorClasses();
        if (interceptorClassesMetaData != null) {
            for (String interceptorClassName : interceptorClassesMetaData) {
                result |= interceptors.addValue(BeanInterceptorMetaDataBridge.loadClass(classLoader, interceptorClassName));
            }
        }
        return result;
    }

    protected static boolean add(List<Class<?>> interceptors, ClassLoader classLoader, InterceptorBindingMetaData binding) {
        Object interceptorClassesMetaData = binding.isTotalOrdering() ? binding.getInterceptorOrder() : binding.getInterceptorClasses();
        for (String interceptorClassName : interceptorClassesMetaData) {
            interceptors.add(BeanInterceptorMetaDataBridge.loadClass(classLoader, interceptorClassName));
        }
        return true;
    }

    private static Class<?> loadClass(ClassLoader classLoader, String name) {
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void initialise() {
        if (this.initialisedBean) {
            return;
        }
        ArrayList<InterceptorBindingMetaData> defaultInterceptorBindingMetaData = new ArrayList<InterceptorBindingMetaData>();
        ArrayList<InterceptorBindingMetaData> classInterceptorBindingMetaData = new ArrayList<InterceptorBindingMetaData>();
        ArrayList<InterceptorBindingMetaData> classInterceptorOrderMetaData = new ArrayList<InterceptorBindingMetaData>();
        ArrayList<InterceptorBindingMetaData> methodInterceptorBindingMetaData = new ArrayList<InterceptorBindingMetaData>();
        ArrayList<InterceptorBindingMetaData> methodInterceptorOrderMetaData = new ArrayList<InterceptorBindingMetaData>();
        this.setupMetaDataLists(this.beanMetaData, defaultInterceptorBindingMetaData, classInterceptorBindingMetaData, classInterceptorOrderMetaData, methodInterceptorBindingMetaData, methodInterceptorOrderMetaData);
        this.initialiseDefaultInterceptors(defaultInterceptorBindingMetaData);
        this.initialiseInterceptors(classInterceptorBindingMetaData);
        this.initialiseInterceptorOrder(classInterceptorOrderMetaData);
        Method[] realMethods = ClassHelper.getAllMethods(this.beanClass);
        ArrayList<DeclaredMethodSignature> methods = new ArrayList<DeclaredMethodSignature>();
        for (Method realMethod : realMethods) {
            methods.add(new DeclaredMethodSignature(realMethod));
        }
        this.initialiseMethodInterceptors(methods, methodInterceptorBindingMetaData);
        this.initialiseMethodInterceptorOrders(methods, methodInterceptorOrderMetaData);
        this.initialiseAroundInvoke(methods);
    }

    private void setupMetaDataLists(JBossEnterpriseBeanMetaData beanMetaData, List<InterceptorBindingMetaData> defaultInterceptorBindingMetaData, List<InterceptorBindingMetaData> classInterceptorBindingMetaData, List<InterceptorBindingMetaData> classInterceptorOrderMetaData, List<InterceptorBindingMetaData> methodInterceptorBindingMetaData, List<InterceptorBindingMetaData> methodInterceptorOrderMetaData) {
        try {
            InterceptorBindingsMetaData bindings = beanMetaData.getEjbJarMetaData().getAssemblyDescriptor().getInterceptorBindings();
            if (bindings != null) {
                String ejbName = beanMetaData.getEjbName();
                for (InterceptorBindingMetaData binding : bindings) {
                    String bindingEjbName = binding.getEjbName();
                    this.checkBeanExistsInDeployment(beanMetaData, bindingEjbName);
                    if (bindingEjbName.equals("*")) {
                        assert (binding.getMethod() == null) : "method binding not allowed on default interceptor";
                        defaultInterceptorBindingMetaData.add(binding);
                        continue;
                    }
                    if (!bindingEjbName.equals(ejbName)) continue;
                    if (binding.getMethod() == null) {
                        if (binding.isTotalOrdering()) {
                            classInterceptorOrderMetaData.add(binding);
                            continue;
                        }
                        classInterceptorBindingMetaData.add(binding);
                        continue;
                    }
                    if (binding.isTotalOrdering()) {
                        methodInterceptorOrderMetaData.add(binding);
                        continue;
                    }
                    methodInterceptorBindingMetaData.add(binding);
                }
            }
        }
        catch (NullPointerException e) {
            if (beanMetaData == null) {
                throw new IllegalStateException("Null beannMetaData", e);
            }
            if (beanMetaData.getEjbJarMetaData() == null) {
                throw new IllegalStateException("Null ejbJarMetaData", e);
            }
            if (beanMetaData.getEjbJarMetaData().getAssemblyDescriptor() == null) {
                throw new IllegalStateException("Null AssemblyDescriptor", e);
            }
            throw e;
        }
    }

    private void initialiseDefaultInterceptors(List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            ArrayList classes = new ArrayList();
            for (InterceptorBindingMetaData binding : bindings) {
                BeanInterceptorMetaDataBridge.add(classes, this.classLoader, binding);
            }
            if (!classes.isEmpty()) {
                this.defaultInterceptors = new DefaultInterceptorsImpl(classes);
            }
        }
    }

    private void initialiseInterceptors(List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            InterceptorsImpl interceptors = new InterceptorsImpl();
            for (InterceptorBindingMetaData binding : bindings) {
                BeanInterceptorMetaDataBridge.add(interceptors, this.classLoader, binding);
                this.checkClassLevelExcludeDefaultInterceptors(binding);
            }
            if (!interceptors.isEmpty()) {
                this.interceptors = interceptors;
            }
        }
    }

    private void initialiseInterceptorOrder(List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            InterceptorOrderImpl interceptors = new InterceptorOrderImpl();
            for (InterceptorBindingMetaData binding : bindings) {
                BeanInterceptorMetaDataBridge.add(interceptors, this.classLoader, binding);
                this.checkClassLevelExcludeDefaultInterceptors(binding);
            }
            if (!interceptors.isEmpty()) {
                this.interceptorOrder = interceptors;
            }
        }
    }

    private void checkClassLevelExcludeDefaultInterceptors(InterceptorBindingMetaData binding) {
        ExcludeDefaultInterceptors exDefaultInterceptors = this.checkExcludeDefaultInterceptors(binding);
        if (exDefaultInterceptors != null) {
            this.excludeDefaultInterceptors = exDefaultInterceptors;
        }
    }

    private ExcludeDefaultInterceptors checkExcludeDefaultInterceptors(InterceptorBindingMetaData binding) {
        if (binding.isExcludeDefaultInterceptors()) {
            return new ExcludeDefaultInterceptors(){

                public Class<? extends Annotation> annotationType() {
                    return ExcludeDefaultInterceptors.class;
                }
            };
        }
        return null;
    }

    private void addMethodLevelExclusions(DeclaredMethodSignature sig, InterceptorBindingMetaData binding) {
        ExcludeDefaultInterceptors exDefaultInterceptors = this.checkExcludeDefaultInterceptors(binding);
        if (exDefaultInterceptors != null) {
            this.methodExcludeDefaultInterceptors.put(sig, exDefaultInterceptors);
        }
        if (binding.isExcludeClassInterceptors()) {
            this.methodExcludeClassInterceptors.put(sig, new ExcludeClassInterceptors(){

                public Class<? extends Annotation> annotationType() {
                    return ExcludeClassInterceptors.class;
                }
            });
        }
    }

    private void initialiseMethodInterceptors(List<DeclaredMethodSignature> methods, List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            this.methodInterceptors = new HashMap<DeclaredMethodSignature, Interceptors>();
            for (InterceptorBindingMetaData binding : bindings) {
                NamedMethodMetaData method = binding.getMethod();
                if (method.getMethodName() == null) continue;
                for (DeclaredMethodSignature refMethod : methods) {
                    if (!BeanInterceptorMetaDataBridge.matches(refMethod, method)) continue;
                    InterceptorsImpl interceptors = (InterceptorsImpl)this.methodInterceptors.get(refMethod);
                    if (interceptors == null) {
                        interceptors = new InterceptorsImpl();
                        this.methodInterceptors.put(refMethod, interceptors);
                    }
                    BeanInterceptorMetaDataBridge.add(interceptors, this.classLoader, binding);
                    this.addMethodLevelExclusions(refMethod, binding);
                }
            }
        }
    }

    private void initialiseMethodInterceptorOrders(List<DeclaredMethodSignature> methods, List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            this.methodInterceptorOrders = new HashMap<DeclaredMethodSignature, InterceptorOrder>();
            for (InterceptorBindingMetaData binding : bindings) {
                NamedMethodMetaData method = binding.getMethod();
                if (method.getMethodName() == null) continue;
                for (DeclaredMethodSignature refMethod : methods) {
                    if (!BeanInterceptorMetaDataBridge.matches(refMethod, method)) continue;
                    InterceptorOrderImpl interceptors = (InterceptorOrderImpl)this.methodInterceptors.get(refMethod);
                    if (interceptors == null) {
                        interceptors = new InterceptorOrderImpl();
                        this.methodInterceptorOrders.put(refMethod, interceptors);
                    }
                    BeanInterceptorMetaDataBridge.add(interceptors, this.classLoader, binding);
                }
            }
        }
    }

    private void initialiseAroundInvoke(List<DeclaredMethodSignature> methods) {
        AroundInvokesMetaData aroundInvokes = null;
        if (this.beanMetaData instanceof JBossMessageDrivenBeanMetaData) {
            aroundInvokes = ((JBossMessageDrivenBeanMetaData)this.beanMetaData).getAroundInvokes();
        } else if (this.beanMetaData instanceof JBossSessionBeanMetaData) {
            aroundInvokes = ((JBossSessionBeanMetaData)this.beanMetaData).getAroundInvokes();
        }
        if (aroundInvokes != null) {
            for (DeclaredMethodSignature method : methods) {
                AroundInvoke aroundInvoke = this.getAroundInvokeAnnotation(aroundInvokes, method);
                if (aroundInvoke == null) continue;
                if (this.aroundInvokes == null) {
                    this.aroundInvokes = new HashMap<DeclaredMethodSignature, AroundInvoke>();
                }
                this.aroundInvokes.put(method, aroundInvoke);
            }
        }
    }

    private void initialiseLifecycleAnnotations(List<DeclaredMethodSignature> methods) {
        if (this.beanMetaData instanceof JBossSessionBeanMetaData) {
            for (DeclaredMethodSignature method : methods) {
                PreDestroy preDestroy;
                PrePassivate prePassivate;
                PostActivate postActivate;
                PostConstruct postConstruct = this.getLifeCycleAnnotation(((JBossSessionBeanMetaData)this.beanMetaData).getPostConstructs(), PostConstructImpl.class, method);
                if (postConstruct != null) {
                    if (this.postConstructs == null) {
                        this.postConstructs = new HashMap<DeclaredMethodSignature, PostConstruct>();
                    }
                    this.postConstructs.put(method, postConstruct);
                }
                if ((postActivate = (PostActivate)this.getLifeCycleAnnotation(((JBossSessionBeanMetaData)this.beanMetaData).getPostActivates(), PostActivateImpl.class, method)) != null) {
                    if (this.postActivates == null) {
                        this.postActivates = new HashMap<DeclaredMethodSignature, PostActivate>();
                    }
                    this.postActivates.put(method, postActivate);
                }
                if ((prePassivate = (PrePassivate)this.getLifeCycleAnnotation(((JBossSessionBeanMetaData)this.beanMetaData).getPrePassivates(), PrePassivateImpl.class, method)) != null) {
                    if (this.prePassivates == null) {
                        this.prePassivates = new HashMap<DeclaredMethodSignature, PrePassivate>();
                    }
                    this.prePassivates.put(method, prePassivate);
                }
                if ((preDestroy = (PreDestroy)this.getLifeCycleAnnotation(((JBossSessionBeanMetaData)this.beanMetaData).getPreDestroys(), PreDestroyImpl.class, method)) == null) continue;
                if (this.preDestroys == null) {
                    this.preDestroys = new HashMap<DeclaredMethodSignature, PreDestroy>();
                }
                this.preDestroys.put(method, preDestroy);
            }
        }
    }

    private static boolean matches(DeclaredMethodSignature signature, NamedMethodMetaData method) {
        if (!signature.getName().equals(method.getMethodName())) {
            return false;
        }
        if (method.getMethodParams() == null) {
            return signature.getParameters() == null || signature.getParameters().length == 0;
        }
        return Arrays.equals(signature.getParameters(), method.getMethodParams().toArray());
    }

    @Override
    public <A extends Annotation> A retrieveAnnotation(Class<A> annotationClass, JBossEnterpriseBeanMetaData beanMetaData, ClassLoader classLoader) {
        if (annotationClass == DefaultInterceptors.class) {
            return (A)((Annotation)annotationClass.cast(this.defaultInterceptors));
        }
        if (annotationClass == InterceptorOrder.class) {
            return (A)((Annotation)annotationClass.cast(this.interceptorOrder));
        }
        if (annotationClass == Interceptors.class) {
            return (A)((Annotation)annotationClass.cast(this.interceptors));
        }
        if (annotationClass == ExcludeDefaultInterceptors.class) {
            return (A)((Annotation)annotationClass.cast(this.excludeDefaultInterceptors));
        }
        return super.retrieveAnnotation(annotationClass, beanMetaData, classLoader);
    }

    @Override
    public <A extends Annotation> A retrieveAnnotation(Class<A> annotationClass, JBossEnterpriseBeanMetaData beanMetaData, ClassLoader classLoader, DeclaredMethodSignature method) {
        if (annotationClass == AroundInvoke.class) {
            String[] parameterTypes = method.getParameters();
            if (parameterTypes.length == 1 && parameterTypes[0].equals(InvocationContext.class.getName()) && this.aroundInvokes != null) {
                return (A)((Annotation)annotationClass.cast(this.aroundInvokes.get(method)));
            }
            return null;
        }
        if (annotationClass == InterceptorOrder.class) {
            if (this.methodInterceptorOrders == null) {
                return null;
            }
            return (A)((Annotation)annotationClass.cast(this.methodInterceptorOrders.get(method)));
        }
        if (annotationClass == Interceptors.class) {
            if (this.methodInterceptors == null) {
                return null;
            }
            return (A)((Annotation)annotationClass.cast(this.methodInterceptors.get(method)));
        }
        if (annotationClass == ExcludeDefaultInterceptors.class) {
            return (A)((Annotation)annotationClass.cast(this.methodExcludeDefaultInterceptors.get(method)));
        }
        if (annotationClass == ExcludeClassInterceptors.class) {
            return (A)((Annotation)annotationClass.cast(this.methodExcludeClassInterceptors.get(method)));
        }
        if (annotationClass == PostActivate.class) {
            if (beanMetaData instanceof JBossSessionBeanMetaData && method.getParameters().length == 0 && this.postActivates != null) {
                return (A)((Annotation)annotationClass.cast(this.postActivates.get(method)));
            }
        } else if (annotationClass == PostConstruct.class) {
            if (beanMetaData instanceof JBossSessionBeanMetaData && method.getParameters().length == 0 && this.postConstructs != null) {
                return (A)((Annotation)annotationClass.cast(this.postConstructs.get(method)));
            }
        } else if (annotationClass == PreDestroy.class) {
            if (beanMetaData instanceof JBossSessionBeanMetaData && method.getParameters().length == 0 && this.preDestroys != null) {
                return (A)((Annotation)annotationClass.cast(this.preDestroys.get(method)));
            }
        } else if (annotationClass == PrePassivate.class && beanMetaData instanceof JBossSessionBeanMetaData && method.getParameters().length == 0 && this.prePassivates != null) {
            return (A)((Annotation)annotationClass.cast(this.prePassivates.get(method)));
        }
        return super.retrieveAnnotation(annotationClass, beanMetaData, classLoader, method);
    }

    private void checkBeanExistsInDeployment(JBossEnterpriseBeanMetaData beanMetaData, String ejbName) {
        if (ejbName.equals("*")) {
            return;
        }
        JBossEnterpriseBeansMetaData beansMetaData = beanMetaData.getEnterpriseBeansMetaData();
        if (beansMetaData.get(ejbName) == null) {
            throw new IllegalArgumentException("No bean with name specified in interceptor-binding: " + ejbName);
        }
    }

    private static class MethodSignatures {
        Map<Method, Signature> methodSignatures = new HashMap<Method, Signature>();

        private MethodSignatures() {
        }

        Signature getSignature(Method m) {
            Signature s = this.methodSignatures.get(m);
            if (s == null) {
                s = new DeclaredMethodSignature(m);
                this.methodSignatures.put(m, s);
            }
            return s;
        }
    }
}

