/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import jakarta.jms.XAConnection;
import jakarta.jms.XAJMSContext;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XASession;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicSession;
import java.io.Serializable;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JMSConsumerToMessageConsumer;
import org.jboss.resource.adapter.jms.JMSProducerToMessageProducer;
import org.jboss.resource.adapter.jms.JmsConnectionSession;

public class JmsConnectionContext
implements Connection,
XAConnection,
Session,
XASession,
QueueConnection,
XAQueueConnection,
TopicConnection,
XATopicConnection,
AutoCloseable {
    private static final Logger log = Logger.getLogger(JmsConnectionContext.class);
    private final JMSContext jmsContext;
    private final XAJMSContext xaJmsContext;

    public JmsConnectionContext(JMSContext jmsContext) {
        if (jmsContext == null) {
            throw new ExceptionInInitializerError("JMS 2.0 JMSContext must not be null");
        }
        this.jmsContext = jmsContext;
        this.xaJmsContext = jmsContext instanceof XAJMSContext ? (XAJMSContext)jmsContext : null;
    }

    public Session getSession() throws JMSException {
        if (this.xaJmsContext != null) {
            return new JmsConnectionContext(this.xaJmsContext.getContext());
        }
        throw new JMSException("Not an XA compliant JMS session context");
    }

    public XAResource getXAResource() {
        if (this.xaJmsContext != null) {
            return this.xaJmsContext.getXAResource();
        }
        throw new IllegalStateException("Not an XA compliant JMS session context");
    }

    public XASession createXASession() throws JMSException {
        if (this.xaJmsContext != null) {
            return this;
        }
        throw new JMSException("Not an XA compliant JMS session context");
    }

    public BytesMessage createBytesMessage() throws JMSException {
        try {
            return this.jmsContext.createBytesMessage();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MapMessage createMapMessage() throws JMSException {
        try {
            return this.jmsContext.createMapMessage();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Message createMessage() throws JMSException {
        try {
            return this.jmsContext.createMessage();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        try {
            return this.jmsContext.createObjectMessage();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        try {
            return this.jmsContext.createObjectMessage(object);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public StreamMessage createStreamMessage() throws JMSException {
        try {
            return this.jmsContext.createStreamMessage();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public TextMessage createTextMessage() throws JMSException {
        try {
            return this.jmsContext.createTextMessage();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        try {
            return this.jmsContext.createTextMessage(text);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public boolean getTransacted() throws JMSException {
        try {
            return this.jmsContext.getTransacted();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        try {
            int sessionMode = this.jmsContext.getSessionMode();
            switch (sessionMode) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 0: {
                    return 0;
                }
            }
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
        throw new JMSException("No valid JMS session context");
    }

    public void commit() throws JMSException {
        try {
            this.jmsContext.commit();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void rollback() throws JMSException {
        try {
            this.jmsContext.rollback();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void recover() throws JMSException {
        try {
            this.jmsContext.recover();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new JMSException("Must not be used in a Java EE application");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new JMSException("Must not be used in a Java EE application");
    }

    public void run() {
        throw new UnsupportedOperationException("JMSContext does not support run()");
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        try {
            return new JMSProducerToMessageProducer(this.jmsContext.createProducer(), destination);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        try {
            return new JMSConsumerToMessageConsumer(this.jmsContext.createConsumer(destination));
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        try {
            return new JMSConsumerToMessageConsumer(this.jmsContext.createConsumer(destination, messageSelector));
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        try {
            return new JMSConsumerToMessageConsumer(this.jmsContext.createConsumer(destination, messageSelector, noLocal));
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        try {
            return new JMSConsumerToMessageConsumer(this.jmsContext.createSharedConsumer(topic, sharedSubscriptionName));
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        try {
            return new JMSConsumerToMessageConsumer(this.jmsContext.createSharedConsumer(topic, sharedSubscriptionName, messageSelector));
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Queue createQueue(String queueName) throws JMSException {
        try {
            return this.jmsContext.createQueue(queueName);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Topic createTopic(String topicName) throws JMSException {
        try {
            return this.jmsContext.createTopic(topicName);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        try {
            return new JmsConnectionSession.JMSConsumerToTopicSubscriber(this.jmsContext.createDurableConsumer(topic, name), topic);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        try {
            return new JmsConnectionSession.JMSConsumerToTopicSubscriber(this.jmsContext.createDurableConsumer(topic, name, messageSelector, noLocal), topic);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        try {
            return new JMSConsumerToMessageConsumer(this.jmsContext.createDurableConsumer(topic, name));
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        try {
            return new JMSConsumerToMessageConsumer(this.jmsContext.createDurableConsumer(topic, name, messageSelector, noLocal));
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        try {
            return new JMSConsumerToMessageConsumer(this.jmsContext.createSharedDurableConsumer(topic, name));
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        try {
            return new JMSConsumerToMessageConsumer(this.jmsContext.createSharedDurableConsumer(topic, name, messageSelector));
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        try {
            return this.jmsContext.createBrowser(queue);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        try {
            return this.jmsContext.createBrowser(queue, messageSelector);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        try {
            return this.jmsContext.createTemporaryQueue();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        try {
            return this.jmsContext.createTemporaryTopic();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void unsubscribe(String name) throws JMSException {
        try {
            this.jmsContext.unsubscribe(name);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        try {
            log.debug((Object)("Ignoring parameters to createSession(boolean, int); JMSContext has been created with sessionMode=" + this.jmsContext.getSessionMode()));
            return this;
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Session createSession(int sessionMode) throws JMSException {
        try {
            log.debug((Object)("Ignoring parameters to createSession(boolean, int); JMSContext has been created with sessionMode=" + this.jmsContext.getSessionMode()));
            return this;
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Session createSession() throws JMSException {
        return this;
    }

    public String getClientID() throws JMSException {
        try {
            return this.jmsContext.getClientID();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void setClientID(String clientID) throws JMSException {
        try {
            this.jmsContext.setClientID(clientID);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        try {
            return this.jmsContext.getMetaData();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        try {
            return this.jmsContext.getExceptionListener();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        try {
            this.jmsContext.setExceptionListener(listener);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void start() throws JMSException {
        try {
            this.jmsContext.start();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void stop() throws JMSException {
        try {
            this.jmsContext.stop();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    @Override
    public void close() throws JMSException {
        try {
            this.jmsContext.close();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("JMSContext does not support ConnectionConsumers");
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("JMSContext does not support ConnectionConsumers");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("JMSContext does not support ConnectionConsumers");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("JMSContext does not support ConnectionConsumers");
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        throw new JMSException("JMS connection context does not implement XAQueueConnection");
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        throw new JMSException("JMS connection context does not implement QueueConnection");
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("JMS connection context does not implement QueueConnection");
    }

    public XATopicSession createXATopicSession() throws JMSException {
        throw new JMSException("JMS connection context does not implement XATopicConnection");
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        throw new JMSException("JMS connection context does not implement TopicConnection");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("JMS connection context does not implement TopicConnection");
    }
}

