/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.SecurityException;
import jakarta.resource.spi.security.PasswordCredential;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;

public class JmsCred {
    public String name;
    public char[] pwd;

    public static JmsCred getJmsCred(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) throws SecurityException {
        JmsCred jc = new JmsCred();
        if (subject == null && info != null) {
            jc.name = ((JmsConnectionRequestInfo)info).getUserName();
            jc.pwd = ((JmsConnectionRequestInfo)info).getPassword();
        } else if (subject != null) {
            PasswordCredential pwdc = GetCredentialAction.getCredential(subject, mcf);
            if (pwdc == null) {
                throw new SecurityException("No Password credentials found");
            }
            jc.name = pwdc.getUserName();
            jc.pwd = pwdc.getPassword();
        } else {
            throw new SecurityException("No Subject or ConnectionRequestInfo set, could not get credentials");
        }
        return jc;
    }

    public String toString() {
        return super.toString() + "{ username=" + this.name + ", password=**** }";
    }

    private static class GetCredentialAction
    implements PrivilegedAction<PasswordCredential> {
        Subject subject;
        ManagedConnectionFactory mcf;

        GetCredentialAction(Subject subject, ManagedConnectionFactory mcf) {
            this.subject = subject;
            this.mcf = mcf;
        }

        @Override
        public PasswordCredential run() {
            Set<PasswordCredential> creds = this.subject.getPrivateCredentials(PasswordCredential.class);
            PasswordCredential pwdc = null;
            for (PasswordCredential curCred : creds) {
                if (!curCred.getManagedConnectionFactory().equals((Object)this.mcf)) continue;
                pwdc = curCred;
                break;
            }
            return pwdc;
        }

        static PasswordCredential getCredential(Subject subject, ManagedConnectionFactory mcf) {
            GetCredentialAction action = new GetCredentialAction(subject, mcf);
            return AccessController.doPrivileged(action);
        }
    }
}

