/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.gravia.runtime.AbstractTracked;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleEvent;
import org.jboss.gravia.runtime.ModuleTrackerCustomizer;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.SynchronousModuleListener;

public class ModuleTracker<T>
implements ModuleTrackerCustomizer<T> {
    static final boolean DEBUG = false;
    protected final ModuleContext context;
    final ModuleTrackerCustomizer<T> customizer;
    private volatile Tracked tracked;
    final Set<Module.State> states = new HashSet<Module.State>();

    private Tracked tracked() {
        return this.tracked;
    }

    public ModuleTracker(ModuleContext context, ModuleTrackerCustomizer<T> customizer, Module.State ... states) {
        this.context = context;
        ModuleTrackerCustomizer<T> moduleTrackerCustomizer = this.customizer = customizer == null ? this : customizer;
        if (states != null) {
            this.states.addAll(Arrays.asList(states));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Tracked t;
        ModuleTracker moduleTracker = this;
        synchronized (moduleTracker) {
            if (this.tracked != null) {
                return;
            }
            Tracked tracked = t = new Tracked();
            synchronized (tracked) {
                this.context.addModuleListener(t);
                Runtime runtime = RuntimeLocator.getRequiredRuntime();
                Set<Module> modules = runtime.getModules();
                Iterator<Module> itmods = modules.iterator();
                while (itmods.hasNext()) {
                    Module module = itmods.next();
                    Module.State state = module.getState();
                    if (this.states.contains((Object)state)) continue;
                    itmods.remove();
                }
                t.setInitial((Module[])modules.toArray());
            }
            this.tracked = t;
        }
        t.trackInitial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Module[] modules;
        Tracked outgoing;
        ModuleTracker moduleTracker = this;
        synchronized (moduleTracker) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return;
            }
            outgoing.close();
            modules = this.getModules();
            this.tracked = null;
            try {
                this.context.removeModuleListener(outgoing);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        if (modules != null) {
            for (int i = 0; i < modules.length; ++i) {
                outgoing.untrack(modules[i], null);
            }
        }
    }

    @Override
    public T addingModule(Module module, ModuleEvent event) {
        Module result = module;
        return (T)result;
    }

    @Override
    public void modifiedModule(Module module, ModuleEvent event, T object) {
    }

    @Override
    public void removedModule(Module module, ModuleEvent event, T object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module[] getModules() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            if (length == 0) {
                return null;
            }
            return t.copyKeys(new Module[length]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getObject(Module module) {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getCustomizedObject(module);
        }
    }

    public void remove(Module module) {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        t.untrack(module, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked t = this.tracked();
        if (t == null) {
            return 0;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked t = this.tracked();
        if (t == null) {
            return -1;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getTrackingCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Module, T> getTracked() {
        HashMap map = new HashMap();
        Tracked t = this.tracked();
        if (t == null) {
            return map;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.copyEntries(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Tracked t = this.tracked();
        if (t == null) {
            return true;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.isEmpty();
        }
    }

    private final class Tracked
    extends AbstractTracked<Module, T, ModuleEvent>
    implements SynchronousModuleListener {
        Tracked() {
        }

        @Override
        public void moduleChanged(ModuleEvent event) {
            if (this.closed) {
                return;
            }
            Module module = event.getModule();
            Module.State state = module.getState();
            if (ModuleTracker.this.states.contains((Object)state)) {
                this.track(module, event);
            } else {
                this.untrack(module, event);
            }
        }

        @Override
        T customizerAdding(Module item, ModuleEvent related) {
            return ModuleTracker.this.customizer.addingModule(item, related);
        }

        @Override
        void customizerModified(Module item, ModuleEvent related, T object) {
            ModuleTracker.this.customizer.modifiedModule(item, related, object);
        }

        @Override
        void customizerRemoved(Module item, ModuleEvent related, T object) {
            ModuleTracker.this.customizer.removedModule(item, related, object);
        }
    }
}

