package org.jboss.hal.config;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class RolesChangedEvent extends GwtEvent<RolesChangedEvent.RolesChangedHandler> { 


  public RolesChangedEvent() {
    // Possibly for serialization.
  }

  public static void fire(HasHandlers source) {
    RolesChangedEvent eventInstance = new RolesChangedEvent();
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, RolesChangedEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasRolesChangedHandlers extends HasHandlers {
    HandlerRegistration addRolesChangedHandler(RolesChangedHandler handler);
  }

  public interface RolesChangedHandler extends EventHandler {
    public void onRolesChanged(RolesChangedEvent event);
  }

  private static final Type<RolesChangedHandler> TYPE = new Type<RolesChangedHandler>();

  public static Type<RolesChangedHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<RolesChangedHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(RolesChangedHandler handler) {
    handler.onRolesChanged(this);
  }

  @Override
  public boolean equals(Object obj) {
    return super.equals(obj);
  }

  @Override
  public int hashCode() {
    return super.hashCode();
  }

  @Override
  public String toString() {
    return "RolesChangedEvent["
    + "]";
  }
}
