/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInternal;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeTarget;
import org.jboss.jandex.Utils;

public final class FieldInfo
implements AnnotationTarget {
    private ClassInfo clazz;
    private FieldInternal internal;

    FieldInfo() {
    }

    FieldInfo(ClassInfo clazz, FieldInternal internal) {
        this.clazz = clazz;
        this.internal = internal;
    }

    FieldInfo(ClassInfo clazz, byte[] name, Type type, short flags) {
        this(clazz, new FieldInternal(name, type, flags));
    }

    public static FieldInfo create(ClassInfo clazz, String name, Type type, short flags) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        return new FieldInfo(clazz, Utils.toUTF8(name), type, flags);
    }

    public final String name() {
        return this.internal.name();
    }

    public final ClassInfo declaringClass() {
        return this.clazz;
    }

    public final Type type() {
        return this.internal.type();
    }

    @Override
    public final AnnotationTarget.Kind kind() {
        return AnnotationTarget.Kind.FIELD;
    }

    public List<AnnotationInstance> annotations() {
        return this.internal.annotations();
    }

    public final short flags() {
        return this.internal.flags();
    }

    public String toString() {
        return this.internal.toString(this.clazz);
    }

    @Override
    public final ClassInfo asClass() {
        throw new IllegalArgumentException("Not a class");
    }

    @Override
    public final FieldInfo asField() {
        return this;
    }

    @Override
    public final MethodInfo asMethod() {
        throw new IllegalArgumentException("Not a method");
    }

    @Override
    public final MethodParameterInfo asMethodParameter() {
        throw new IllegalArgumentException("Not a method parameter");
    }

    @Override
    public final TypeTarget asType() {
        throw new IllegalArgumentException("Not a type");
    }

    void setType(Type type) {
        this.internal.setType(type);
    }

    void setAnnotations(List<AnnotationInstance> annotations) {
        this.internal.setAnnotations(annotations);
    }

    FieldInternal fieldInternal() {
        return this.internal;
    }

    void setFieldInternal(FieldInternal internal) {
        this.internal = internal;
    }

    void setClassInfo(ClassInfo clazz) {
        this.clazz = clazz;
    }
}

