/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import java.util.ArrayList;
import java.util.Arrays;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.stackmap.TypeData;
import javassist.bytecode.stackmap.TypeTag;

public class BasicBlock
implements TypeTag,
Comparable {
    public int position;
    public int length;
    public int stackTop;
    public int numLocals;
    public TypeData[] stackTypes;
    public TypeData[] localsTypes;
    public int version;
    public int[] localsUsage;
    public int inbound;
    public Branch catchBlocks;

    private BasicBlock(int pos) {
        this.position = pos;
        this.length = 0;
        this.numLocals = 0;
        this.stackTop = 0;
        this.localsTypes = null;
        this.stackTypes = null;
        this.inbound = 1;
        this.localsUsage = null;
        this.catchBlocks = null;
    }

    public boolean alreadySet(int ver) {
        return this.stackTypes != null && ver == this.version;
    }

    public void resetNumLocals() {
        if (this.localsTypes != null) {
            TypeData td;
            int nl;
            for (nl = this.numLocals; nl > 0 && this.localsTypes[nl - 1] == TypeTag.TOP && (nl <= 1 || (td = this.localsTypes[nl - 2]) != TypeTag.LONG && td != TypeTag.DOUBLE); --nl) {
            }
            this.numLocals = nl;
        }
    }

    public void setStackMap(int st, TypeData[] stack, int nl, TypeData[] locals) throws BadBytecode {
        this.stackTop = st;
        this.stackTypes = stack;
        this.numLocals = nl;
        this.localsTypes = locals;
    }

    private void updateLength(int nextPos) {
        this.length = nextPos - this.position;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Block at ");
        sbuf.append(this.position);
        sbuf.append(" stack={");
        BasicBlock.printTypes(sbuf, this.stackTop, this.stackTypes);
        sbuf.append("} locals={");
        BasicBlock.printTypes(sbuf, this.numLocals, this.localsTypes);
        sbuf.append('}');
        return sbuf.toString();
    }

    private static void printTypes(StringBuffer sbuf, int size, TypeData[] types) {
        if (types == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            TypeData td;
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append((td = types[i]) == null ? "<>" : td.toString());
        }
    }

    public static BasicBlock find(BasicBlock[] blocks, int pos) throws BadBytecode {
        int n = blocks.length;
        for (int i = 0; i < n; ++i) {
            if (blocks[i].position != pos) continue;
            return blocks[i];
        }
        throw new BadBytecode("no basic block: " + pos);
    }

    public static BasicBlock[] makeBlocks(MethodInfo minfo) throws BadBytecode {
        CodeAttribute ca = minfo.getCodeAttribute();
        if (ca == null) {
            return null;
        }
        CodeIterator ci = ca.iterator();
        ConstPool pool = minfo.getConstPool();
        BasicBlock[] blocks = BasicBlock.makeBlocks(ci, 0, ci.getCodeLength(), ca.getExceptionTable(), 0, pool);
        boolean isStatic = (minfo.getAccessFlags() & 8) != 0;
        blocks[0].initFirstBlock(ca.getMaxStack(), ca.getMaxLocals(), pool.getClassName(), minfo.getDescriptor(), isStatic, minfo.isConstructor());
        return blocks;
    }

    public static BasicBlock[] makeBlocks(CodeIterator ci, int begin, int end, ExceptionTable et, int etOffset, ConstPool pool) throws BadBytecode {
        int index;
        ci.begin();
        ci.move(begin);
        ArrayList<BasicBlock> targets = new ArrayList<BasicBlock>();
        BasicBlock bb0 = new BasicBlock(begin);
        bb0.inbound = 0;
        targets.add(bb0);
        while (ci.hasNext() && (index = ci.next()) < end) {
            int op = ci.byteAt(index);
            if (153 <= op && op <= 166 || op == 198 || op == 199) {
                targets.add(new BasicBlock(index + ci.s16bitAt(index + 1)));
                continue;
            }
            if (167 <= op && op <= 171) {
                switch (op) {
                    case 167: 
                    case 168: {
                        targets.add(new BasicBlock(index + ci.s16bitAt(index + 1)));
                        break;
                    }
                    case 170: {
                        int p;
                        int pos = (index & 0xFFFFFFFC) + 4;
                        targets.add(new BasicBlock(index + ci.s32bitAt(pos)));
                        int low = ci.s32bitAt(pos + 4);
                        int high = ci.s32bitAt(pos + 8);
                        int n = p + (high - low + 1) * 4;
                        for (p = pos + 12; p < n; p += 4) {
                            targets.add(new BasicBlock(index + ci.s32bitAt(p)));
                        }
                        break;
                    }
                    case 171: {
                        int p;
                        int pos = (index & 0xFFFFFFFC) + 4;
                        targets.add(new BasicBlock(index + ci.s32bitAt(pos)));
                        int n = p + ci.s32bitAt(pos + 4) * 8;
                        for (p = pos + 8 + 4; p < n; p += 8) {
                            targets.add(new BasicBlock(index + ci.s32bitAt(p)));
                        }
                        break;
                    }
                }
                continue;
            }
            if (op != 200 && op != 201) continue;
            targets.add(new BasicBlock(index + ci.s32bitAt(index + 1)));
        }
        if (et != null) {
            int i = et.size();
            while (--i >= 0) {
                BasicBlock bb = new BasicBlock(et.startPc(i) + etOffset);
                bb.inbound = 0;
                targets.add(bb);
                targets.add(new BasicBlock(et.handlerPc(i) + etOffset));
            }
        }
        BasicBlock[] blocks = BasicBlock.trimArray(targets, end);
        BasicBlock.markCatch(et, etOffset, blocks);
        return blocks;
    }

    public int compareTo(Object obj) {
        if (obj instanceof BasicBlock) {
            int pos = ((BasicBlock)obj).position;
            return this.position - pos;
        }
        return -1;
    }

    private static BasicBlock[] trimArray(ArrayList targets, int endPos) {
        BasicBlock bb0;
        Object[] targetArray = targets.toArray();
        int size = targetArray.length;
        Arrays.sort(targetArray);
        int s = 0;
        int t0 = -1;
        for (int i = 0; i < size; ++i) {
            int t = ((BasicBlock)targetArray[i]).position;
            if (t == t0) continue;
            ++s;
            t0 = t;
        }
        BasicBlock[] results = new BasicBlock[s];
        results[0] = bb0 = (BasicBlock)targetArray[0];
        t0 = bb0.position;
        int j = 1;
        for (int i = 1; i < size; ++i) {
            BasicBlock bb = (BasicBlock)targetArray[i];
            int t = bb.position;
            if (t == t0) {
                results[j - 1].inbound += bb.inbound;
                continue;
            }
            results[j - 1].updateLength(t);
            results[j++] = bb;
            t0 = t;
        }
        results[j - 1].updateLength(endPos);
        return results;
    }

    private static void markCatch(ExceptionTable et, int etOffset, BasicBlock[] blocks) {
        if (et == null) {
            return;
        }
        int nblocks = blocks.length;
        int n = et.size();
        for (int i = 0; i < n; ++i) {
            int start = et.startPc(i) + etOffset;
            int end = et.endPc(i) + etOffset;
            int handler = et.handlerPc(i) + etOffset;
            int type = et.catchType(i);
            for (int k = 0; k < nblocks; ++k) {
                BasicBlock bb = blocks[k];
                int p = bb.position;
                if (start > p || p >= end) continue;
                bb.catchBlocks = new Branch(bb.catchBlocks, handler, type);
            }
        }
    }

    void initFirstBlock(int maxStack, int maxLocals, String className, String methodDesc, boolean isStatic, boolean isConstructor) throws BadBytecode {
        if (methodDesc.charAt(0) != '(') {
            throw new BadBytecode("no method descriptor: " + methodDesc);
        }
        this.stackTop = 0;
        this.stackTypes = new TypeData[maxStack];
        TypeData[] locals = new TypeData[maxLocals];
        if (isConstructor) {
            locals[0] = new TypeData.UninitThis(className);
        } else if (!isStatic) {
            locals[0] = new TypeData.ClassName(className);
        }
        int n = isStatic ? -1 : 0;
        int i = 1;
        try {
            while ((i = BasicBlock.descToTag(methodDesc, i, ++n, locals)) > 0) {
                if (!locals[n].is2WordType()) continue;
                locals[++n] = TOP;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new BadBytecode("bad method descriptor: " + methodDesc);
        }
        this.numLocals = n;
        this.localsTypes = locals;
    }

    private static int descToTag(String desc, int i, int n, TypeData[] types) throws BadBytecode {
        int i0 = i;
        int arrayDim = 0;
        char c = desc.charAt(i);
        if (c == ')') {
            return 0;
        }
        while (c == '[') {
            ++arrayDim;
            c = desc.charAt(++i);
        }
        if (c == 'L') {
            int i2 = desc.indexOf(59, ++i);
            types[n] = arrayDim > 0 ? new TypeData.ClassName(desc.substring(i0, ++i2)) : new TypeData.ClassName(desc.substring(i0 + 1, ++i2 - 1).replace('/', '.'));
            return i2;
        }
        if (arrayDim > 0) {
            types[n] = new TypeData.ClassName(desc.substring(i0, ++i));
            return i;
        }
        TypeData t = BasicBlock.toPrimitiveTag(c);
        if (t == null) {
            throw new BadBytecode("bad method descriptor: " + desc);
        }
        types[n] = t;
        return i + 1;
    }

    private static TypeData toPrimitiveTag(char c) {
        switch (c) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return INTEGER;
            }
            case 'J': {
                return LONG;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
        }
        return null;
    }

    public static String getRetType(String desc) {
        int i = desc.indexOf(41);
        if (i < 0) {
            return "java.lang.Object";
        }
        char c = desc.charAt(i + 1);
        if (c == '[') {
            return desc.substring(i + 1);
        }
        if (c == 'L') {
            return desc.substring(i + 2, desc.length() - 1).replace('/', '.');
        }
        return "java.lang.Object";
    }

    public static class Branch {
        public Branch next;
        public int target;
        public int typeIndex;

        public Branch(Branch next, int target, int type) {
            this.next = next;
            this.target = target;
            this.typeIndex = type;
        }
    }
}

