/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import java.io.FileInputStream;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.bytecode.stackmap.BasicBlock;
import javassist.bytecode.stackmap.Tracer;
import javassist.bytecode.stackmap.TypeData;

public class MapMaker
extends Tracer {
    private boolean moveon;
    private boolean loopDetected;
    private int iteration;
    private BasicBlock[] blocks;

    public static void main(String[] args) throws Exception {
        boolean useMain2 = args[0].equals("0");
        if (useMain2 && args.length > 1) {
            MapMaker.main2(args);
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            MapMaker.main1(args[i]);
        }
    }

    public static void main1(String className) throws Exception {
        ClassPool cp = ClassPool.getDefault();
        CtClass cc = cp.makeClass(new FileInputStream(className));
        System.out.println(className);
        ClassFile cf = cc.getClassFile();
        List minfos = cf.getMethods();
        for (int i = 0; i < minfos.size(); ++i) {
            MethodInfo minfo = (MethodInfo)minfos.get(i);
            CodeAttribute ca = minfo.getCodeAttribute();
            if (ca == null) continue;
            ca.setAttribute(MapMaker.getMap(cp, minfo));
        }
        cc.writeFile("tmp");
    }

    public static void main2(String[] args) throws Exception {
        ClassPool cp = ClassPool.getDefault();
        CtClass cc = cp.makeClass(new FileInputStream(args[1]));
        MethodInfo minfo = args[2].equals("_init_") ? cc.getClassInitializer().getMethodInfo() : cc.getDeclaredMethod(args[2]).getMethodInfo();
        MapMaker mm = MapMaker.makeMapMaker(cp, minfo);
        if (mm == null) {
            System.out.println("single basic block");
        } else {
            BasicBlock[] blocks = mm.getBlocks();
            for (int i = 0; i < blocks.length; ++i) {
                System.out.println(blocks[i]);
            }
            StackMapTable smt = mm.toStackMap();
        }
    }

    public static StackMapTable getMap(ClassPool classes, MethodInfo minfo) throws BadBytecode {
        MapMaker mm = MapMaker.makeMapMaker(classes, minfo);
        if (mm == null) {
            return null;
        }
        return mm.toStackMap();
    }

    public static MapMaker makeMapMaker(ClassPool classes, MethodInfo minfo) throws BadBytecode {
        CodeAttribute ca = minfo.getCodeAttribute();
        if (ca == null) {
            return null;
        }
        CodeIterator ci = ca.iterator();
        ConstPool pool = minfo.getConstPool();
        ExceptionTable et = ca.getExceptionTable();
        BasicBlock[] blocks = BasicBlock.makeBlocks(ci, 0, ci.getCodeLength(), et, 0, pool);
        if (blocks.length < 2 && (blocks.length == 0 || blocks[0].inbound < 1)) {
            return null;
        }
        boolean isStatic = (minfo.getAccessFlags() & 8) != 0;
        int maxStack = ca.getMaxStack();
        int maxLocals = ca.getMaxLocals();
        BasicBlock top = blocks[0];
        String desc = minfo.getDescriptor();
        top.initFirstBlock(maxStack, maxLocals, pool.getClassName(), desc, isStatic, minfo.isConstructor());
        String retType = BasicBlock.getRetType(desc);
        MapMaker mm = new MapMaker(classes, pool, maxStack, maxLocals, blocks, retType, blocks[0], 0);
        mm.make(ca.getCode(), et);
        return mm;
    }

    MapMaker(ClassPool classes, ConstPool cp, int maxStack, int maxLocals, BasicBlock[] bb, String retType, BasicBlock init, int iterate) {
        this(classes, cp, maxStack, maxLocals, bb, retType, iterate);
        TypeData[] srcTypes = init.localsTypes;
        MapMaker.copyFrom(srcTypes.length, srcTypes, this.localsTypes);
    }

    private MapMaker(ClassPool classes, ConstPool cp, int maxStack, int maxLocals, BasicBlock[] bb, String retType, int iterateNo) {
        super(classes, cp, maxStack, maxLocals, retType);
        this.blocks = bb;
        this.loopDetected = false;
        this.iteration = iterateNo;
    }

    public BasicBlock[] getBlocks() {
        return this.blocks;
    }

    void make(byte[] code, ExceptionTable et) throws BadBytecode {
        this.blocks[0].version = this.iteration++;
        this.make(code, this.blocks[0]);
        if (this.loopDetected) {
            this.blocks[0].version = this.iteration;
            this.make(code, this.blocks[0]);
        }
        int n = this.blocks.length;
        for (int i = 0; i < n; ++i) {
            this.evalExpected(this.blocks[i]);
        }
    }

    private void make(byte[] code, BasicBlock bb) throws BadBytecode {
        int pos;
        int end = pos + bb.length;
        this.traceExceptions(code, bb.catchBlocks);
        this.moveon = true;
        for (pos = bb.position; this.moveon && pos < end; pos += this.doOpcode(pos, code)) {
        }
        if (this.moveon && pos < code.length) {
            this.copyFrom(this);
            this.nextBlock(pos, code, 0);
        }
    }

    private void nextBlock(int pos, byte[] code, int offset) throws BadBytecode {
        BasicBlock bb = BasicBlock.find(this.blocks, pos + offset);
        if (bb.alreadySet(this.iteration)) {
            MapMaker.mergeMap(this.stackTypes, bb.stackTypes);
            MapMaker.mergeMap(this.localsTypes, bb.localsTypes);
            this.mergeUsage(bb);
        } else {
            this.recordStackMap(bb);
            bb.version = this.iteration;
            MapMaker maker = new MapMaker(this.classPool, this.cpool, this.stackTypes.length, this.localsTypes.length, this.blocks, this.returnType, this.iteration);
            maker.copyFrom(this);
            maker.make(code, bb);
            this.recordUsage(bb, maker);
            if (maker.loopDetected) {
                this.loopDetected = true;
            }
        }
    }

    private void traceExceptions(byte[] code, BasicBlock.Branch branches) throws BadBytecode {
        while (branches != null) {
            int pos = branches.target;
            BasicBlock bb = BasicBlock.find(this.blocks, pos);
            if (bb.alreadySet(this.iteration)) {
                MapMaker.mergeMap(this.localsTypes, bb.localsTypes);
                this.mergeUsage(bb);
            } else {
                this.recordStackMap(bb, branches.typeIndex);
                bb.version = this.iteration;
                MapMaker maker = new MapMaker(this.classPool, this.cpool, this.stackTypes.length, this.localsTypes.length, this.blocks, this.returnType, this.iteration);
                maker.stackTypes[0] = bb.stackTypes[0].getSelf();
                maker.stackTop = 1;
                TypeData[] srcTypes = this.localsTypes;
                MapMaker.copyFrom(srcTypes.length, srcTypes, maker.localsTypes);
                maker.make(code, bb);
                this.recordUsage(bb, maker);
                if (maker.loopDetected) {
                    this.loopDetected = true;
                }
            }
            branches = branches.next;
        }
    }

    private static void mergeMap(TypeData[] srcTypes, TypeData[] destTypes) {
        int n = srcTypes.length;
        for (int i = 0; i < n; ++i) {
            TypeData s = srcTypes[i];
            TypeData d = destTypes[i];
            boolean sIsObj = false;
            boolean dIsObj = false;
            if (s != TOP && s.isObjectType()) {
                sIsObj = true;
            }
            if (d != TOP && d.isObjectType()) {
                dIsObj = true;
            }
            if (sIsObj && dIsObj) {
                d.merge(s);
                continue;
            }
            if (s == d) continue;
            destTypes[i] = TOP;
        }
    }

    private void copyFrom(MapMaker src) {
        int sp;
        this.stackTop = sp = src.stackTop;
        MapMaker.copyFrom(sp, src.stackTypes, this.stackTypes);
        TypeData[] srcTypes = src.localsTypes;
        MapMaker.copyFrom(srcTypes.length, srcTypes, this.localsTypes);
    }

    private static int copyFrom(int n, TypeData[] srcTypes, TypeData[] destTypes) {
        int k = -1;
        for (int i = 0; i < n; ++i) {
            TypeData t = srcTypes[i];
            TypeData typeData = destTypes[i] = t == null ? null : t.getSelf();
            if (t == TOP) continue;
            k = t.is2WordType() ? i + 1 : i;
        }
        return k + 1;
    }

    private void recordStackMap(BasicBlock target) throws BadBytecode {
        int n = this.localsTypes.length;
        TypeData[] tLocalsTypes = new TypeData[n];
        int k = MapMaker.copyFrom(n, this.localsTypes, tLocalsTypes);
        n = this.stackTypes.length;
        TypeData[] tStackTypes = new TypeData[n];
        int st = this.stackTop;
        MapMaker.copyFrom(st, this.stackTypes, tStackTypes);
        target.setStackMap(st, tStackTypes, k, tLocalsTypes);
    }

    private void recordStackMap(BasicBlock target, int exceptionType) throws BadBytecode {
        int n = this.localsTypes.length;
        TypeData[] tLocalsTypes = new TypeData[n];
        int k = MapMaker.copyFrom(n, this.localsTypes, tLocalsTypes);
        String type = exceptionType == 0 ? "java.lang.Throwable" : this.cpool.getClassInfo(exceptionType);
        TypeData[] tStackTypes = new TypeData[this.stackTypes.length];
        tStackTypes[0] = new TypeData.ClassName(type);
        target.setStackMap(1, tStackTypes, k, tLocalsTypes);
    }

    private void recordUsage(BasicBlock target, MapMaker next) {
        int[] nextUsage = next.localsUsage;
        TypeData[] tData = target.localsTypes;
        int n = tData.length;
        for (int i = this.blocks[0].numLocals; i < n; ++i) {
            if (nextUsage[i] == 1) {
                this.readLocal(i);
                continue;
            }
            tData[i] = TOP;
        }
        int[] usage = new int[nextUsage.length];
        n = usage.length;
        for (int i = 0; i < n; ++i) {
            usage[i] = nextUsage[i];
        }
        target.localsUsage = usage;
    }

    private void mergeUsage(BasicBlock target) {
        int[] usage = target.localsUsage;
        if (usage == null) {
            this.loopDetected = true;
        } else {
            int n = usage.length;
            for (int i = 0; i < n; ++i) {
                if (usage[i] != 1) continue;
                this.readLocal(i);
            }
        }
    }

    void evalExpected(BasicBlock target) throws BadBytecode {
        ClassPool cp = this.classPool;
        MapMaker.evalExpected(cp, target.stackTop, target.stackTypes);
        TypeData[] types = target.localsTypes;
        if (types != null) {
            MapMaker.evalExpected(cp, types.length, types);
        }
    }

    private static void evalExpected(ClassPool cp, int n, TypeData[] types) throws BadBytecode {
        for (int i = 0; i < n; ++i) {
            TypeData td = types[i];
            if (td == null) continue;
            td.evalExpectedType(cp);
        }
    }

    public StackMapTable toStackMap() {
        BasicBlock[] blocks = this.blocks;
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        int n = blocks.length;
        BasicBlock prev = blocks[0];
        int offsetDelta = prev.length;
        if (prev.inbound > 0) {
            writer.sameFrame(0);
            --offsetDelta;
        }
        for (int i = 1; i < n; ++i) {
            BasicBlock bb = blocks[i];
            if (bb.inbound > 0) {
                bb.resetNumLocals();
                int diffL = MapMaker.stackMapDiff(prev.numLocals, prev.localsTypes, bb.numLocals, bb.localsTypes);
                this.toStackMapBody(writer, bb, diffL, offsetDelta, prev);
                offsetDelta = bb.length - 1;
                prev = bb;
                continue;
            }
            offsetDelta += bb.length;
        }
        return writer.toStackMapTable(this.cpool);
    }

    private void toStackMapBody(StackMapTable.Writer writer, BasicBlock bb, int diffL, int offsetDelta, BasicBlock prev) {
        int stackTop = bb.stackTop;
        if (stackTop == 0) {
            if (diffL == 0) {
                writer.sameFrame(offsetDelta);
                return;
            }
            if (0 > diffL && diffL >= -3) {
                writer.chopFrame(offsetDelta, -diffL);
                return;
            }
            if (0 < diffL && diffL <= 3) {
                int[] data = new int[diffL];
                int[] tags = this.fillStackMap(bb.numLocals - prev.numLocals, prev.numLocals, data, bb.localsTypes);
                writer.appendFrame(offsetDelta, tags, data);
                return;
            }
        } else {
            TypeData td;
            if (stackTop == 1 && diffL == 0) {
                TypeData td2 = bb.stackTypes[0];
                if (td2 == TOP) {
                    writer.sameLocals(offsetDelta, 0, 0);
                } else {
                    writer.sameLocals(offsetDelta, td2.getTypeTag(), td2.getTypeData(this.cpool));
                }
                return;
            }
            if (stackTop == 2 && diffL == 0 && (td = bb.stackTypes[0]) != TOP && td.is2WordType()) {
                writer.sameLocals(offsetDelta, td.getTypeTag(), td.getTypeData(this.cpool));
                return;
            }
        }
        int[] sdata = new int[stackTop];
        int[] stags = this.fillStackMap(stackTop, 0, sdata, bb.stackTypes);
        int[] ldata = new int[bb.numLocals];
        int[] ltags = this.fillStackMap(bb.numLocals, 0, ldata, bb.localsTypes);
        writer.fullFrame(offsetDelta, ltags, ldata, stags, sdata);
    }

    private int[] fillStackMap(int num, int offset, int[] data, TypeData[] types) {
        int realNum = MapMaker.diffSize(types, offset, offset + num);
        ConstPool cp = this.cpool;
        int[] tags = new int[realNum];
        int j = 0;
        for (int i = 0; i < num; ++i) {
            TypeData td = types[offset + i];
            if (td == TOP) {
                tags[j] = 0;
                data[j] = 0;
            } else {
                tags[j] = td.getTypeTag();
                data[j] = td.getTypeData(cp);
                if (td.is2WordType()) {
                    ++i;
                }
            }
            ++j;
        }
        return tags;
    }

    private static int stackMapDiff(int oldTdLen, TypeData[] oldTd, int newTdLen, TypeData[] newTd) {
        int diff = newTdLen - oldTdLen;
        int len = diff > 0 ? oldTdLen : newTdLen;
        if (MapMaker.stackMapEq(oldTd, newTd, len)) {
            if (diff > 0) {
                return MapMaker.diffSize(newTd, len, newTdLen);
            }
            return -MapMaker.diffSize(oldTd, len, oldTdLen);
        }
        return -100;
    }

    private static boolean stackMapEq(TypeData[] oldTd, TypeData[] newTd, int len) {
        for (int i = 0; i < len; ++i) {
            TypeData td = oldTd[i];
            if (!(td == TOP ? newTd[i] != TOP : !oldTd[i].equals(newTd[i]))) continue;
            return false;
        }
        return true;
    }

    private static int diffSize(TypeData[] types, int offset, int len) {
        int num = 0;
        while (offset < len) {
            TypeData td = types[offset++];
            ++num;
            if (td == TOP || !td.is2WordType()) continue;
            ++offset;
        }
        return num;
    }

    protected void visitBranch(int pos, byte[] code, int offset) throws BadBytecode {
        this.nextBlock(pos, code, offset);
    }

    protected void visitGoto(int pos, byte[] code, int offset) throws BadBytecode {
        this.nextBlock(pos, code, offset);
        this.moveon = false;
    }

    protected void visitTableSwitch(int pos, byte[] code, int n, int offsetPos, int defaultOffset) throws BadBytecode {
        this.nextBlock(pos, code, defaultOffset);
        for (int i = 0; i < n; ++i) {
            this.nextBlock(pos, code, ByteArray.read32bit(code, offsetPos));
            offsetPos += 4;
        }
        this.moveon = false;
    }

    protected void visitLookupSwitch(int pos, byte[] code, int n, int pairsPos, int defaultOffset) throws BadBytecode {
        this.nextBlock(pos, code, defaultOffset);
        pairsPos += 4;
        for (int i = 0; i < n; ++i) {
            this.nextBlock(pos, code, ByteArray.read32bit(code, pairsPos));
            pairsPos += 8;
        }
        this.moveon = false;
    }

    protected void visitReturn(int pos, byte[] code) {
        this.moveon = false;
    }

    protected void visitThrow(int pos, byte[] code) {
        this.moveon = false;
    }
}

