/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AbstractAdvice;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyMethodInvocation;

public class PerInstanceAdvice
extends AbstractAdvice {
    private boolean initialized = false;
    AspectDefinition aspectDefinition;

    public PerInstanceAdvice(String adviceName, AspectDefinition a, Advisor advisor) {
        this.aspectDefinition = a;
        this.adviceName = adviceName;
        advisor.addPerInstanceAspect(a);
    }

    public String getName() {
        return this.aspectDefinition.getName() + "." + this.adviceName;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object advisor;
        Object aspect = null;
        if (invocation instanceof CallerInvocation) {
            Object callingObject = ((CallerInvocation)invocation).getCallingObject();
            if (callingObject == null) {
                return invocation.invokeNext();
            }
            Advised advised = (Advised)callingObject;
            advisor = advised._getInstanceAdvisor();
            aspect = advisor.getPerInstanceAspect(this.aspectDefinition);
        } else {
            Object targetObject = invocation.getTargetObject();
            if (targetObject == null) {
                return invocation.invokeNext();
            }
            InstanceAdvisor instanceAdvisor = null;
            if (targetObject instanceof Advised) {
                Advised advised = (Advised)targetObject;
                instanceAdvisor = advised._getInstanceAdvisor();
            } else {
                advisor = invocation.getAdvisor();
                if (advisor == null) {
                    return invocation.invokeNext();
                }
                if (advisor instanceof InstanceAdvisor) {
                    instanceAdvisor = (InstanceAdvisor)advisor;
                } else if (advisor instanceof ClassProxyContainer && invocation instanceof ContainerProxyMethodInvocation) {
                    ContainerProxyMethodInvocation pi = (ContainerProxyMethodInvocation)invocation;
                    instanceAdvisor = pi.getProxy().getInstanceAdvisor();
                } else {
                    return invocation.invokeNext();
                }
            }
            aspect = instanceAdvisor.getPerInstanceAspect(this.aspectDefinition);
        }
        if (!this.initialized) {
            this.init(this.adviceName, aspect.getClass());
            this.initialized = true;
        }
        Method advice = this.resolveAdvice(invocation);
        Object[] args = new Object[]{invocation};
        try {
            return advice.invoke(aspect, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

