/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.util.PayloadKey;

public class FieldMetaData
implements MetaDataResolver {
    HashMap fieldMetaData = new HashMap();

    public boolean hasTag(String tag) {
        Iterator values = this.fieldMetaData.values().iterator();
        while (values.hasNext()) {
            SimpleMetaData map = (SimpleMetaData)values.next();
            if (!map.hasTag(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTag(Field field, String tag) {
        return this.hasTag(field.getName(), tag);
    }

    public synchronized boolean hasTag(String fieldName, String tag) {
        SimpleMetaData meta = this.getFieldMetaData(fieldName);
        if (meta == null) {
            return false;
        }
        return meta.hasTag(tag);
    }

    public void tagField(Field field, Object tag) {
        this.addFieldMetaData(field, tag, (Object)"$tagged$", new Object(), PayloadKey.TRANSIENT);
    }

    public void tagField(String field, Object tag) {
        this.addFieldMetaData(field, tag, (Object)"$tagged$", new Object(), PayloadKey.TRANSIENT);
    }

    public void addFieldMetaData(Field field, Object tag, Object attr, Object value) {
        this.addFieldMetaData(field, tag, attr, value, PayloadKey.MARSHALLED);
    }

    public void addFieldMetaData(Field field, Object tag, Object attr, Object value, PayloadKey type) {
        this.addFieldMetaData(field.getName(), tag, attr, value, type);
    }

    public void addFieldMetaData(String key, Object tag, Object attr, Object value) {
        this.addFieldMetaData(key, tag, attr, value, PayloadKey.MARSHALLED);
    }

    public synchronized void addFieldMetaData(String key, Object tag, Object attr, Object value, PayloadKey type) {
        String fieldName = key;
        SimpleMetaData fieldData = (SimpleMetaData)this.fieldMetaData.get(fieldName);
        if (fieldData == null) {
            fieldData = new SimpleMetaData();
            this.fieldMetaData.put(fieldName, fieldData);
        }
        fieldData.addMetaData(tag, attr, value, type);
    }

    public Object getFieldMetaData(Field field, Object tag, Object attr) {
        SimpleMetaData data = this.getFieldMetaData(field.getName());
        if (data == null) {
            return null;
        }
        return data.getMetaData(tag, attr);
    }

    public synchronized Object getFieldMetaData(String fieldName, Object tag, Object attr) {
        SimpleMetaData fieldData = (SimpleMetaData)this.fieldMetaData.get(fieldName);
        if (fieldData == null) {
            return null;
        }
        return fieldData.getMetaData(tag, attr);
    }

    public synchronized Iterator getFields() {
        return this.fieldMetaData.keySet().iterator();
    }

    public synchronized SimpleMetaData getFieldMetaData(String field) {
        return (SimpleMetaData)this.fieldMetaData.get(field);
    }

    public synchronized void clear() {
        this.fieldMetaData.clear();
    }

    public Object resolve(Invocation invocation, Object tag, Object attr) {
        Field field = ((FieldInvocation)invocation).getField();
        return this.getFieldMetaData(field, tag, attr);
    }

    public synchronized SimpleMetaData getAllMetaData(Invocation invocation) {
        Field field = ((FieldInvocation)invocation).getField();
        return (SimpleMetaData)this.fieldMetaData.get(field);
    }
}

