/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynch;

import java.lang.reflect.InvocationTargetException;
import org.jboss.aspects.asynch.Future;
import org.jboss.aspects.asynch.TimeoutException;

public class FutureProxy
implements Future {
    private Future delegate;
    private boolean released = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegate(Future delegate) {
        FutureProxy futureProxy = this;
        synchronized (futureProxy) {
            this.delegate = delegate;
            if (this.released) {
                delegate.release();
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        FutureProxy futureProxy = this;
        synchronized (futureProxy) {
            if (this.delegate == null) {
                this.released = true;
                return;
            }
        }
        this.delegate.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws InterruptedException, InvocationTargetException {
        FutureProxy futureProxy = this;
        synchronized (futureProxy) {
            if (this.delegate == null) {
                this.wait();
            }
            if (this.delegate == null) {
                throw new RuntimeException("Failed to get delegate and timed out");
            }
            return this.delegate.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long milliseconds) throws TimeoutException, InterruptedException, InvocationTargetException {
        FutureProxy futureProxy = this;
        synchronized (futureProxy) {
            if (this.delegate == null) {
                this.wait(milliseconds);
                if (this.delegate == null) {
                    throw new TimeoutException("Failed to get delegate and timed out");
                }
            }
        }
        return this.delegate.get(milliseconds);
    }

    public boolean isDone() {
        return this.delegate == null || this.delegate.isDone();
    }
}

