/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.util.CollectionsFactory;
import org.jboss.util.JBossObject;

public class AbstractController
extends JBossObject
implements Controller {
    protected List states = CollectionsFactory.createCopyOnWriteList();
    protected Map allContexts = CollectionsFactory.createConcurrentReaderMap();
    protected Map contextsByState = CollectionsFactory.createConcurrentReaderMap();
    protected Set errorContexts = CollectionsFactory.createCopyOnWriteSet();
    protected Set installing = CollectionsFactory.createCopyOnWriteSet();
    protected boolean onDemandEnabled = true;

    public AbstractController() throws Exception {
        this.addState(ControllerState.NOT_INSTALLED, null);
        this.addState(ControllerState.DESCRIBED, null);
        this.addState(ControllerState.INSTANTIATED, null);
        this.addState(ControllerState.CONFIGURED, null);
        this.addState(ControllerState.CREATE, null);
        this.addState(ControllerState.START, null);
        this.addState(ControllerState.INSTALLED, null);
    }

    public void addState(ControllerState state, ControllerState before) {
        if (before == null) {
            this.states.add(state);
        } else {
            int index = this.states.indexOf((Object)before);
            if (index == -1) {
                throw new IllegalStateException((Object)((Object)before) + " is not a state in the controller.");
            }
            this.states.add(index, state);
        }
        this.contextsByState.put(state, CollectionsFactory.createCopyOnWriteSet());
    }

    public synchronized ControllerContext getContext(Object name, ControllerState state) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        ControllerContext result = (ControllerContext)this.allContexts.get(name);
        if (result != null && state != null) {
            int required = this.states.indexOf((Object)state);
            if (required == -1) {
                throw new IllegalArgumentException("Unknown state " + (Object)((Object)state) + " states=" + this.states);
            }
            int current = this.states.indexOf((Object)result.getState());
            if (current < required) {
                return null;
            }
        }
        return result;
    }

    public ControllerContext getInstalledContext(Object name) {
        return this.getContext(name, ControllerState.INSTALLED);
    }

    public synchronized Set getNotInstalled() {
        HashSet result = new HashSet(this.errorContexts);
        int i = 0;
        while (!ControllerState.INSTALLED.equals(this.states.get(i))) {
            Set stateContexts = (Set)this.contextsByState.get(this.states.get(i));
            result.addAll(stateContexts);
            ++i;
        }
        this.errorContexts.clear();
        return result;
    }

    public List getStates() {
        return this.states;
    }

    public synchronized void install(ControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        Object name = context.getName();
        if (name == null) {
            throw new IllegalArgumentException("Null name " + context.toShortString());
        }
        if (this.allContexts.get(name) != null) {
            throw new IllegalStateException("Already installed " + name);
        }
        this.install(context, trace);
    }

    public synchronized void change(ControllerContext context, ControllerState state) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null state");
        }
        this.change(context, state, trace);
    }

    public synchronized void enableOnDemand(ControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.enableOnDemand(context, trace);
    }

    public synchronized ControllerContext uninstall(Object name) {
        ControllerContext context;
        boolean trace = this.log.isTraceEnabled();
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (this.errorContexts.remove(name) && trace) {
            this.log.trace((Object)("Tidied up context in error state: " + name));
        }
        if ((context = (ControllerContext)this.allContexts.get(name)) == null) {
            throw new IllegalStateException("Not installed: " + name);
        }
        if (trace) {
            this.log.trace((Object)("Uninstalling " + context.toShortString()));
        }
        this.uninstallContext(context, ControllerState.NOT_INSTALLED, trace);
        this.allContexts.remove(name);
        return context;
    }

    protected void install(ControllerContext context, boolean trace) throws Throwable {
        Object name = context.getName();
        if (ControllerMode.AUTOMATIC.equals((Object)context.getMode())) {
            context.setRequiredState(ControllerState.INSTALLED);
        }
        if (trace) {
            this.log.trace((Object)("Installing " + context.toShortString()));
        }
        context.setController(this);
        DependencyInfo dependencies = context.getDependencyInfo();
        if (trace) {
            this.log.trace((Object)("Dependencies for " + name + ": " + dependencies.getIDependOn(null)));
        }
        if (!this.incrementState(context, trace)) {
            this.errorContexts.remove(context);
            throw context.getError();
        }
        this.allContexts.put(context.getName(), context);
        this.resolveContexts(trace);
    }

    protected void change(ControllerContext context, ControllerState state, boolean trace) throws Throwable {
        ControllerState fromState = context.getState();
        int currentIndex = this.states.indexOf((Object)fromState);
        int requiredIndex = this.states.indexOf((Object)state);
        if (requiredIndex == -1) {
            throw new IllegalArgumentException("Unknown state: " + (Object)((Object)state));
        }
        if (currentIndex == requiredIndex) {
            if (trace) {
                this.log.trace((Object)("No change required toState=" + state.getStateString() + " " + context.toShortString()));
            }
            return;
        }
        if (trace) {
            this.log.trace((Object)("Change toState=" + state.getStateString() + " " + context.toShortString()));
        }
        context.setRequiredState(state);
        if (currentIndex < requiredIndex) {
            this.resolveContexts(trace);
        } else {
            while (currentIndex > requiredIndex) {
                this.uninstallContext(context, trace);
                currentIndex = this.states.indexOf((Object)context.getState());
            }
        }
    }

    protected void enableOnDemand(ControllerContext context, boolean trace) throws Throwable {
        if (!ControllerMode.ON_DEMAND.equals((Object)context.getMode())) {
            throw new IllegalStateException("Context is not ON DEMAND: " + context.toShortString());
        }
        if (!this.allContexts.containsKey(context.getName())) {
            throw new IllegalStateException("Unknown context: " + context.toShortString());
        }
        if (ControllerState.INSTALLED.equals((Object)context.getRequiredState())) {
            return;
        }
        context.setRequiredState(ControllerState.INSTALLED);
        if (trace) {
            this.log.trace((Object)("Enable onDemand: " + context.toShortString()));
        }
        this.onDemandEnabled = true;
    }

    protected boolean incrementState(ControllerContext context, boolean trace) {
        ControllerState fromState = context.getState();
        Set fromContexts = null;
        int currentIndex = -1;
        if (ControllerState.ERROR.equals((Object)fromState)) {
            this.errorContexts.remove(context);
            try {
                this.install(context, ControllerState.ERROR, ControllerState.NOT_INSTALLED);
            }
            catch (Throwable t) {
                this.log.error((Object)("Error during initial installation: " + context.toShortString()), t);
                context.setError(t);
                this.errorContexts.add(context);
                return false;
            }
            Set notInstalled = (Set)this.contextsByState.get((Object)ControllerState.NOT_INSTALLED);
            notInstalled.add(context);
        } else {
            currentIndex = this.states.indexOf((Object)fromState);
            fromContexts = (Set)this.contextsByState.get((Object)fromState);
            if (!fromContexts.contains(context)) {
                throw new IllegalStateException("Context not found in previous state: " + context.toShortString());
            }
        }
        int toIndex = currentIndex + 1;
        ControllerState toState = (ControllerState)((Object)this.states.get(toIndex));
        Set toContexts = (Set)this.contextsByState.get((Object)toState);
        try {
            this.install(context, fromState, toState);
        }
        catch (Throwable t) {
            this.log.error((Object)("Error installing to " + toState.getStateString() + ": " + context.toShortString()), t);
            this.uninstallContext(context, ControllerState.NOT_INSTALLED, trace);
            context.setError(t);
            this.errorContexts.add(context);
            return false;
        }
        if (fromContexts != null) {
            fromContexts.remove(context);
        }
        toContexts.add(context);
        return true;
    }

    protected void resolveContexts(boolean trace) {
        int i;
        boolean resolutions = true;
        block0: while (resolutions || this.onDemandEnabled) {
            this.onDemandEnabled = false;
            resolutions = false;
            for (i = 0; i < this.states.size() - 1; ++i) {
                ControllerState toState;
                ControllerState fromState = (ControllerState)((Object)this.states.get(i));
                if (!this.resolveContexts(fromState, toState = (ControllerState)((Object)this.states.get(i + 1)), trace)) continue;
                resolutions = true;
                continue block0;
            }
        }
        if (trace) {
            for (i = 0; i < this.states.size() - 1; ++i) {
                ControllerState state = (ControllerState)((Object)this.states.get(i));
                ControllerState nextState = (ControllerState)((Object)this.states.get(i + 1));
                Set stillUnresolved = (Set)this.contextsByState.get((Object)state);
                if (stillUnresolved.isEmpty()) continue;
                Iterator j = stillUnresolved.iterator();
                while (j.hasNext()) {
                    ControllerContext ctx = (ControllerContext)j.next();
                    if (!this.advance(ctx)) continue;
                    this.log.trace((Object)("Still unresolved " + nextState.getStateString() + ": " + ctx));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveContexts(ControllerState fromState, ControllerState toState, boolean trace) {
        boolean resolutions = false;
        Set unresolved = (Set)this.contextsByState.get((Object)fromState);
        Set resolved = this.resolveContexts(unresolved, toState, trace);
        if (!resolved.isEmpty()) {
            Iterator i = resolved.iterator();
            while (i.hasNext()) {
                ControllerContext context = (ControllerContext)i.next();
                Object name = context.getName();
                if (!this.installing.add(context)) {
                    if (!trace) continue;
                    this.log.trace((Object)("Already installing " + name + " for " + toState.getStateString()));
                    continue;
                }
                try {
                    if (trace) {
                        this.log.trace((Object)("Dependencies resolved " + name + " for " + toState.getStateString()));
                    }
                    if (!this.incrementState(context, trace)) continue;
                    resolutions = true;
                    if (!trace) continue;
                    this.log.trace((Object)(name + " " + toState.getStateString()));
                }
                finally {
                    this.installing.remove(context);
                }
            }
        }
        return resolutions;
    }

    protected Set resolveContexts(Set contexts, ControllerState state, boolean trace) {
        HashSet<ControllerContext> result = new HashSet<ControllerContext>();
        if (!contexts.isEmpty()) {
            Iterator i = contexts.iterator();
            while (i.hasNext()) {
                DependencyInfo dependencies;
                ControllerContext ctx = (ControllerContext)i.next();
                if (!this.advance(ctx) || !(dependencies = ctx.getDependencyInfo()).resolveDependencies(this, state)) continue;
                result.add(ctx);
            }
        }
        return result;
    }

    protected void uninstallContext(ControllerContext context, ControllerState toState, boolean trace) {
        ControllerState fromState;
        int currentState;
        int targetState = this.states.indexOf((Object)toState);
        if (targetState == -1) {
            this.log.error((Object)("Internal error unknown state " + (Object)((Object)toState) + " states=" + this.states));
        }
        if ((currentState = this.states.indexOf((Object)(fromState = context.getState()))) == -1) {
            this.log.error((Object)("Internal error during uninstall current state not found: " + context.toShortString()));
        }
        if (targetState > currentState) {
            this.log.error((Object)("Internal error during uninstall: toState=" + (Object)((Object)toState) + " context=" + context.toShortString()));
            return;
        }
        for (int i = currentState; i >= targetState; --i) {
            this.uninstallContext(context, trace);
        }
    }

    protected void uninstallContext(ControllerContext context, boolean trace) {
        int toIndex;
        Set fromContexts;
        Object name = context.getName();
        ControllerState fromState = context.getState();
        int currentIndex = this.states.indexOf((Object)fromState);
        if (trace) {
            this.log.trace((Object)("Uninstalling " + name + " from " + fromState.getStateString()));
        }
        if (!(fromContexts = (Set)this.contextsByState.get((Object)fromState)).remove(context)) {
            throw new IllegalStateException("Context not found in previous state " + fromState.getStateString() + " context=" + context.toShortString());
        }
        DependencyInfo dependencies = context.getDependencyInfo();
        Set dependsOnMe = dependencies.getDependsOnMe(null);
        if (!dependsOnMe.isEmpty()) {
            Iterator i = dependsOnMe.iterator();
            while (i.hasNext()) {
                int actual;
                int proposed;
                ControllerState dependentState;
                DependencyItem item = (DependencyItem)i.next();
                if (!item.isResolved() || (dependentState = item.getDependentState()) != null && !dependentState.equals((Object)fromState)) continue;
                item.unresolved(this);
                ControllerContext dependent = this.getContext(item.getName(), null);
                if (dependent == null) continue;
                ControllerState whenRequired = item.getWhenRequired();
                if (whenRequired == null) {
                    whenRequired = ControllerState.NOT_INSTALLED;
                }
                if ((proposed = this.states.indexOf((Object)whenRequired)) > (actual = this.states.indexOf((Object)dependent.getState()))) continue;
                this.uninstallContext(dependent, whenRequired, trace);
            }
        }
        if ((toIndex = currentIndex - 1) == -1) {
            context.setError(new IllegalStateException("Cannot uninstall from " + (Object)((Object)fromState)));
            return;
        }
        ControllerState toState = (ControllerState)((Object)this.states.get(toIndex));
        Set toContexts = (Set)this.contextsByState.get((Object)toState);
        toContexts.add(context);
        try {
            this.uninstall(context, fromState, toState);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error uninstalling from " + fromState.getStateString() + ": " + context.toShortString()), t);
        }
    }

    protected void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
        context.install(fromState, toState);
    }

    protected void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
        context.uninstall(fromState, toState);
    }

    protected boolean advance(ControllerContext context) {
        ControllerState requiredState;
        int requiredIndex;
        ControllerMode mode = context.getMode();
        if (ControllerMode.DISABLED.equals((Object)mode)) {
            return false;
        }
        ControllerState fromState = context.getState();
        int fromIndex = this.states.indexOf((Object)fromState);
        return fromIndex < (requiredIndex = this.states.indexOf((Object)(requiredState = context.getRequiredState())));
    }
}

