/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynchronous.aspects.jboss;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.joinpoint.MethodInvocation;

public class TraceThreadAspect {
    private static final Log log = LogFactory.getLog((Class)TraceThreadAspect.class);
    private static SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss:SSS aaa z");

    public Object trace(MethodInvocation methodInvocation) throws Throwable {
        String className = null;
        className = methodInvocation.getTargetObject() != null ? methodInvocation.getTargetObject().getClass().getName() : methodInvocation.getMethod().getDeclaringClass().getName();
        StringBuffer txt = new StringBuffer(Thread.currentThread().toString()).append(" ").append(methodInvocation.getMethod().getReturnType().getName()).append(" ").append(className).append(".").append(methodInvocation.getMethod().getName()).append("(");
        Class<?>[] parameterTypes = methodInvocation.getActualMethod().getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            txt.append(parameterTypes[i].getName());
            if (i + 1 >= parameterTypes.length) continue;
            txt.append(",");
        }
        txt.append(")");
        log.info((Object)new StringBuffer("TRACE ENTER: ").append(TraceThreadAspect.getCurrentDate()).append(" ").append(txt));
        Object rsp = methodInvocation.invokeNext();
        log.info((Object)new StringBuffer("TRACE EXIT: ").append(TraceThreadAspect.getCurrentDate()).append(" ").append(txt));
        return rsp;
    }

    public static String getCurrentDate() {
        return formatter.format(new Date(System.currentTimeMillis()));
    }
}

